#include "FSGround.h"

// Draw()
// desc: draws the ball at its current location
void FSGround::Draw()
{
     // draw hockey table
     glPushMatrix();
          
	/*	glBindTexture(GL_TEXTURE_2D, iceTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);*/
		glTranslatef(position.x, position.y, position.z);
          // draw table floor
         
		
		glEnable(GL_TEXTURE_2D);
		glColor3f(1.0, 1.0, 1.0);
		glBindTexture(GL_TEXTURE_2D, ambientTex.texID);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
		
		  
		  glBegin(GL_QUADS);
			  glTexCoord2f(0.0, 0.0);
			  glVertex3d(-7000.0, 0.0, 7000.0);
			  glTexCoord2f(0.0, 6.0);
			  glVertex3d(-7000.0, 0.0, -26000.0);
			  glTexCoord2f(6.0, 6.0);
			  glVertex3d(14000.0, 0.0, -26000.0);
			  glTexCoord2f(6.0, 0.0);
			  glVertex3d(14000.0, 0.0, 7000.0);
          glEnd();
		  
		  
		  glEnable(GL_TEXTURE_2D);
		  glColor3f(1.0, 1.0, 1.0);
		  glBindTexture(GL_TEXTURE_2D, wallTex.texID);
		  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
		  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
		  
		  
		  glBegin(GL_QUADS);
			  glTexCoord2f(0.0, 0.0);
			  glVertex3d(-4500.0, 0.0, 7000.0);
			  glTexCoord2f(0.0, 6.0);
			  glVertex3d(-4500.0, 0.0, -26000.0);
			  glTexCoord2f(6.0, 6.0);
			  glVertex3d(-4500.0, 5000.0, -26000.0);
			  glTexCoord2f(6.0, 0.0);
			  glVertex3d(-4500.0, 5000.0, 7000.0);
          glEnd();
		  
		  
		  for(int i = 0; i < 8; i++)
		  {
			  glBindTexture(GL_TEXTURE_2D, ads[i].texID);
			  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
			  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
			  
			  glPushMatrix();
			  glTranslatef(-500.0, 0.0, -2500.0 * i);
			  glRotatef(-35.0, 0.0, 0.0, -1.0);
			  glBegin(GL_QUADS);
				  glTexCoord2f(0.0, 0.0);
				  glVertex3d(0.0, 0.0, 0.0);
				  glTexCoord2f(1.0, 0.0);
				  glVertex3d(0.0, 0.0, -2048.0);
				  glTexCoord2f(1.0, 1.0);
				  glVertex3d(0.0, 512.0, -2048.0);
				  glTexCoord2f(0.0, 1.0);
				  glVertex3d(0.0, 512.0, 0.0);
			  glEnd();
			  glPopMatrix();
		  }
		  
		  glColor3f(1.0, 1.0, 1.0);
          glBindTexture(GL_TEXTURE_2D, iceTex.texID);
		  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
		  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
		  //glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		  //glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
          glBegin(GL_TRIANGLE_STRIP);
               glTexCoord2f(6.0, 6.0);
               glVertex3fv(&tableCorners[3][0]);
               glTexCoord2f(0.0, 6.0);
               glVertex3fv(&tableCorners[2][0]);
               glTexCoord2f(6.0, 0.0);
               glVertex3fv(&tableCorners[0][0]);
               glTexCoord2f(0.0, 0.0);
               glVertex3fv(&tableCorners[1][0]);
          glEnd();
		  
		  glDisable(GL_TEXTURE_2D);
		  
		  glColor3f(1.0, 1.0, 1.0);
		  glBegin(GL_QUADS);
			  glVertex3d(0.0, 0.0, 0.0);
			  glVertex3d(200.0, 0.0, 0.0);
			  glVertex3d(200.0, 0.0, -19000.0);
			  glVertex3d(0.0, 0.0, -19000.0);
			  
			  glVertex3d(7800.0, 0.0, 0.0);
			  glVertex3d(8000.0, 0.0, 0.0);
			  glVertex3d(8000.0, 0.0, -19000.0);
			  glVertex3d(7800.0, 0.0, -19000.0);
			  
			  glVertex3d(0.0, 0.0, 0.0);
			  glVertex3d(0.0, 0.0, -200.0);
			  glVertex3d(8000.0, 0.0, -200.0);
			  glVertex3d(8000.0, 0.0, 0.0);
			  
			  glVertex3d(0.0, 0.0, -18800.0);
			  glVertex3d(0.0, 0.0, -19000.0);
			  glVertex3d(8000.0, 0.0, -19000.0);
			  glVertex3d(8000.0, 0.0, -18800.0);
			  
			  glVertex3d(0.0, 0.0, -9400.0);
			  glVertex3d(0.0, 0.0, -9600.0);
			  glVertex3d(8000.0, 0.0, -9600.0);
			  glVertex3d(8000.0, 0.0, -9400.0);
			  
			  glVertex3d(2000.0, 0.0, 0.0);
			  glVertex3d(2000.0, 0.0, -2500.0);
			  glVertex3d(2200.0, 0.0, -2500.0);
			  glVertex3d(2200.0, 0.0, -0.0);
			  
			  glVertex3d(5800.0, 0.0, 0.0);
			  glVertex3d(5800.0, 0.0, -2500.0);
			  glVertex3d(6000.0, 0.0, -2500.0);
			  glVertex3d(6000.0, 0.0, -0.0);
			  
			  glVertex3d(2000.0, 0.0, -2300.0);
			  glVertex3d(2000.0, 0.0, -2500.0);
			  glVertex3d(6000.0, 0.0, -2500.0);
			  glVertex3d(6000.0, 0.0, -2300.0);
			  
			  glVertex3d(2000.0, 0.0, -16500.0);
			  glVertex3d(2000.0, 0.0, -19000.0);
			  glVertex3d(2200.0, 0.0, -19000.0);
			  glVertex3d(2200.0, 0.0, -16500.0);
			  
			  glVertex3d(5800.0, 0.0, -16500.0);
			  glVertex3d(5800.0, 0.0, -19000.0);
			  glVertex3d(6000.0, 0.0, -19000.0);
			  glVertex3d(6000.0, 0.0, -16500.0);
			  
			  glVertex3d(2000.0, 0.0, -16700.0);
			  glVertex3d(2000.0, 0.0, -16500.0);
			  glVertex3d(6000.0, 0.0, -16500.0);
			  glVertex3d(6000.0, 0.0, -16700.0);
		  glEnd();
		  
		  
		  glEnable(GL_TEXTURE_2D);
		  
		  glBindTexture(GL_TEXTURE_2D, centerTex.texID);
		  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
		  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
		  
		  glEnable(GL_BLEND);
		  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		  glColor4f(1.0, 1.0, 1.0, 1.0);
		  glBegin(GL_QUADS);
			  glTexCoord2f(0.0, 1.0);
			  glVertex3d(3000.0, 0.0, -8500.0);
			  glTexCoord2f(1.0, 1.0);
			  glVertex3d(3000.0, 0.0, -10500.0);
			  glTexCoord2f(1.0, 0.0);
			  glVertex3d(5000.0, 0.0, -10500.0);
			  glTexCoord2f(0.0, 0.0);
			  glVertex3d(5000.0, 0.0, -8500.0);
          glEnd();
		  glDisable(GL_BLEND);
		  glDisable(GL_TEXTURE_2D);
		  /*
          // enable blending for walls
          glEnable(GL_BLEND);
          glDepthMask(GL_FALSE);
          glBlendFunc(GL_SRC_ALPHA, GL_ONE);

          glColor4f(1.0, 0.0, 0.3, 1.0);
          // left side
          glBegin(GL_TRIANGLE_STRIP);
               glVertex3fv(&tableCorners[1][0]);
               glVertex3f(tableCorners[1][0], 50.0,
                              tableCorners[1][2]);
               glVertex3fv(&tableCorners[0][0]);
               glVertex3f(tableCorners[0][0], 10.0,
                              tableCorners[0][2]);
          glEnd();

          // right side
          glBegin(GL_TRIANGLE_STRIP);
               glVertex3fv(&tableCorners[3][0]);
               glVertex3f(tableCorners[3][0],
                           10.0, tableCorners[3][2]);
               glVertex3fv(&tableCorners[2][0]);
               glVertex3f(tableCorners[2][0], 50.0,
                         tableCorners[2][2]);
          glEnd();

          // opposite side
          glBegin(GL_TRIANGLE_STRIP);
               glVertex3fv(&tableCorners[2][0]);
               glVertex3f(tableCorners[2][0],
                         50.0,
                    tableCorners[2][2]);
               glVertex3fv(&tableCorners[1][0]);
               glVertex3f(tableCorners[1][0],
                         50.0,
                         tableCorners[1][2]);
          glEnd();

          // player side (transparent)
          glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
          glColor4f(0.0, 0.1, 0.3, 0.6);
          glBegin(GL_TRIANGLE_STRIP);
               glVertex3fv(&tableCorners[3][0]);
               glVertex3f(tableCorners[3][0],
                         50.0,
                         tableCorners[3][2]);
               glVertex3fv(&tableCorners[0][0]);
               glVertex3f(tableCorners[0][0],
                         50.0,
                         tableCorners[0][2]);
          glEnd();

          // renable depth testing, disable blending
          glDepthMask(GL_TRUE);
          glDisable(GL_BLEND);*/
     glPopMatrix();
	 
	 
}


// SetupTexture()
// desc: initialize the texture with OpenGL
void FSGround::SetupTexture()
{
     // set the proper parameters for an MD2 texture
     glGenTextures(1, &iceTex.texID);
     glBindTexture(GL_TEXTURE_2D, iceTex.texID);
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
     glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
     
     switch (iceTex.textureType)
     {
     case BMP:
          gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, iceTex.width, iceTex.height, 
               GL_RGB, GL_UNSIGNED_BYTE, iceTex.data);
          break;
     case PCX:
          gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, iceTex.width, iceTex.height,
               GL_RGBA, GL_UNSIGNED_BYTE, iceTex.data);
     case TGA:           // no TGA support
          break;
     default:
          break;
     }
}

// Load()
// desc: initialize table info and setup texture
void FSGround::Load()
{
     // Initialize table corner coordinates
     tableCorners[0][0] = 0.0;
     tableCorners[0][1] = 0.0;
     tableCorners[0][2] = 0.0;

     tableCorners[1][0] = 0.0;
     tableCorners[1][1] = 0.0;
     tableCorners[1][2] = -19000.0;

     tableCorners[2][0] = 8000.0;
     tableCorners[2][1] = 0.0;
     tableCorners[2][2] = -19000.0;

     tableCorners[3][0] = 8000.0;
     tableCorners[3][1] = 0.0;
     tableCorners[3][2] = 0.0;

     
	 groundPlane = FSPlane(
                         FSVector(tableCorners[2][0], tableCorners[2][1], tableCorners[2][2]),
                         FSVector(tableCorners[3][0], tableCorners[3][1], tableCorners[3][2]),
                         FSVector(tableCorners[0][0], tableCorners[0][1], tableCorners[0][2])
                         );
	 
	 // Initialize the table walls (planes)
     // 0 = left, 2 = opposite, 1 = right, 3 = player
     // 1,0 left
     // 3,2 right
     // 2,1 opposite
     // 3,0 player
     tableWalls[0] = FSPlane(
                         FSVector(tableCorners[0][0], tableCorners[0][1], tableCorners[0][2]),
                         FSVector(tableCorners[1][0], tableCorners[1][1], tableCorners[1][2]),
                         FSVector(tableCorners[1][0], 10.0, tableCorners[1][2])
                         );

     tableWalls[1] = FSPlane(
                         FSVector(tableCorners[2][0], tableCorners[2][1], tableCorners[2][2]),
                         FSVector(tableCorners[3][0], tableCorners[3][1], tableCorners[3][2]),
                         FSVector(tableCorners[3][0], 10.0, tableCorners[3][2])
                         );

     tableWalls[2] = FSPlane(
                         FSVector(tableCorners[1][0], tableCorners[1][1], tableCorners[1][2]),
                         FSVector(tableCorners[2][0], tableCorners[2][1], tableCorners[2][2]),
                         FSVector(tableCorners[2][0], 10.0, tableCorners[2][2])
                         );

     tableWalls[3] = FSPlane(
                         FSVector(tableCorners[3][0], tableCorners[3][1], tableCorners[3][2]),
                         FSVector(tableCorners[0][0], tableCorners[0][1], tableCorners[0][2]),
                         FSVector(tableCorners[0][0], 10.0, tableCorners[0][2])
                         );

     // Load and initialize the texture
     
	 iceTex.LoadTexture("ground.tga");
	 wallTex.LoadTexture("wall.tga");
	 ambientTex.LoadTexture("ambient.tga");
	 centerTex.LoadTexture("logo.tga");
	 ads[0].LoadTexture("ads_1.tga");
	 ads[1].LoadTexture("ads_2.tga");
	 ads[2].LoadTexture("ads_3.tga");
	 ads[3].LoadTexture("ads_4.tga");
	 ads[4].LoadTexture("ads_5.tga");
	 ads[5].LoadTexture("ads_6.tga");
	 ads[6].LoadTexture("ads_3.tga");
	 ads[7].LoadTexture("ads_4.tga");
     //SetupTexture();
}

// Unload()
// desc: free texture
void FSGround::Unload()
{
     iceTex.Unload();
}