#ifndef FS_BALL
#define FS_BALL

#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
#include <GLUT/glut.h>
#include <math.h>
#include "FSVector.h"
#include "FSObject.h"
#include "FSTexture.h"
#include "FSPlane.h"
#include "FSGround.h"

enum FSPlayers
{
	FS_NO_PLAYER = 0,
	FS_PLAYER_ONE,
	FS_PLAYER_TWO,
	FS_PLAYER_THREE,
	FS_PLAYER_FOUR,
	FS_PLAYER_FIVE,
	FS_PLAYER_SIX,
	FS_PLAYER_SEVEN,
	FS_PLAYER_EIGHT,
	FS_PLAYER_NINE,
	FS_PLAYER_TEN
};

enum FSStatus
{
	FS_GAME,
	FS_OUT,
	FS_GOAL_ONE,
	FS_GOAL_TWO
};

class FSBall : public FSObject
{
private:
	float	radius;
	
public:
	FSPlayers takenBy;
	FSStatus status;
	
	FSBall();
	
	~FSBall(){}
	
	void Load();
	void Unload();
	
	void Draw();
	void move(int deltaT, FSGround *field);
};

#endif 