/*
 *  FSBall.cpp
 *  FeatheredSoccer
 *
 *  Created by Ludovico Rossi on 10/08/04.
 *  Copyright 2004 __MyCompanyName__. All rights reserved.
 *
 */

#include "FSBall.h"


FSBall::FSBall()
{
	position = FSVector(4590.0, 80.0, -2000.0);
	acceleration = FSVector(0.0, -5050.0, 0.0); 
	velocity = FSVector(0.0, 0.0, 0.0);
}

void FSBall::Draw()
{
	glDisable(GL_TEXTURE_2D);
	glPushMatrix();
	
		glTranslatef(position.x, position.y, position.z);
		glColor3f(0.5, 1.0, 0.5);
		glutSolidSphere(radius, 25, 25);
		
	glPopMatrix();
	glEnable(GL_TEXTURE_2D);
	return;
}

void FSBall::move(int deltaT, FSGround *field)
{
	float time = deltaT / 1000.0f;
	velocity += acceleration * time;
	position += velocity * time + acceleration * (time*time*0.5);
	
	if (position.y < 60 && velocity.y <= 0)
	{
		position.y = 60;
		velocity.y = -velocity.y;//velocity.Reflection((field->groundPlane).N);//-velocity;//velocity.Reflection(field->N);
		velocity *= 0.7;
	}
	
	if(position.x < 0.0)
	{
		if(velocity.Length() < 4000.0)
			velocity = FSVector(0.0, 0.0, 0.0);
		else
			velocity.x = -velocity.x;
		
		position.x = 0.0;		
	}
	else if(position.x > 8000.0)
	{
		if(velocity.Length() < 4000.0)
			velocity = FSVector(0.0, 0.0, 0.0);
		else
		{
			velocity.x = -velocity.x;
			velocity *= 0.6;
		}
		
		position.x = 8000.0;		
	}
	
	if(position.z < -19000)
	{
		if(status == FS_GAME)
		{
			if(position.x > 3000.0 && position.x < 5000.0 && position.y < 1000.0)
				status = FS_GOAL_TWO;
			else
			{
				//status = FS_OUT;
				//printf("%f\n", velocity.Length());
				if(velocity.Length() < 4000.0)
					velocity = FSVector(0.0, 0.0, 0.0);
				else
				{
					velocity.z = -velocity.z;
					velocity *= 0.6;
				}
				
				position.z = -19000.0;
				//velocity = FSVector(0,0,0);
				//printf("out x: %f z: %f\n", position.x, position.z);
			}
		}
		else
		{
			if(status == FS_GOAL_TWO)
			{
				if(position.z < -20000)
				{
					velocity.z = -velocity.z;
					velocity *= 0.3;
					position.z = -19995;
				}
				
				if(position.x < 3000)
				{
					velocity.x = -velocity.x;
					velocity *= 0.3;
					position.x = 3005;
				}
				
				if(position.x > 5000)
				{
					velocity.x = -velocity.x;
					velocity *= 0.3;
					position.x = 4995;
				}
				
				if(position.y > 1000.0)
				{
					velocity.y = -velocity.y;
					velocity *= 0.3;
					position.y = 995.0;
				}
			}
		}
	}
	else if(position.z > 0.0)
	{
		if(status == FS_GAME)
		{
			if(position.x > 3000.0 && position.x < 5000.0 && position.y < 1000.0)
				status = FS_GOAL_ONE;
			else
			{
				//status = FS_OUT;
				//printf("%f\n", velocity.Length());
				if(velocity.Length() < 4000.0)
					velocity = FSVector(0.0, 0.0, 0.0);
				else
					velocity.z = -velocity.z;
				
				position.z = 0.0;
				//velocity = FSVector(0,0,0);
				//printf("out x: %f z: %f\n", position.x, position.z);
			}
		}
		else
		{
			if(status == FS_GOAL_ONE)
			{
				if(position.z > 1000.0)
				{
					velocity.z = -velocity.z;
					velocity *= 0.3;
					position.z = 995.0;
				}
				
				if(position.x < 3000)
				{
					velocity.x = -velocity.x;
					velocity *= 0.3;
					position.x = 3005;
				}
				
				if(position.x > 5000)
				{
					velocity.x = -velocity.x;
					velocity *= 0.3;
					position.x = 4995;
				}
				
				if(position.y > 1000.0)
				{
					velocity.y = -velocity.y;
					velocity *= 0.3;
					position.y = 995.0;
				}
			}
		}
	}
}

void FSBall::Load()
{

	radius = 200.0f;
	takenBy = FS_NO_PLAYER;
	status = FS_GAME;
	
}


void FSBall::Unload()
{

}