/*
 * Decompiled with CFR 0.152.
 */
package com.beenox.javapatcher.ui;

import com.beenox.javapatcher.ui.CarsFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class PatcherWindow
extends JFrame {
    private JTextField fileLocationTextField;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private JPanel fileLocationPanel = new JPanel(new FlowLayout());
    private JLabel mainTextLabel = new JLabel("Please select the location where Cars is installed.");
    private JButton browseButton;
    private JButton patchButton;
    private JButton cancelButton;
    private JPanel actionsPanel;
    private static PatcherWindow instance;

    PatcherWindow() {
        super("Cars Intel Updater");
        this.fileLocationTextField = new JTextField(30);
        this.browseButton = new JButton("Browse...");
        this.patchButton = new JButton("Patch");
        this.cancelButton = new JButton("Cancel");
        this.actionsPanel = new JPanel(new FlowLayout(2));
        JPanel[] jPanelArray = new JPanel[3];
        JLabel jLabel = new JLabel(new ImageIcon(PatcherWindow.class.getResource("Lightning McQueen small.png")));
        for (int i = 0; i < 3; ++i) {
            jPanelArray[i] = new JPanel();
            jPanelArray[i].setPreferredSize(new Dimension(20, 20));
        }
        this.mainPanel.add((Component)this.mainTextLabel, "North");
        this.mainPanel.add((Component)this.fileLocationPanel, "Center");
        this.mainPanel.add((Component)this.actionsPanel, "South");
        this.fileLocationPanel.add(this.fileLocationTextField);
        this.fileLocationPanel.add(this.browseButton);
        this.actionsPanel.add(this.cancelButton);
        this.actionsPanel.add(this.patchButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.mainPanel);
        this.getContentPane().add((Component)jPanelArray[0], "North");
        this.getContentPane().add((Component)jPanelArray[1], "South");
        this.getContentPane().add((Component)jPanelArray[2], "East");
        this.getContentPane().add((Component)jLabel, "West");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(instance.fileLocationTextField.getText());
                if (!(file.exists() || (file = new File("/Applications/THQ/Disney-Pixar/Cars/Cars.app")).exists() || (file = new File("/Applications")).exists())) {
                    file = null;
                }
                JFileChooser jFileChooser = file != null ? new JFileChooser(file) : new JFileChooser();
                jFileChooser.addChoosableFileFilter(new CarsFileFilter());
                int n = jFileChooser.showOpenDialog(instance);
                if (n == 0) {
                    instance.fileLocationTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                    if (jFileChooser.getSelectedFile().exists()) {
                        instance.patchButton.setEnabled(true);
                        PatcherWindow.this.patchButton.grabFocus();
                    }
                }
            }
        });
        this.patchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = instance.fileLocationTextField.getText();
                File file = new File(string);
                if (file.exists()) {
                    if (new CarsFileFilter().accept(file) || JOptionPane.showConfirmDialog(instance, "Are you sure you want to patch file " + file.getAbsolutePath(), "Confirmation", 0) == 0) {
                        if (PatcherWindow.this.copyFile("libBinkMachOx86.dylib", string + "/Contents/MacOS/libBinkMachOx86.dylib") && PatcherWindow.this.copyFile("Cars", string + "/Contents/MacOS/Cars")) {
                            JOptionPane.showMessageDialog(instance, "Patch completed successfully!");
                            System.exit(0);
                        } else {
                            JOptionPane.showMessageDialog(instance, "Patching failed. The update must be run by the same user that installed the game. Alternatively, you may control click the installed copy of Cars, select Get Info and change the owner of the file to yourself.");
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(instance, "Unable to patch: Invalid file");
                }
            }
        });
        this.fileLocationTextField.addCaretListener(new CaretListener(){
            private String prevString;

            public void caretUpdate(CaretEvent caretEvent) {
                if (instance.fileLocationTextField.getText().equals(this.prevString)) {
                    return;
                }
                this.prevString = instance.fileLocationTextField.getText();
                File file = new File(this.prevString);
                if (file.exists()) {
                    PatcherWindow.this.patchButton.setEnabled(true);
                } else {
                    PatcherWindow.this.patchButton.setEnabled(false);
                }
            }
        });
        if (new File("/Applications/THQ/Disney-Pixar/Cars/Cars.app").exists()) {
            this.fileLocationTextField.setText("/Applications/THQ/Disney-Pixar/Cars/Cars.app");
            this.patchButton.setEnabled(true);
        } else {
            this.patchButton.setEnabled(false);
        }
        this.setDefaultCloseOperation(3);
        this.pack();
        this.browseButton.requestFocus();
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        Dimension dimension = this.getSize();
        this.setLocation((int)(rectangle.getWidth() - dimension.getWidth()) / 2, (int)(rectangle.getHeight() - dimension.getHeight()) / 2);
        this.setVisible(true);
    }

    public boolean copyFile(String string, String string2) {
        FileOutputStream fileOutputStream;
        InputStream inputStream;
        URL uRL = PatcherWindow.class.getResource(string);
        if (uRL == null) {
            System.out.println("Unable to open input file " + string + "!");
            return false;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        try {
            fileOutputStream = new FileOutputStream(string2, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        System.out.println("Copying file " + string + " -> " + string2);
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean isResizable() {
        return false;
    }

    public static void main(String[] stringArray) {
        instance = new PatcherWindow();
    }
}

