/*
 * Decompiled with CFR 0.152.
 */
package xap.resources;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.w3c.dom.Element;
import xap.Game;
import xap.HomingMovement;
import xap.Moving;

public class HomingMovementResource
extends Resource {
    public static final long serialVersionUID = 1L;
    private int minAcceleration;
    private int maxAcceleration;
    private int minSpeed;
    private int maxSpeed;
    private int accelerationLevel;
    private int speedLevel;
    private int absMaxAcceleration;
    private int absMaxSpeed;

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.minAcceleration = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"minacceleration"));
        this.maxAcceleration = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"maxacceleration"));
        this.minSpeed = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"minspeed"));
        this.maxSpeed = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"maxspeed"));
        this.accelerationLevel = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"accelerationlevel"));
        this.speedLevel = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"speedlevel"));
        this.absMaxAcceleration = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"absmaxacceleration"));
        this.absMaxSpeed = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"absmaxspeed"));
    }

    public HomingMovement spawn(Moving target) {
        return new HomingMovementInstance(target);
    }

    private class HomingMovementInstance
    implements HomingMovement {
        private Moving target;
        private int x;
        private int y;
        private int initialAcceleration;
        private int acceleration;
        private int initialSpeed;
        private int speed;

        HomingMovementInstance(Moving target) {
            this.target = target;
            this.initialAcceleration = this.acceleration = Util.random((int)HomingMovementResource.this.minAcceleration, (int)HomingMovementResource.this.maxAcceleration) + Game.getCurrentLevel() * HomingMovementResource.this.accelerationLevel;
            this.initialSpeed = this.speed = Util.random((int)HomingMovementResource.this.minSpeed, (int)HomingMovementResource.this.maxSpeed) + Game.getCurrentLevel() * HomingMovementResource.this.speedLevel;
            if (this.acceleration > HomingMovementResource.this.absMaxAcceleration) {
                this.acceleration = HomingMovementResource.this.absMaxAcceleration;
            }
            if (this.speed > HomingMovementResource.this.absMaxSpeed) {
                this.speed = HomingMovementResource.this.absMaxSpeed;
            }
        }

        public void setScale(float scale) {
            this.acceleration = (int)(scale * (float)this.initialAcceleration);
            this.speed = (int)(scale * (float)this.initialSpeed);
        }

        public void setDestination(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void tick() {
            Vector3i position = this.target.getPosition();
            Vector3i velocity = this.target.getVelocity();
            if (this.x < position.getX()) {
                if (velocity.getX() > -this.speed) {
                    velocity.setX(velocity.getX() - this.acceleration << Game.getOptions().getSpeedShift());
                }
            } else if (velocity.getX() < this.speed) {
                velocity.setX(velocity.getX() + this.acceleration << Game.getOptions().getSpeedShift());
            }
            if (this.y < position.getY()) {
                if (velocity.getY() > -this.speed) {
                    velocity.setY(velocity.getY() - this.acceleration << Game.getOptions().getSpeedShift());
                }
            } else if (velocity.getY() < this.speed) {
                velocity.setY(velocity.getY() + this.acceleration << Game.getOptions().getSpeedShift());
            }
            position.translate(velocity.getX() << Game.getOptions().getSpeedShift(), velocity.getY() << Game.getOptions().getSpeedShift(), 0);
        }
    }
}

