/*
 * Decompiled with CFR 0.152.
 */
package xap.modes.standard;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xap.Game;
import xap.Level;
import xap.effects.LabelEffect;
import xap.features.BackgroundFeature;
import xap.features.GidrahFeature;
import xap.features.PowerupFeature;
import xap.modes.standard.StandardAttackWave;
import xap.modes.standard.StandardGameModeFeature;

public class StandardLevelResource
extends Resource
implements Level {
    public static final long serialVersionUID = 1L;
    private static final HashMap waveTagMap;
    private static final String DEFAULT_STRAP = "Prepare to Battle!";
    private static final int WAVE_ARRIVES = 1000;
    private static final int MIN_WAVE_ARRIVES = 800;
    private static final int WAVE_DIFFICULTY = 10;
    private ArrayList attackWaves = new ArrayList(4);
    private String heartbeat;
    private String background;
    private String strap;
    private transient int currentWave = 0;
    private transient boolean levelEnded;
    private transient BackgroundFeature backgroundFeature;
    private transient ALBuffer heartbeatBuffer;
    private transient int tick;
    private transient ColorSequenceResource levelBeginColorSeq;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("xap.modes.standard.StandardLevelResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        waveTagMap = new HashMap();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("xap.modes.standard.StandardAttackWave");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        waveTagMap.put("attackwave", clazz2);
    }

    private StandardLevelResource() {
    }

    public StandardLevelResource(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        try {
            this.heartbeat = XMLUtil.getString((Element)element, (String)"heartbeat", (String)"heartbeat.buffer");
            this.background = XMLUtil.getString((Element)element, (String)"background");
            this.strap = XMLUtil.getString((Element)element, (String)"strap", (String)DEFAULT_STRAP);
            loader.pushMap((Map)waveTagMap);
            NodeList childTagList = element.getChildNodes();
            int i = 0;
            while (i < childTagList.getLength()) {
                if (childTagList.item(i) instanceof Element) {
                    Element childElement = (Element)childTagList.item(i);
                    Resource childResource = loader.load(childElement);
                    if (!(childResource instanceof StandardAttackWave)) {
                        throw new Exception("Only AttackWave resources are allowed inside a Level");
                    }
                    this.attackWaves.add(childResource);
                }
                ++i;
            }
        }
        finally {
            loader.popMap();
        }
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        Iterator i = this.attackWaves.iterator();
        while (i.hasNext()) {
            ((StandardAttackWave)((Object)i.next())).create();
        }
        this.levelBeginColorSeq = (ColorSequenceResource)Resources.get((String)"level_begin.colorseq");
    }

    protected void doDestroy() {
        super.doDestroy();
        this.heartbeatBuffer = null;
    }

    public static StandardLevelResource createRandomLevel(int num, String heartbeat, String bubbles, ArrayList eolgs, StandardGameModeFeature sgmf) throws Exception {
        BackgroundFeature newBackground;
        StandardLevelResource newLevel = new StandardLevelResource();
        newLevel.backgroundFeature = newBackground = BackgroundFeature.createRandom();
        newLevel.strap = DEFAULT_STRAP;
        newLevel.heartbeat = heartbeat;
        int numWaves = Math.min(8, 4 + num / 5);
        newLevel.attackWaves = new ArrayList(numWaves);
        int i = 0;
        while (i < numWaves) {
            newLevel.attackWaves.add(StandardLevelResource.createRandomAttackWave(bubbles, sgmf));
            ++i;
        }
        if (num % 5 == 4) {
            newLevel.attackWaves.add(StandardLevelResource.createEOLGAttackWave(num, eolgs));
        }
        newLevel.create();
        return newLevel;
    }

    public static StandardAttackWave createEOLGAttackWave(int level, ArrayList eolgs) {
        int numEolgs = level / Game.getGameMode().getNumberOfLevels() + 1;
        ArrayList aliens = new ArrayList(numEolgs);
        int idx = level / 5 % eolgs.size();
        int i = 0;
        while (i < numEolgs) {
            aliens.add(eolgs.get(idx));
            idx = Util.random((int)0, (int)(eolgs.size() - 1));
            ++i;
        }
        return new StandardAttackWave(aliens, null);
    }

    public static StandardAttackWave createRandomAttackWave(String bubbles, StandardGameModeFeature sgmf) {
        ArrayList<String> aliens = new ArrayList<String>(8);
        int i = 0;
        while (i < 8) {
            aliens.add(sgmf.getRandomGidrahFeature());
            ++i;
        }
        return new StandardAttackWave(aliens, bubbles);
    }

    public void begin() throws Exception {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError();
        }
        this.currentWave = 0;
        this.levelEnded = false;
        if (Game.hasSound()) {
            Game.allocateBackgroundSound((ALBuffer)Resources.get((String)"level_begin.buffer"), this);
            if (this.heartbeatBuffer == null) {
                this.heartbeatBuffer = (ALBuffer)Resources.get((String)this.heartbeat);
            }
            Game.playMusic(this.heartbeatBuffer, 300);
        }
        this.currentWave = -1;
        if (this.backgroundFeature == null) {
            this.backgroundFeature = (BackgroundFeature)Resources.get((String)this.background);
        }
        LabelEffect.spawn(FPMath.fpValue((int)400), FPMath.fpValue((int)36), 0, FPMath.TWO << Game.getOptions().getSpeedShift(), (GLFont)Resources.get((String)"impact-plain-24.glfont"), this.levelBeginColorSeq, "Level " + (Game.getCurrentLevel() + 1), true);
        LabelEffect.spawn(FPMath.fpValue((int)400), 0, 0, FPMath.TWO << Game.getOptions().getSpeedShift(), (GLFont)Resources.get((String)"impact-plain-32.glfont"), this.levelBeginColorSeq, this.strap, true);
    }

    public GLRenderable getBackground() {
        return this.backgroundFeature;
    }

    public void tick() {
        if (!$assertionsDisabled && this.levelEnded) {
            throw new AssertionError();
        }
        this.tick += Game.getOptions().getTicksPerFrame();
        if (!this.isLastAttackWave()) {
            if (GidrahFeature.getNumGidrahs() <= 4 || this.tick > this.whenNextWaveArrives()) {
                ++this.currentWave;
                this.tick = 0;
                try {
                    this.beginWave();
                }
                catch (Exception e) {
                    Game.handleException(e);
                }
            }
        } else if (this.currentWave == this.attackWaves.size() - 1 && GidrahFeature.getNumGidrahs() == 0 && PowerupFeature.getNumImportantPowerups() == 0 && !this.levelEnded) {
            this.levelEnded = true;
            try {
                Game.getGameMode().doEndLevel();
            }
            catch (Exception e) {
                Game.handleException(e);
            }
        }
    }

    private boolean isLastAttackWave() {
        return this.currentWave == this.attackWaves.size() - 1;
    }

    private void beginWave() throws Exception {
        StandardAttackWave wave = (StandardAttackWave)((Object)this.attackWaves.get(this.currentWave));
        if (!wave.isCreated()) {
            wave.create();
        }
        wave.spawnGidrahs();
    }

    public boolean isFinished() {
        return this.levelEnded;
    }

    private int whenNextWaveArrives() {
        int difficulty;
        int currentLevel = Game.getGameMode().getCurrentLevel();
        if (currentLevel < (difficulty = Game.getGameMode().getDifficultyLevel())) {
            return 1000;
        }
        return Math.max(800, 1000 - 10 * (currentLevel - difficulty));
    }

    public void finish() {
        this.levelEnded = true;
    }
}

