/*
 * Decompiled with CFR 0.152.
 */
package xap.modes.standard;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.rmi.Naming;
import java.rmi.RemoteException;
import org.w3c.dom.Element;
import xap.modes.standard.AlienFluxHiScoreServerRemote;
import xap.modes.standard.StandardHiScoreTable;

public final class StandardHiScoreServerResource
extends Resource {
    public static final long serialVersionUID = 1L;
    private static StandardHiScoreServerResource hiScoreServer;
    private String host;
    private transient AlienFluxHiScoreServerRemote server;

    public void register() {
        super.register();
        hiScoreServer = this;
    }

    public void deregister() {
        super.deregister();
        hiScoreServer = null;
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        try {
            this.server = (AlienFluxHiScoreServerRemote)Naming.lookup("rmi://" + this.host + "/" + "alienflux_hiscoreserver");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.host = XMLUtil.getString((Element)element, (String)"host");
    }

    public static synchronized boolean submitHiScores(StandardHiScoreTable score) throws Exception {
        try {
            if (!hiScoreServer.isCreated()) {
                hiScoreServer.create();
            }
            if (StandardHiScoreServerResource.hiScoreServer.server == null) {
                return false;
            }
            System.out.println("Submitting hiscore " + score);
            return StandardHiScoreServerResource.hiScoreServer.server.submitStandardHiScores(score);
        }
        catch (RemoteException e) {
            hiScoreServer.destroy();
            throw e;
        }
    }
}

