/*
 * Decompiled with CFR 0.152.
 */
package xap.modes.standard;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.CosineInterpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.StaticSpriteEngine;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import xap.Blob;
import xap.Feature;
import xap.Game;
import xap.features.BlobFeature;
import xap.gui.Component;
import xap.gui.Dialog;
import xap.gui.Label;
import xap.gui.MouseAdapter;

public class StandardEndOfLevelFeature
extends Feature {
    public static final long serialVersionUID = 1L;
    private static StandardEndOfLevelFeature feature;
    private static final int MESSAGE = 0;
    private static final int BONUS = 1;
    private static final int WAITING = 2;
    private static final int CLOSING = 3;
    private static final int DONE = 4;
    private transient EndOfLevelDialog instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.modes.standard.StandardEndOfLevelFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public StandardEndOfLevelFeature() {
    }

    public StandardEndOfLevelFeature(String name) {
        super(name);
    }

    public void register() {
        super.register();
        if (!$assertionsDisabled && feature != null) {
            throw new AssertionError();
        }
        feature = this;
    }

    public void deregister() {
        super.deregister();
        feature = null;
    }

    public void onEndLevel() throws Exception {
        this.instance = new EndOfLevelDialog();
        this.instance.open();
    }

    public void onGameOver() throws Exception {
        super.onGameOver();
        if (this.instance != null) {
            this.instance.close();
        }
    }

    private class EndOfLevelDialog
    extends Dialog {
        private int phase;
        private int tick;
        private static final int BLOB_SPACING = 80;
        private Label endOfLevelMessageLabel;
        private Label blobsRemainingLabel;
        private Label bonusPointsLabel;
        private GLFont font;
        private StaticSpriteEngine spriteEngine;
        private BlobFeature blobFeature;
        private int delayResInDuration;
        private int delayResOutDuration;
        private int totalBonus;
        private boolean doNextPhase;
        private int phaseAdvanceTick;
        private static final int DELAY_RES_IN = 0;
        private static final int RES_IN = 1;
        private static final int ANIMATE = 2;
        private static final int DELAY_RES_OUT = 3;
        private static final int RES_OUT = 4;
        private static final int BONUS_DONE = 5;
        private final ArrayList blobBonuses;
        private final EventHandler eventHandler;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.modes.standard.StandardEndOfLevelFeature$EndOfLevelDialog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public EndOfLevelDialog() throws Exception {
            super("EOL Bonus");
            this.endOfLevelMessageLabel = new Label();
            this.blobsRemainingLabel = new Label();
            this.bonusPointsLabel = new Label();
            this.blobBonuses = new ArrayList(16);
            this.eventHandler = new EventHandler();
            this.font = (GLFont)Resources.get((String)"impact-plain-24.glfont");
            this.blobFeature = (BlobFeature)Resources.get((String)"blob");
            this.setSize(800, 600);
            this.startPhase();
            this.addMouseListener(this.eventHandler);
            this.spriteEngine = new StaticSpriteEngine(false, 32, Game.getOptions().getTicksPerFrame());
            this.spriteEngine.create();
        }

        public void nextPhase() {
            this.endPhase();
            ++this.phase;
            this.startPhase();
        }

        private void startPhase() {
            this.tick = 0;
            switch (this.phase) {
                case 0: {
                    Game.getPlayer().endLevel();
                    this.endOfLevelMessageLabel.setFont(this.font);
                    this.endOfLevelMessageLabel.setText("End of level " + (Game.getCurrentLevel() + 1));
                    this.endOfLevelMessageLabel.setSize(800, 50);
                    this.endOfLevelMessageLabel.setAlignment(1);
                    this.endOfLevelMessageLabel.setLocation(0, 400);
                    this.endOfLevelMessageLabel.setDelegate(this);
                    this.addChild(this.endOfLevelMessageLabel);
                    break;
                }
                case 1: {
                    try {
                        Game.getGameMode().doIntermission();
                    }
                    catch (Exception e) {
                        Game.handleException(e);
                    }
                    int blobBonusesWidth = BlobFeature.getNumBlobs() * 80 - 80;
                    int i = 0;
                    while (i < BlobFeature.getNumBlobs()) {
                        this.blobBonuses.add(new BlobBonus(i * 80 + (800 - blobBonusesWidth >> 1), 260, BlobFeature.getBlob(i)));
                        ++i;
                    }
                    this.blobsRemainingLabel.setFont(this.font);
                    switch (BlobFeature.getNumBlobs()) {
                        case 0: {
                            this.blobsRemainingLabel.setText("No Fluffies remain alive!");
                            break;
                        }
                        case 1: {
                            this.blobsRemainingLabel.setText("Only " + BlobFeature.getBlob(0).getCuteName() + " remains alive");
                            break;
                        }
                        default: {
                            this.blobsRemainingLabel.setText(String.valueOf(BlobFeature.getNumBlobs()) + " Fluffies remain alive");
                        }
                    }
                    this.blobsRemainingLabel.setSize(800, 50);
                    this.blobsRemainingLabel.setAlignment(1);
                    this.blobsRemainingLabel.setLocation(0, 300);
                    this.blobsRemainingLabel.setDelegate(this);
                    this.addChild(this.blobsRemainingLabel);
                    this.bonusPointsLabel.setFont(this.font);
                    this.bonusPointsLabel.setText("");
                    this.bonusPointsLabel.setSize(800, 50);
                    this.bonusPointsLabel.setAlignment(1);
                    this.bonusPointsLabel.setLocation(0, 160);
                    this.bonusPointsLabel.setDelegate(this);
                    this.addChild(this.bonusPointsLabel);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    int n = this.blobBonuses.size();
                    int i = 0;
                    while (i < n) {
                        ((BlobBonus)this.blobBonuses.get(i)).nextPhase();
                        ++i;
                    }
                    break;
                }
                case 4: {
                    this.close();
                    try {
                        Game.getGameMode().doNewLevel();
                    }
                    catch (Exception e) {
                        Game.handleException(e);
                    }
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        private void endPhase() {
            switch (this.phase) {
                case 0: {
                    break;
                }
                case 1: {
                    int n = this.blobBonuses.size();
                    int i = 0;
                    while (i < n) {
                        ((BlobBonus)this.blobBonuses.get(i)).finishResIn();
                        ++i;
                    }
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.spriteEngine.clear();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        protected boolean doTick() {
            super.doTick();
            ++this.phaseAdvanceTick;
            if (this.phaseAdvanceTick > 200) {
                this.phaseAdvanceTick = 0;
                if (this.phase < 3) {
                    this.nextPhase();
                }
            }
            int n = this.blobBonuses.size();
            int i = 0;
            while (i < n) {
                ((BlobBonus)this.blobBonuses.get(i)).tick();
                ++i;
            }
            this.spriteEngine.tick();
            switch (this.phase) {
                case 1: {
                    i = 0;
                    while (i < n) {
                        if (!((BlobBonus)this.blobBonuses.get(i)).isReady()) {
                            return true;
                        }
                        ++i;
                    }
                    this.nextPhase();
                    break;
                }
                case 3: {
                    i = 0;
                    while (i < n) {
                        if (!((BlobBonus)this.blobBonuses.get(i)).isDone()) {
                            return true;
                        }
                        ++i;
                    }
                    this.nextPhase();
                    this.doNextPhase = true;
                    break;
                }
            }
            return true;
        }

        protected void renderSelf() {
            super.renderSelf();
            int n = this.blobBonuses.size();
            int i = 0;
            while (i < n) {
                ((BlobBonus)this.blobBonuses.get(i)).render();
                ++i;
            }
            this.spriteEngine.render();
        }

        private class BlobBonus {
            int x;
            int y;
            int tick;
            int duration;
            int phase;
            Sprite sprite;
            Sprite shadowSprite;
            Blob blob;
            boolean advanced;
            static final /* synthetic */ boolean $assertionsDisabled;
            static /* synthetic */ Class class$0;

            static {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("xap.modes.standard.StandardEndOfLevelFeature$EndOfLevelDialog$BlobBonus");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                $assertionsDisabled = !clazz.desiredAssertionStatus();
            }

            BlobBonus(int x, int y, Blob blob) {
                this.x = x;
                this.y = y;
                this.blob = blob;
                this.duration = EndOfLevelDialog.this.delayResInDuration;
                EndOfLevelDialog endOfLevelDialog2 = EndOfLevelDialog.this;
                endOfLevelDialog2.delayResInDuration = endOfLevelDialog2.delayResInDuration + 5;
                this.phase = 0;
                this.sprite = EndOfLevelDialog.this.spriteEngine.allocate((Object)this);
                this.sprite.setActive(false);
                this.shadowSprite = EndOfLevelDialog.this.spriteEngine.allocate((Object)this);
                this.shadowSprite.setActive(false);
                this.shadowSprite.setScale(FPMath.TWO);
                this.shadowSprite.setLayer(-2);
            }

            boolean isDone() {
                return this.phase == 5;
            }

            boolean isReady() {
                return this.phase == 2;
            }

            void tick() {
                if (this.duration == -1) {
                    return;
                }
                ++this.tick;
                this.tick += Game.getOptions().getSpeedShift();
                if (this.tick > this.duration) {
                    this.nextPhase();
                }
            }

            void endPhase() {
                switch (this.phase) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        this.sprite.deallocate();
                        this.sprite = null;
                        this.shadowSprite.deallocate();
                        this.shadowSprite = null;
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }

            void startPhase() {
                this.tick = 0;
                switch (this.phase) {
                    case 1: {
                        this.duration = 15;
                        break;
                    }
                    case 2: {
                        int bonus = 100 + Game.getCurrentLevel() * 50;
                        if (this.blob.isGolden()) {
                            bonus *= 10;
                        }
                        EndOfLevelDialog endOfLevelDialog = EndOfLevelDialog.this;
                        endOfLevelDialog.totalBonus = endOfLevelDialog.totalBonus + bonus;
                        EndOfLevelDialog.this.bonusPointsLabel.setText("Bonus " + EndOfLevelDialog.this.totalBonus);
                        Game.getGameMode().addScore(bonus);
                        Game.getGameMode().onBlobBonus();
                        this.duration = -1;
                        this.sprite.setActive(true);
                        this.shadowSprite.setActive(true);
                        this.sprite.setLocation(this.x, this.y, 0);
                        this.shadowSprite.setLocation(this.x, this.y, 0);
                        this.sprite.setAnimation(EndOfLevelDialog.this.blobFeature.getBlobAnimationResource());
                        this.shadowSprite.setAnimation(EndOfLevelDialog.this.blobFeature.getBlobShadowAnimationResource());
                        if (!this.advanced) {
                            EndOfLevelDialog.this.blobFeature.squeak(new Vector3i(FPMath.fpValue((int)(this.x - 400)) + Game.getPlayer().getPosition().getX(), 0, 0));
                        }
                        Label nameLabel = new Label(this.blob.getCuteName());
                        nameLabel.setForegroundColor(new Color(255, 255, 255, 255));
                        nameLabel.setAlignment(1);
                        nameLabel.setLocation(this.x - 40, this.y - 48);
                        nameLabel.pack().setWidth(80).layout();
                        nameLabel.setDelegate(EndOfLevelDialog.this);
                        EndOfLevelDialog.this.addChild(nameLabel);
                        break;
                    }
                    case 3: {
                        this.duration = EndOfLevelDialog.this.delayResOutDuration;
                        EndOfLevelDialog endOfLevelDialog = EndOfLevelDialog.this;
                        endOfLevelDialog.delayResOutDuration = endOfLevelDialog.delayResOutDuration + 5;
                        break;
                    }
                    case 4: {
                        this.duration = 15;
                        break;
                    }
                    case 5: {
                        this.duration = -1;
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }

            void nextPhase() {
                this.endPhase();
                ++this.phase;
                this.startPhase();
            }

            void render() {
                switch (this.phase) {
                    case 1: {
                        this.renderResIn();
                        break;
                    }
                    case 4: {
                        this.renderResOut();
                        break;
                    }
                    case 0: 
                    case 2: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }

            void renderResIn() {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glBegin((int)8);
                float innerRadius = CosineInterpolator.instance.interpolate(512.0f, 0.0f, (float)this.tick / (float)this.duration);
                float outerRadius = CosineInterpolator.instance.interpolate(512.0f, 0.0f, (float)(this.tick - 1) / (float)this.duration);
                int i = 0;
                while (i <= 65536) {
                    GL11.glColor4ub((byte)0, (byte)0, (byte)-1, (byte)((byte)LinearInterpolator.instance.interpolate(0.0f, 255.0f, (float)this.tick / (float)this.duration)));
                    GL11.glVertex2f((float)((float)this.x + FPMath.floatValue((int)FPMath.cos((int)i)) * innerRadius), (float)((float)this.y + FPMath.floatValue((int)FPMath.sin((int)i)) * innerRadius));
                    GL11.glColor4ub((byte)0, (byte)0, (byte)-1, (byte)0);
                    GL11.glVertex2f((float)((float)this.x + FPMath.floatValue((int)FPMath.cos((int)i)) * outerRadius), (float)((float)this.y + FPMath.floatValue((int)FPMath.sin((int)i)) * outerRadius));
                    i += 1024;
                }
                GL11.glEnd();
            }

            void renderResOut() {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glBegin((int)8);
                float innerRadius = CosineInterpolator.instance.interpolate(0.0f, 512.0f, (float)this.tick / (float)this.duration);
                float outerRadius = CosineInterpolator.instance.interpolate(0.0f, 512.0f, (float)(this.tick - 1) / (float)this.duration);
                int i = 0;
                while (i <= 65536) {
                    GL11.glColor4ub((byte)-1, (byte)0, (byte)-1, (byte)0);
                    GL11.glVertex2f((float)((float)this.x + FPMath.floatValue((int)FPMath.cos((int)i)) * innerRadius), (float)((float)this.y + FPMath.floatValue((int)FPMath.sin((int)i)) * innerRadius));
                    GL11.glColor4ub((byte)-1, (byte)0, (byte)-1, (byte)((byte)LinearInterpolator.instance.interpolate(255.0f, 0.0f, (float)this.tick / (float)this.duration)));
                    GL11.glVertex2f((float)((float)this.x + FPMath.floatValue((int)FPMath.cos((int)i)) * outerRadius), (float)((float)this.y + FPMath.floatValue((int)FPMath.sin((int)i)) * outerRadius));
                    i += 1024;
                }
                GL11.glEnd();
            }

            void finishResIn() {
                switch (this.phase) {
                    case 0: 
                    case 1: {
                        this.endPhase();
                        this.phase = 2;
                        this.advanced = true;
                        this.startPhase();
                    }
                }
            }
        }

        private class EventHandler
        extends MouseAdapter {
            EventHandler() {
            }

            public boolean leftButtonClicked(Component src, int x, int y, int clickCount) {
                if (EndOfLevelDialog.this.phase >= 3) {
                    return false;
                }
                EndOfLevelDialog.this.nextPhase();
                return false;
            }
        }
    }
}

