/*
 * Decompiled with CFR 0.152.
 */
package xap.menu;

import java.rmi.Naming;
import java.util.prefs.Preferences;
import net.puppygames.gamecommerce.shared.ConfigurationDetails;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import net.puppygames.gamecommerce.shared.RegistrationServerRemote;
import xap.Game;
import xap.gui.Editor;
import xap.gui.EditorListener;
import xap.gui.Label;
import xap.gui.MessageBox;
import xap.gui.MessageBoxListener;
import xap.gui.OKCancelListener;
import xap.gui.OKCancelPanel;
import xap.gui.TextArea;
import xap.gui.TextField;
import xap.gui.Window;
import xap.menu.HelpWindow;

public class RegisterWindow
extends Window {
    private TextArea instructions;
    private Label emailLabel;
    private TextField emailTextField;
    private Label authCode;
    private TextField authCodeTextField;
    private OKCancelPanel okCancelPanel;
    private int phase;
    private static final int NORMAL = 0;
    private static final int WAITING = 1;
    private static final int SUCCESS = 2;
    private static final int FAILURE = 3;
    private static final int CANCELLED = 4;
    private final EventHandler eventHandler = new EventHandler();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.menu.RegisterWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public RegisterWindow() throws Exception {
        super("Registration");
        this.createGUI();
        this.initEvents();
    }

    private void createGUI() throws Exception {
        this.instructions = new TextArea("This copy of Alien Flux is not yet registered. If you have purchased the full version, you need to register on-line with Puppy Games. Please ensure that you are connected to the internet and enter your e-mail address and the authorisation code that was sent to you when you purchased Alien Flux.");
        this.emailLabel = new Label("Your e-mail address");
        this.emailTextField = new TextField(64);
        this.authCode = new Label("Your authorisation code");
        this.authCodeTextField = new TextField(14);
        this.okCancelPanel = new OKCancelPanel("OK", "I haven't bought Alien Flux yet!");
        this.addChild(this.instructions);
        this.addChild(this.emailLabel);
        this.addChild(this.emailTextField);
        this.addChild(this.authCode);
        this.addChild(this.authCodeTextField);
        this.emailLabel.setAlignment(2);
        this.authCode.setAlignment(2);
        this.authCode.pack();
        this.emailLabel.pack();
        int w = Math.max(this.authCode.getWidth(), this.emailLabel.getWidth());
        this.authCode.setWidth(w);
        this.emailLabel.setWidth(w);
        this.emailTextField.pack().setWidth(250);
        this.authCodeTextField.pack().setWidth(250);
        this.authCode.setLocation(0, this.okCancelPanel.getY() + 60);
        this.emailLabel.setLocation(0, this.authCode.getY() + this.authCode.getHeight() + 5);
        this.authCodeTextField.setLocation(this.authCode.getWidth() + 5, this.authCode.getY());
        this.emailTextField.setLocation(this.emailLabel.getWidth() + 5, this.emailLabel.getY());
        this.pack();
        this.instructions.setWidth(this.getWidth()).layout();
        this.instructions.setLocation(0, this.emailLabel.getY() + this.emailLabel.getHeight() + 5);
        this.layout();
        this.pack();
        this.addChild(this.okCancelPanel);
        this.okCancelPanel.layout();
        this.pack();
        this.setBorder(5, 5, 5, 5);
        this.centre();
    }

    private void initEvents() {
        this.emailTextField.addEditorListener(this.eventHandler);
        this.authCodeTextField.addEditorListener(this.eventHandler);
        this.okCancelPanel.addOkCancelListener(this.eventHandler);
        this.enableControls();
    }

    private void enableControls() {
        this.okCancelPanel.setOKEnabled(this.authCodeTextField.getText().length() == 14 && this.emailTextField.getText().length() > 5);
    }

    private void doRegistration() throws Exception {
        final MessageBox mbox = new MessageBox("Registering", "Please wait while Alien Flux contacts the registration server and downloads your registration. This will take less than a minute.", 0, 1, null);
        mbox.setMessageBoxListener(new MessageBoxListener(){

            public void messageBoxChoiceMade(MessageBox mbox, int choice) {
                RegisterWindow.this.setPhase(0);
            }
        });
        mbox.open();
        new Thread(){
            {
                this.setDaemon(true);
                this.setPriority(6);
            }

            public void run() {
                try {
                    RegisterWindow.this.setPhase(1);
                    System.out.println("Looking up remote registration server");
                    RegistrationServerRemote server = (RegistrationServerRemote)Naming.lookup("//67.18.194.226/registration");
                    System.out.println("Performing registration");
                    RegistrationDetails registrationDetails = server.register(RegisterWindow.this.emailTextField.getText().trim(), RegisterWindow.this.authCodeTextField.getText().trim(), "Alien Flux", "1.6", Game.getAffiliate(), (ConfigurationDetails)Game.getConfiguration());
                    System.out.println("Success");
                    mbox.close();
                    Game.setRegistrationDetails(registrationDetails);
                    RegisterWindow.this.setPhase(2);
                }
                catch (Exception e) {
                    mbox.close();
                    e.printStackTrace();
                    RegisterWindow.this.setPhase(3);
                }
            }
        }.start();
    }

    private synchronized void setPhase(int newPhase) {
        if ((this.phase == 0 || this.phase == 4) && newPhase == 3) {
            return;
        }
        this.phase = newPhase;
    }

    private synchronized int getPhase() {
        return this.phase;
    }

    protected boolean doTick() {
        super.doTick();
        switch (this.getPhase()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.setPhase(0);
                try {
                    new MessageBox("Registration Success", "Congratulations! Your copy of Alien Flux has been successfully registered to you. You should now remain online if you wish to use the online hiscore server. Enjoy the game!", 0, 0, new MessageBoxListener(){

                        public void messageBoxChoiceMade(MessageBox mbox, int choice) {
                            RegisterWindow.this.close();
                        }
                    }).open();
                }
                catch (Exception e) {
                    Game.handleException(e);
                }
                break;
            }
            case 3: {
                this.setPhase(0);
                try {
                    new MessageBox("Registration Failed", "Your registration didn't work for some reason! Please try again and carefully check your typing, or contact support@puppygames.net and ask for help.", 0, 0, null).open();
                }
                catch (Exception e) {
                    Game.handleException(e);
                }
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        return true;
    }

    public void close() {
        Preferences prefs;
        super.close();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("xap.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(prefs = Preferences.userNodeForPackage(clazz)).getBoolean("helpshown", false)) {
            prefs.putBoolean("helpshown", true);
            try {
                new HelpWindow().open();
            }
            catch (Exception e) {
                Game.handleException(e);
            }
        }
    }

    private class EventHandler
    implements OKCancelListener,
    EditorListener {
        EventHandler() {
        }

        public void cancelClicked() {
            RegisterWindow.this.close();
        }

        public void okClicked() {
            try {
                RegisterWindow.this.doRegistration();
            }
            catch (Exception e) {
                Game.handleException(e);
            }
        }

        public boolean editChanged(Editor source, int key) {
            RegisterWindow.this.enableControls();
            return false;
        }
    }
}

