/*
 * Decompiled with CFR 0.152.
 */
package xap.menu;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.opengl.Display;
import xap.FluxMouse;
import xap.Game;
import xap.Options;
import xap.gui.CheckBox;
import xap.gui.Label;
import xap.gui.OKCancelListener;
import xap.gui.OKCancelPanel;
import xap.gui.Slider;
import xap.gui.SliderListener;
import xap.gui.Window;

public class OptionsDialog
extends Window
implements Options.Editor {
    private final Options originalOptions;
    private static final float GAMMA_SCALE = 150.0f;
    private static final float BRIGHTNESS_SCALE = 256.0f;
    private static final float CONTRAST_SCALE = 270.0f;
    private static final int GAMMA_OFFSET = -22;
    private static final int BRIGHTNESS_OFFSET = 128;
    private static final int CONTRAST_OFFSET = -142;
    private Label volumeLabel;
    private Label musicVolumeLabel;
    private Label gammaLabel;
    private Label brightnessLabel;
    private Label contrastLabel;
    private Label mouseLabel;
    private CheckBox bumpMappingCheckBox;
    private CheckBox trueColourCheckBox;
    private CheckBox lowResCheckBox;
    private CheckBox thirtyHertzCheckBox;
    private CheckBox useInternetCheckBox;
    private CheckBox askUseInternetCheckBox;
    private CheckBox showPerformanceWarningCheckBox;
    private Slider volumeSlider;
    private Slider musicVolumeSlider;
    private Slider gammaSlider;
    private Slider brightnessSlider;
    private Slider contrastSlider;
    private Slider mouseSlider;
    private OKCancelPanel okCancelPanel;
    private ALBuffer volumeChangedResource;
    private final EventHandler eventHandler = new EventHandler();

    public OptionsDialog(Options options) throws Exception {
        super("Options");
        this.originalOptions = options;
        this.createGUI();
        options.toEditor(this);
        this.initEvents();
        this.volumeChangedResource = (ALBuffer)Resources.get((String)"zsphere_explode.buffer");
        this.open();
    }

    private void createGUI() throws Exception {
        this.volumeLabel = new Label("Sound Volume");
        this.musicVolumeLabel = new Label("Music Volume");
        this.gammaLabel = new Label("Gamma");
        this.brightnessLabel = new Label("Brightness");
        this.contrastLabel = new Label("Contrast");
        this.mouseLabel = new Label("Mouse Sensitivity");
        this.showPerformanceWarningCheckBox = new CheckBox("Warn about poor performance");
        this.bumpMappingCheckBox = new CheckBox("Use Bump Mapping If Possible");
        this.trueColourCheckBox = new CheckBox("Use 32-bit Colour If Possible");
        this.lowResCheckBox = new CheckBox("Use Low Res Graphics");
        this.thirtyHertzCheckBox = new CheckBox("Use 30Hz Framerate");
        this.volumeSlider = new Slider(0, false);
        this.musicVolumeSlider = new Slider(0, false);
        this.gammaSlider = new Slider(0, false);
        this.brightnessSlider = new Slider(0, false);
        this.contrastSlider = new Slider(0, false);
        this.mouseSlider = new Slider(0, false);
        this.okCancelPanel = new OKCancelPanel();
        this.useInternetCheckBox = new CheckBox("Post internet hiscores");
        this.askUseInternetCheckBox = new CheckBox("Ask before posting internet hiscores");
        this.addChild(this.volumeLabel);
        this.addChild(this.volumeSlider);
        this.addChild(this.musicVolumeLabel);
        this.addChild(this.musicVolumeSlider);
        this.addChild(this.gammaLabel);
        this.addChild(this.gammaSlider);
        this.addChild(this.brightnessLabel);
        this.addChild(this.brightnessSlider);
        this.addChild(this.contrastLabel);
        this.addChild(this.contrastSlider);
        this.addChild(this.mouseLabel);
        this.addChild(this.mouseSlider);
        this.addChild(this.bumpMappingCheckBox);
        this.addChild(this.trueColourCheckBox);
        this.addChild(this.lowResCheckBox);
        this.addChild(this.thirtyHertzCheckBox);
        this.addChild(this.showPerformanceWarningCheckBox);
        this.addChild(this.useInternetCheckBox);
        this.addChild(this.askUseInternetCheckBox);
        this.addChild(this.okCancelPanel);
        this.okCancelPanel.setLocation(0, 0).pack();
        this.bumpMappingCheckBox.setLocation(0, this.okCancelPanel.getY() + this.okCancelPanel.getHeight() + 24).layout().pack().setWidth(300);
        this.trueColourCheckBox.setLocation(0, this.bumpMappingCheckBox.getY() + this.bumpMappingCheckBox.getHeight() + 2).layout().pack().setWidth(300);
        this.lowResCheckBox.setLocation(0, this.trueColourCheckBox.getY() + this.trueColourCheckBox.getHeight() + 2).layout().pack().setWidth(300);
        this.thirtyHertzCheckBox.setLocation(0, this.lowResCheckBox.getY() + this.lowResCheckBox.getHeight() + 2).layout().pack().setWidth(300);
        this.showPerformanceWarningCheckBox.setLocation(0, this.thirtyHertzCheckBox.getY() + this.thirtyHertzCheckBox.getHeight() + 2).layout().pack().setWidth(300);
        this.askUseInternetCheckBox.setLocation(0, this.showPerformanceWarningCheckBox.getY() + this.showPerformanceWarningCheckBox.getHeight() + 2).layout().pack().setWidth(300);
        this.useInternetCheckBox.setLocation(0, this.askUseInternetCheckBox.getY() + this.askUseInternetCheckBox.getHeight() + 2).layout().pack().setWidth(300);
        int pos = this.useInternetCheckBox.getY() + this.useInternetCheckBox.getHeight() + 2;
        pos = this.showPerformanceWarningCheckBox.getY() + this.showPerformanceWarningCheckBox.getHeight() + 2;
        this.contrastSlider.setLocation(0, pos).layout().setSize(300, 16);
        this.contrastLabel.setLocation(0, this.contrastSlider.getY() + this.contrastSlider.getHeight() + 2).layout().pack().setWidth(300);
        this.contrastSlider.setMinValue(0);
        this.contrastSlider.setMaxValue(256);
        this.brightnessSlider.setLocation(0, this.contrastLabel.getY() + this.contrastLabel.getHeight() + 2).layout().setSize(300, 16);
        this.brightnessLabel.setLocation(0, this.brightnessSlider.getY() + this.brightnessSlider.getHeight() + 2).layout().pack().setWidth(300);
        this.brightnessSlider.setMinValue(0);
        this.brightnessSlider.setMaxValue(256);
        this.gammaSlider.setLocation(0, this.brightnessLabel.getY() + this.brightnessLabel.getHeight() + 2).layout().setSize(300, 16);
        this.gammaLabel.setLocation(0, this.gammaSlider.getY() + this.gammaSlider.getHeight() + 2).layout().pack().setWidth(300);
        this.gammaSlider.setMinValue(256);
        this.gammaSlider.setMaxValue(0);
        this.mouseSlider.setLocation(0, this.gammaLabel.getY() + this.gammaLabel.getHeight() + 2).layout().setSize(300, 16);
        this.mouseLabel.setLocation(0, this.mouseSlider.getY() + this.mouseSlider.getHeight() + 2).layout().pack().setWidth(300);
        this.mouseSlider.setMaxValue(8);
        this.mouseSlider.setMinValue(1);
        this.musicVolumeSlider.setLocation(0, this.mouseLabel.getY() + this.mouseLabel.getHeight() + 2).layout().setSize(300, 16);
        this.musicVolumeLabel.setLocation(0, this.musicVolumeSlider.getY() + this.musicVolumeSlider.getHeight() + 2).layout().pack().setWidth(300);
        this.musicVolumeSlider.setMaxValue(100);
        this.musicVolumeSlider.setMinValue(0);
        this.volumeSlider.setLocation(0, this.musicVolumeLabel.getY() + this.musicVolumeLabel.getHeight() + 2).layout().setSize(300, 16);
        this.volumeLabel.setLocation(0, this.volumeSlider.getY() + this.volumeSlider.getHeight() + 2).layout().pack().setWidth(300);
        this.volumeSlider.setMaxValue(100);
        this.volumeSlider.setMinValue(0);
        this.pack();
        this.setBorder(5, 5, 5, 5);
        this.centre();
    }

    private void initEvents() {
        this.okCancelPanel.addOkCancelListener(this.eventHandler);
        this.volumeSlider.addSliderListener(this.eventHandler);
        this.musicVolumeSlider.addSliderListener(this.eventHandler);
        this.gammaSlider.addSliderListener(this.eventHandler);
        this.brightnessSlider.addSliderListener(this.eventHandler);
        this.contrastSlider.addSliderListener(this.eventHandler);
        this.mouseSlider.addSliderListener(this.eventHandler);
    }

    public float getVolume() {
        return (float)this.volumeSlider.getCurrentValue() / 100.0f;
    }

    public float getMusicVolume() {
        return (float)this.musicVolumeSlider.getCurrentValue() / 100.0f;
    }

    public boolean getTrueColour() {
        return this.trueColourCheckBox.isChecked();
    }

    public boolean getUseBumpMapping() {
        return this.bumpMappingCheckBox.isChecked();
    }

    public void setVolume(float volume) {
        this.volumeSlider.setCurrentValue((int)(volume * 100.0f));
    }

    public void setMusicVolume(float volume) {
        this.musicVolumeSlider.setCurrentValue((int)(volume * 100.0f));
    }

    public void setTrueColour(boolean trueColour) {
        this.trueColourCheckBox.setChecked(trueColour);
    }

    public void setUseBumpMapping(boolean useBumpMapping) {
        this.bumpMappingCheckBox.setChecked(useBumpMapping);
    }

    public float getGamma() {
        return ((float)this.gammaSlider.getCurrentValue() - -22.0f) / 150.0f;
    }

    public float getBrightness() {
        return ((float)this.brightnessSlider.getCurrentValue() - 128.0f) / 256.0f;
    }

    public float getContrast() {
        return ((float)this.contrastSlider.getCurrentValue() - -142.0f) / 270.0f;
    }

    public int getMouseSensitivity() {
        return this.mouseSlider.getCurrentValue();
    }

    public void setGamma(float gamma) {
        this.gammaSlider.setCurrentValue((int)(gamma * 150.0f) + -22);
    }

    public void setBrightness(float brightness) {
        this.brightnessSlider.setCurrentValue((int)(brightness * 256.0f) + 128);
    }

    public void setContrast(float contrast) {
        this.contrastSlider.setCurrentValue((int)(contrast * 270.0f) + -142);
    }

    public void setMouseSensitivity(int sensitivity) {
        this.mouseSlider.setCurrentValue(sensitivity);
    }

    public boolean getLowRes() {
        return this.lowResCheckBox.isChecked();
    }

    public boolean getThirtyHertz() {
        return this.thirtyHertzCheckBox.isChecked();
    }

    public void setLowRes(boolean lowRes) {
        this.lowResCheckBox.setChecked(lowRes);
    }

    public void setThirtyHertz(boolean thirtyHertz) {
        this.thirtyHertzCheckBox.setChecked(thirtyHertz);
    }

    public boolean getUseInternet() {
        return this.useInternetCheckBox.isChecked();
    }

    public void setUseInternet(boolean useInternet) {
        this.useInternetCheckBox.setChecked(useInternet);
    }

    public boolean getAskUseInternet() {
        return this.askUseInternetCheckBox.isChecked();
    }

    public void setAskUseInternet(boolean askUseInternet) {
        this.askUseInternetCheckBox.setChecked(askUseInternet);
    }

    public boolean getShowPerformanceWarning() {
        return this.showPerformanceWarningCheckBox.isChecked();
    }

    public void setShowPerformanceWarning(boolean showPerformanceWarning) {
        this.showPerformanceWarningCheckBox.setChecked(showPerformanceWarning);
    }

    private class EventHandler
    implements OKCancelListener,
    SliderListener {
        EventHandler() {
        }

        public void cancelClicked() {
            OptionsDialog.this.originalOptions.apply();
            OptionsDialog.this.close();
        }

        public void okClicked() {
            OptionsDialog.this.close();
            Game.setOptions(OptionsDialog.this);
        }

        public boolean valueChanged(Slider slider, int oldValue, int newValue) {
            if (slider == OptionsDialog.this.volumeSlider) {
                if (AL.isCreated()) {
                    AL10.alListenerf((int)4106, (float)((float)newValue / 100.0f));
                    Game.allocateBackgroundSound(OptionsDialog.this.volumeChangedResource, this);
                }
            } else if (slider == OptionsDialog.this.musicVolumeSlider) {
                Game.setMusicVolume((float)newValue / 100.0f);
            } else if (slider == OptionsDialog.this.gammaSlider || slider == OptionsDialog.this.brightnessSlider || slider == OptionsDialog.this.contrastSlider) {
                try {
                    Display.setDisplayConfiguration((float)OptionsDialog.this.getGamma(), (float)OptionsDialog.this.getBrightness(), (float)OptionsDialog.this.getContrast());
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            } else if (slider == OptionsDialog.this.mouseSlider) {
                FluxMouse.setSensitivity(newValue);
            }
            return false;
        }
    }
}

