/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import com.shavenpuppy.jglib.Glyph;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.GLString;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.Rectangle;
import xap.gui.Component;
import xap.gui.Editor;
import xap.gui.EditorListener;
import xap.gui.FocusListener;
import xap.gui.Interface;
import xap.gui.KeyboardListener;
import xap.gui.MouseAdapter;
import xap.gui.SwirlyBackground;
import xap.gui.TextField;

public class TextField
extends Component
implements Editor {
    private int cursorPos;
    protected StringBuffer buffer;
    private String undoBuffer;
    private boolean password;
    private StringBuffer scratch;
    private boolean passwordEdited;
    private Color textColor = new Color((ReadableColor)Interface.getDefaultForeground());
    private static final int DEFAULT = 0;
    private static final int HIGHLIGHTED = 1;
    private int currentState = 0;
    private int newState = 0;
    private static final int TRANSITION_SPEED = 12;
    private static final int TOTAL_TRANSITION = 24;
    private int ticker = 1;
    private final ArrayList editorListeners = new ArrayList();
    private final GLString string;
    private final SwirlyBackground swirlyBackground = new SwirlyBackground(this, 64.0f, 64.0f, null);
    private static final Rectangle tempBounds = new Rectangle();
    private static final int CARET_BLINK_FRAMES = 20;
    private int caretBlink = 0;
    private boolean caretVisible = true;

    public TextField(int length, boolean password) {
        this.password = password;
        if (password) {
            this.scratch = new StringBuffer(length);
        }
        this.string = new GLString(length);
        this.buffer = new StringBuffer(length);
        class EventHandler
        extends MouseAdapter
        implements KeyboardListener,
        FocusListener {
            final /* synthetic */ TextField this$0;
            private final /* synthetic */ boolean val$password;

            EventHandler(TextField textField, boolean bl) {
                this.this$0 = textField;
                this.val$password = bl;
            }

            public boolean keyDown(Component src, int key) {
                return false;
            }

            public boolean keyTyped(Component src, int key) {
                TextField.access$0(this.this$0, key);
                return false;
            }

            public boolean keyUp(Component src, int key) {
                return false;
            }

            public boolean gainFocus(Component src) {
                if (this.val$password && !TextField.access$1(this.this$0)) {
                    TextField.access$2(this.this$0, true);
                    this.this$0.buffer.setLength(0);
                    TextField.access$3(this.this$0).setText("");
                }
                TextField.access$4(this.this$0, this.this$0.buffer.length());
                TextField.access$5(this.this$0, this.this$0.getText());
                return false;
            }

            public boolean loseFocus(Component src) {
                return false;
            }

            public boolean leftButtonDown(Component src, int x, int y) {
                TextField.access$6(this.this$0, x, y);
                return false;
            }

            public boolean mouseEntered(Component src, int x, int y, int buttonFlags) {
                TextField.access$7(this.this$0, x, y, buttonFlags);
                return false;
            }

            public boolean mouseExited(Component src, int x, int y, int buttonFlags) {
                TextField.access$8(this.this$0, x, y, buttonFlags);
                return false;
            }
        }
        EventHandler eventHandler = new EventHandler(this, password);
        this.addMouseListener(eventHandler);
        this.addKeyboardListener(eventHandler);
        this.addFocusListener(eventHandler);
        this.setText("");
        this.setBackgroundColor(Interface.getControlBackgroundColor());
    }

    public TextField(int length) {
        this(length, false);
    }

    public void addEditorListener(EditorListener listener) {
        this.editorListeners.add(listener);
    }

    public int capacity() {
        return this.string.capacity();
    }

    public Component pack() {
        Glyph glyph = this.getFont().getFont().map('8');
        this.setSize(this.string.capacity() * glyph.getWidth() + 4, this.getFont().getAscent() + this.getFont().getDescent());
        return this;
    }

    protected boolean doTick() {
        boolean ret = false;
        if (!this.isShowing()) {
            return false;
        }
        if (this.currentState != this.newState || this.ticker > 0) {
            if (this.ticker > 0) {
                --this.ticker;
            }
            if (this.ticker <= 0) {
                this.ticker = 0;
                this.currentState = this.newState;
            }
            float transition = (float)Math.min(12, this.ticker) / 12.0f;
            Color c = this.getForegroundColor();
            if (c == null) {
                c = Interface.getDefaultForeground();
            }
            switch (this.newState) {
                case 0: {
                    this.textColor.set((int)LinearInterpolator.instance.interpolate((float)c.getRed(), (float)Interface.getControlSelectedTextColor().getRed(), transition), (int)LinearInterpolator.instance.interpolate((float)c.getGreen(), (float)Interface.getControlSelectedTextColor().getGreen(), transition), (int)LinearInterpolator.instance.interpolate((float)c.getBlue(), (float)Interface.getControlSelectedTextColor().getBlue(), transition), (int)LinearInterpolator.instance.interpolate((float)c.getAlpha(), (float)Interface.getControlSelectedTextColor().getAlpha(), transition));
                    break;
                }
                case 1: {
                    this.textColor.set((int)LinearInterpolator.instance.interpolate((float)Interface.getControlSelectedTextColor().getRed(), (float)c.getRed(), transition), (int)LinearInterpolator.instance.interpolate((float)Interface.getControlSelectedTextColor().getGreen(), (float)c.getGreen(), transition), (int)LinearInterpolator.instance.interpolate((float)Interface.getControlSelectedTextColor().getBlue(), (float)c.getBlue(), transition), (int)LinearInterpolator.instance.interpolate((float)Interface.getControlSelectedTextColor().getAlpha(), (float)c.getAlpha(), transition));
                    break;
                }
            }
            ret = true;
        } else if (this.isEnabled()) {
            if (this.currentState == 1) {
                this.textColor.setColor((ReadableColor)Interface.getControlSelectedTextColor());
            } else if (this.getForegroundColor() == null) {
                this.textColor.setColor((ReadableColor)Interface.getDefaultForeground());
            } else {
                this.textColor.setColor((ReadableColor)this.getForegroundColor());
            }
        } else {
            this.textColor.setColor((ReadableColor)Interface.getControlDisabledTextColor());
        }
        ret |= this.swirlyBackground.doTick();
        if (this.hasFocus()) {
            ++this.caretBlink;
            if (this.caretBlink > 20) {
                this.caretBlink = 0;
                this.caretVisible = !this.caretVisible;
            }
            ret = true;
        }
        if (this.isChanged()) {
            this.string.setFont(this.getFont());
            this.string.setLocation(0, this.getFont().getDescent());
        }
        return ret;
    }

    protected void editChanged(int key) {
        Iterator i = this.editorListeners.iterator();
        while (i.hasNext()) {
            if (((EditorListener)i.next()).editChanged(this, key)) break;
        }
    }

    public String getText() {
        return this.buffer.toString();
    }

    private void handleKeyTyped(int key) {
        int oldCursorPos = this.cursorPos;
        switch (key) {
            case 1: {
                this.undo();
                this.cursorPos = this.buffer.length();
                break;
            }
            case 14: {
                if (Keyboard.isKeyDown((int)42)) {
                    this.buffer.delete(0, this.cursorPos);
                    this.cursorPos = 0;
                    this.setDisplayText(this.buffer.toString());
                    break;
                }
                if (this.cursorPos <= 0) break;
                this.buffer.delete(this.cursorPos - 1, this.cursorPos);
                --this.cursorPos;
                this.setDisplayText(this.buffer.toString());
                break;
            }
            case 211: {
                if (Keyboard.isKeyDown((int)42)) {
                    this.buffer.delete(this.cursorPos, this.buffer.length());
                    this.setDisplayText(this.buffer.toString());
                    this.setChanged(true);
                    break;
                }
                if (this.cursorPos >= this.buffer.length()) break;
                this.buffer.delete(this.cursorPos, this.cursorPos + 1);
                this.setDisplayText(this.buffer.toString());
                this.setChanged(true);
                break;
            }
            case 199: 
            case 200: {
                this.cursorPos = 0;
                break;
            }
            case 207: 
            case 208: {
                this.cursorPos = this.buffer.length();
                break;
            }
            case 203: {
                if (Keyboard.isKeyDown((int)42)) {
                    this.cursorPos = 0;
                    break;
                }
                if (this.cursorPos <= 0) break;
                --this.cursorPos;
                break;
            }
            case 205: {
                if (Keyboard.isKeyDown((int)42)) {
                    this.cursorPos = this.buffer.length();
                    break;
                }
                if (this.cursorPos >= this.buffer.length()) break;
                ++this.cursorPos;
                break;
            }
            default: {
                char c;
                if (this.buffer.length() == this.capacity() || Character.isISOControl(c = Keyboard.getEventCharacter())) break;
                this.buffer.insert(this.cursorPos++, c);
                this.setDisplayText(this.buffer.toString());
                this.setChanged(true);
            }
        }
        if (oldCursorPos != this.cursorPos) {
            this.caretVisible = true;
            this.caretBlink = 0;
            this.setChanged(true);
        }
        this.editChanged(key);
    }

    private void setDisplayText(String text) {
        if (this.password) {
            if (this.scratch.length() < text.length()) {
                int i = 0;
                while (i < text.length() - this.scratch.length()) {
                    this.scratch.append('*');
                    ++i;
                }
            } else {
                this.scratch.setLength(text.length());
            }
            this.string.setText(this.scratch.toString());
        } else {
            this.string.setText(text);
        }
    }

    private void handleLeftButtonDown(int x, int y) {
        this.cursorPos = this.string.getCharIndexAt((float)x, (float)y);
        if (this.cursorPos < 0) {
            this.cursorPos = 0;
        } else if (this.cursorPos > this.getText().length()) {
            this.cursorPos = this.getText().length();
        }
        this.caretBlink = 0;
        this.caretVisible = true;
        this.setChanged(true);
    }

    private void handleMouseEntered(int x, int y, int buttonFlags) {
        this.newState = 1;
        this.ticker = 12 - Math.min(12, this.ticker);
    }

    private void handleMouseExited(int x, int y, int buttonFlags) {
        this.newState = 0;
        this.ticker = 24 - this.ticker;
    }

    public void removeEditorListener(EditorListener listener) {
        this.editorListeners.remove(listener);
    }

    protected void renderBackground() {
        this.swirlyBackground.render();
    }

    public void renderSelf() {
        super.renderSelf();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        this.setGLColor(this.textColor);
        this.string.render();
        GL11.glDisable((int)3553);
        if (this.hasFocus() && this.caretVisible) {
            int textWidth = this.getFont().getFont().getStringBounds(this.string.getText(), 0, this.cursorPos, tempBounds).getWidth();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glRecti((int)textWidth, (int)0, (int)(textWidth + 2), (int)this.getHeight());
        }
    }

    public TextField setText(String text) {
        if (this.password) {
            this.string.setText("*****");
        } else {
            this.string.setText(text);
        }
        this.buffer.setLength(0);
        this.buffer.append(text);
        this.cursorPos = text.length();
        this.setChanged(true);
        return this;
    }

    public String toString() {
        return "SingleLineEdit '" + this.getText() + "'";
    }

    public void undo() {
        this.setText(this.undoBuffer);
    }

    static /* synthetic */ void access$0(TextField textField, int n) {
        textField.handleKeyTyped(n);
    }

    static /* synthetic */ boolean access$1(TextField textField) {
        return textField.passwordEdited;
    }

    static /* synthetic */ void access$2(TextField textField, boolean bl) {
        textField.passwordEdited = bl;
    }

    static /* synthetic */ GLString access$3(TextField textField) {
        return textField.string;
    }

    static /* synthetic */ void access$4(TextField textField, int n) {
        textField.cursorPos = n;
    }

    static /* synthetic */ void access$5(TextField textField, String string) {
        textField.undoBuffer = string;
    }

    static /* synthetic */ void access$6(TextField textField, int n, int n2) {
        textField.handleLeftButtonDown(n, n2);
    }

    static /* synthetic */ void access$7(TextField textField, int n, int n2, int n3) {
        textField.handleMouseEntered(n, n2, n3);
    }

    static /* synthetic */ void access$8(TextField textField, int n, int n2, int n3) {
        textField.handleMouseExited(n, n2, n3);
    }
}

