/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import xap.gui.Component;
import xap.gui.Interface;

public class TextArea
extends Component {
    private String text;
    private GLTextArea textArea;

    public TextArea() {
        this("");
    }

    public TextArea(String text) {
        this.setCanFocus(false);
        this.setClipped(false);
        this.setText(text);
        this.setForegroundColor(Interface.getControlEnabledTextColor());
    }

    public void doLayout() {
        this.textArea.setSize(this.size.getWidth(), 0);
        this.textArea.setFont(this.getFont());
        this.setSize(this.size.getWidth(), this.textArea.getTextHeight());
        this.textArea.setLocation(0, this.textArea.getTextHeight());
    }

    protected boolean doTick() {
        if (this.isChanged()) {
            this.textArea.setFont(this.getFont());
        }
        return this.isChanged();
    }

    protected GLTextArea getGLTextArea() {
        return this.textArea;
    }

    public String getText() {
        return this.text;
    }

    protected void renderSelf() {
        GL11.glEnable((int)3553);
        Color c = this.getForegroundColor();
        if (c == null) {
            c = Interface.getDefaultForeground();
        }
        if (!this.isEnabled()) {
            c = Interface.getControlDisabledTextColor();
        }
        this.setGLColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.textArea.render();
        GL11.glDisable((int)3553);
    }

    public TextArea setText(String text) {
        if (text.equals(this.text)) {
            return this;
        }
        this.text = text;
        this.setChanged(true);
        if (this.textArea == null) {
            this.textArea = new GLTextArea();
        }
        this.textArea.setFont(this.getFont());
        this.textArea.setLength(0);
        this.textArea.append(text);
        return this;
    }

    public String toString() {
        return "StaticText " + this.text;
    }

    public void setHorizontalAlignment(TextLayout.HorizontalAlignment alignment) {
        this.textArea.setHorizontalAlignment(alignment);
    }

    public void setVerticalAlignment(GLTextArea.VerticalAlignment alignment) {
        this.textArea.setVerticalAlignment(alignment);
    }

    public void setFormat(TextLayout.Format format) {
        this.textArea.setFormat(format);
    }
}

