/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import org.lwjgl.util.Point;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.Rectangle;
import xap.gui.Component;
import xap.gui.Panel;
import xap.gui.Slider;
import xap.gui.SliderListener;

public class ScrollPane
extends Component {
    private Component view;
    private final Point position = new Point();
    private final Slider horizScrollBar;
    private final Slider vertScrollBar;
    private boolean isAdjusting;
    public static final int HORIZONTAL_SCROLLBAR_AS_NEEDED = 0;
    public static final int HORIZONTAL_SCROLLBAR_ALWAYS = 1;
    public static final int HORIZONTAL_SCROLLBAR_NEVER = 2;
    public static final int VERTICAL_SCROLLBAR_AS_NEEDED = 0;
    public static final int VERTICAL_SCROLLBAR_ALWAYS = 1;
    public static final int VERTICAL_SCROLLBAR_NEVER = 2;
    private final int horizScrollBarPolicy;
    private final int vertScrollBarPolicy;
    private final ViewPort viewPort = new ViewPort();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.gui.ScrollPane");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ScrollPane() throws Exception {
        this(0, 0);
    }

    public ScrollPane(int horizScrollbarPolicy, int vertScrollbarPolicy) throws Exception {
        this.horizScrollBarPolicy = horizScrollbarPolicy;
        this.vertScrollBarPolicy = vertScrollbarPolicy;
        this.horizScrollBar = new Slider(0, false);
        this.vertScrollBar = new Slider(1, false);
        this.addChild(this.horizScrollBar);
        this.addChild(this.vertScrollBar);
        SliderListener eventHandler = new SliderListener(){

            public boolean valueChanged(Slider slider, int oldValue, int newValue) {
                if (!ScrollPane.this.isAdjusting) {
                    ScrollPane.this.isAdjusting = true;
                    if (slider == ScrollPane.this.horizScrollBar) {
                        ScrollPane.this.setViewLocation(newValue, ScrollPane.this.position.getY());
                    } else {
                        ScrollPane.this.setViewLocation(ScrollPane.this.position.getX(), newValue);
                    }
                    ScrollPane.this.isAdjusting = false;
                }
                return false;
            }
        };
        this.horizScrollBar.addSliderListener(eventHandler);
        this.vertScrollBar.addSliderListener(eventHandler);
    }

    public void setViewLocation(int x, int y) {
        if (this.position.getX() == x && this.position.getY() == y) {
            return;
        }
        this.position.setLocation(x, y);
        this.view.setLocation(-x, -y);
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.horizScrollBar.setCurrentValue(x);
            this.horizScrollBar.setPrevPage(this.view.getHorizontalScrollPrevPage(this.viewPort.getWidth(), x));
            this.horizScrollBar.setNextPage(this.view.getHorizontalScrollNextPage(this.viewPort.getWidth(), x));
            this.vertScrollBar.setCurrentValue(y);
            this.vertScrollBar.setPrevPage(this.view.getVerticalScrollPrevPage(this.viewPort.getHeight(), y));
            this.vertScrollBar.setNextPage(this.view.getVerticalScrollPrevPage(this.viewPort.getHeight(), y));
            this.isAdjusting = false;
        }
    }

    public Point getViewLocation(Point ret) {
        if (ret == null) {
            ret = new Point((ReadablePoint)this.position);
        } else {
            ret.setLocation((ReadablePoint)this.position);
        }
        return ret;
    }

    public void doLayout() {
        if (this.view == null) {
            if (this.horizScrollBarPolicy == 0) {
                this.horizScrollBar.setVisible(false);
            }
            if (this.vertScrollBarPolicy == 0) {
                this.vertScrollBar.setVisible(false);
            }
            this.viewPort.setSize(this.getWidth(), this.getHeight());
            return;
        }
        boolean hvis = false;
        switch (this.horizScrollBarPolicy) {
            case 1: {
                hvis = true;
                break;
            }
            case 0: {
                hvis = this.view.getWidth() > this.getWidth();
                break;
            }
            case 2: {
                hvis = false;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        boolean vvis = false;
        switch (this.vertScrollBarPolicy) {
            case 1: {
                vvis = true;
                break;
            }
            case 0: {
                vvis = this.view.getHeight() > this.getHeight();
                break;
            }
            case 2: {
                vvis = false;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        vvis |= (hvis |= (vvis |= (hvis |= vvis && this.view.getWidth() > this.getWidth() - 16 && this.horizScrollBarPolicy != 2) && this.view.getHeight() > this.getHeight() - 16 && this.vertScrollBarPolicy != 2) && this.view.getWidth() > this.getWidth() - 16 && this.horizScrollBarPolicy != 2) && this.view.getHeight() > this.getHeight() - 16 && this.vertScrollBarPolicy != 2;
        if (!hvis) {
            if (this.horizScrollBarPolicy == 0) {
                this.horizScrollBar.setVisible(false);
                this.horizScrollBar.setMaxValue(0);
            }
        } else {
            this.horizScrollBar.setMinValue(0);
            this.horizScrollBar.setMaxValue(this.view.getWidth() - (this.getWidth() - (vvis ? 16 : 0)));
            this.horizScrollBar.setVisible(true);
        }
        if (!vvis) {
            if (this.vertScrollBarPolicy == 0) {
                this.vertScrollBar.setVisible(false);
                this.vertScrollBar.setMaxValue(0);
            }
        } else {
            this.vertScrollBar.setMinValue(0);
            this.vertScrollBar.setMaxValue(this.view.getHeight() - (this.getHeight() - (hvis ? 16 : 0)));
            this.vertScrollBar.setVisible(true);
        }
        if (hvis) {
            this.horizScrollBar.setLocation(0, 0).setSize(this.getWidth() - (vvis ? 16 : 0), 16);
        }
        if (vvis) {
            this.vertScrollBar.setLocation(this.getWidth() - 16, hvis ? 16 : 0).setSize(16, this.getHeight() - (hvis ? 16 : 0));
        }
        this.viewPort.setLocation(0, hvis ? 16 : 0).setSize(vvis ? this.getWidth() - 16 : this.getWidth(), hvis ? this.getHeight() - 16 : this.getHeight());
        if (this.vertScrollBarPolicy != 2 && !vvis) {
            this.view.setY(this.viewPort.getHeight() - this.view.getHeight());
        }
    }

    public Component getView() {
        return this.view;
    }

    public void setView(Component view) {
        if (view != this.view) {
            if (this.view != null) {
                this.viewPort.removeChild(this.view);
            }
            this.view = view;
            if (view != null) {
                this.viewPort.addChild(this.view);
            }
            this.setDelegate(view);
            this.viewPort.setDelegate(view);
            view.revalidate();
            this.revalidate();
            this.setViewLocation(0, this.vertScrollBar.getMaxValue());
        }
    }

    private class ViewPort
    extends Panel {
        ViewPort() {
            ScrollPane.this.addChild(this);
        }

        public void ensureVisible(Rectangle area) {
            if (area.getX() >= 0 && area.getY() >= 0 && area.getX() + area.getWidth() <= ScrollPane.this.viewPort.getWidth() && area.getY() + area.getHeight() < ScrollPane.this.viewPort.getHeight()) {
                return;
            }
            int tx = ScrollPane.this.position.getX();
            int ty = ScrollPane.this.position.getY();
            if (area.getX() < 0) {
                tx += area.getX();
            } else if (area.getX() >= ScrollPane.this.viewPort.getWidth() - area.getWidth()) {
                tx += area.getWidth() + area.getX() - ScrollPane.this.viewPort.getWidth();
            }
            if (area.getY() < 0) {
                ty += area.getY();
            } else if (area.getY() >= ScrollPane.this.viewPort.getHeight() - area.getHeight()) {
                ty += area.getHeight() + area.getY() - ScrollPane.this.viewPort.getHeight();
            }
            ScrollPane.this.setViewLocation(tx, ty);
        }
    }
}

