/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.util.Dimension;
import xap.gui.CommandButton;
import xap.gui.CommandButtonListener;
import xap.gui.OKCancelListener;
import xap.gui.Panel;

public class OKCancelPanel
extends Panel {
    private CommandButton okButton;
    private CommandButton cancelButton;
    private final ArrayList listeners = new ArrayList();

    public OKCancelPanel() throws Exception {
        this.okButton = new CommandButton("OK");
        this.cancelButton = new CommandButton("Cancel");
        this.addChild(this.okButton);
        this.addChild(this.cancelButton);
        this.okButton.setWidth(100);
        this.cancelButton.setWidth(100);
        this.pack();
        this.initEvents();
    }

    public OKCancelPanel(String okText, String cancelText) throws Exception {
        this.okButton = new CommandButton(okText);
        this.cancelButton = new CommandButton(cancelText);
        this.okButton.setWidth(this.okButton.getWidth() + 40);
        this.cancelButton.setWidth(this.cancelButton.getWidth() + 40);
        this.addChild(this.okButton);
        this.addChild(this.cancelButton);
        this.pack();
        this.initEvents();
    }

    public void addOkCancelListener(OKCancelListener listener) {
        this.listeners.add(listener);
    }

    public void doLayout() {
        this.okButton.setLocation(10, 10);
        Dimension size = this.parent.getSize(null);
        this.cancelButton.setLocation(size.getWidth() - this.cancelButton.getWidth() - 10, 10);
        this.pack();
    }

    private void initEvents() {
        this.okButton.addCommandButtonListener(new CommandButtonListener(){

            public boolean selected(CommandButton button) {
                Iterator i = OKCancelPanel.this.listeners.iterator();
                while (i.hasNext()) {
                    ((OKCancelListener)i.next()).okClicked();
                }
                return false;
            }
        });
        this.cancelButton.addCommandButtonListener(new CommandButtonListener(){

            public boolean selected(CommandButton button) {
                Iterator i = OKCancelPanel.this.listeners.iterator();
                while (i.hasNext()) {
                    ((OKCancelListener)i.next()).cancelClicked();
                }
                return false;
            }
        });
    }

    public void removeOkCancelListener(OKCancelListener listener) {
        this.listeners.remove(listener);
    }

    public void setOKEnabled(boolean enabled) {
        this.okButton.setEnabled(enabled);
    }

    public void setCancelEnabled(boolean enabled) {
        this.cancelButton.setEnabled(enabled);
    }
}

