/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import xap.gui.CommandButton;
import xap.gui.CommandButtonListener;
import xap.gui.Component;
import xap.gui.MessageBoxListener;
import xap.gui.Panel;
import xap.gui.Picture;
import xap.gui.TextArea;
import xap.gui.Window;

public class MessageBox
extends Window {
    private TextArea messageTextArea = new TextArea();
    private Component customComponent;
    private CommandButton okYesButton;
    private CommandButton noButton;
    private CommandButton cancelButton;
    private Panel buttonPanel = new Panel();
    private Picture icon = new Picture();
    private MessageBoxListener listener;
    private final int style;
    public static final int EMPTY_DIALOG = 5;
    public static final int OK_DIALOG = 0;
    public static final int CANCEL_DIALOG = 1;
    public static final int OK_CANCEL_DIALOG = 2;
    public static final int YES_NO_DIALOG = 3;
    public static final int YES_NO_CANCEL_DIALOG = 4;
    private final EventHandler eventHandler = new EventHandler();

    public MessageBox(String title, String message, int iconType, int style, MessageBoxListener listener) throws Exception {
        this(title, message, null, iconType, style, listener);
    }

    public MessageBox(String title, String message, Component customComponent, int iconType, int style, MessageBoxListener listener) throws Exception {
        super(title);
        this.listener = listener;
        this.style = style;
        this.customComponent = customComponent;
        this.okYesButton = new CommandButton("OK");
        this.noButton = new CommandButton("No");
        this.cancelButton = new CommandButton("Cancel");
        int fontHeight = this.getFont().getHeight();
        this.buttonPanel.addChild(this.okYesButton);
        this.buttonPanel.addChild(this.noButton);
        this.buttonPanel.addChild(this.cancelButton);
        this.addChild(this.icon);
        this.addChild(this.messageTextArea);
        if (customComponent != null) {
            this.addChild(customComponent);
        }
        this.addChild(this.buttonPanel);
        EventHandler eventHandler = new EventHandler();
        this.okYesButton.addCommandButtonListener(eventHandler);
        this.noButton.addCommandButtonListener(eventHandler);
        this.cancelButton.addCommandButtonListener(eventHandler);
        switch (style) {
            case 0: {
                this.noButton.setVisible(false);
                this.cancelButton.setVisible(false);
                this.okYesButton.pack().setWidth(100);
                break;
            }
            case 1: {
                this.okYesButton.setVisible(false);
                this.noButton.setVisible(false);
                this.cancelButton.pack().setWidth(100);
                break;
            }
            case 2: {
                this.noButton.setVisible(false);
                this.okYesButton.pack().setWidth(100);
                this.cancelButton.pack().setWidth(100).setX(110);
                break;
            }
            case 3: {
                this.cancelButton.setVisible(false);
                this.okYesButton.setText("Yes").pack().setWidth(100);
                this.noButton.pack().setWidth(100).setX(110);
                break;
            }
            case 4: {
                this.okYesButton.setText("Yes").pack().setWidth(100);
                this.noButton.pack().setWidth(100).setX(110);
                this.cancelButton.pack().setWidth(100).setX(220);
                break;
            }
            case 5: {
                this.okYesButton.setVisible(false);
                this.noButton.setVisible(false);
                this.cancelButton.setVisible(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown message box style " + style);
            }
        }
        this.buttonPanel.pack();
        this.buttonPanel.setClipped(false);
        this.cancelButton.setClipped(false);
        this.noButton.setClipped(false);
        this.okYesButton.setClipped(false);
        int minWidth = Math.max(Math.max(400, this.buttonPanel.getWidth()), Math.min(640, message.length() * fontHeight / 10));
        if (customComponent != null) {
            minWidth = Math.max(customComponent.getWidth(), minWidth);
        }
        this.messageTextArea.setWidth(minWidth);
        this.messageTextArea.setText(message);
        this.messageTextArea.layout();
        this.buttonPanel.setLocation((this.messageTextArea.getWidth() - this.buttonPanel.getWidth()) / 2, 5).setSize(this.buttonPanel.getWidth() + 20, this.buttonPanel.getHeight() + 10);
        if (customComponent != null) {
            customComponent.setLocation(0, this.buttonPanel.getHeight() + 10);
            this.messageTextArea.setLocation(0, customComponent.getY() + customComponent.getHeight() + 10);
        } else {
            this.messageTextArea.setLocation(0, this.buttonPanel.getHeight() + 10);
        }
        this.buttonPanel.revalidate();
        this.okYesButton.requestFocus();
        this.pack();
        this.layout();
        this.setBorder(5, 5, 5, 5);
        this.centre();
    }

    public void setMessageBoxListener(MessageBoxListener listener) {
        this.listener = listener;
    }

    private class EventHandler
    implements CommandButtonListener {
        EventHandler() {
        }

        public boolean selected(CommandButton cb) {
            MessageBox.this.close();
            if (MessageBox.this.listener != null) {
                if (cb == MessageBox.this.okYesButton) {
                    if (MessageBox.this.style == 3 || MessageBox.this.style == 4) {
                        MessageBox.this.listener.messageBoxChoiceMade(MessageBox.this, 2);
                    } else {
                        MessageBox.this.listener.messageBoxChoiceMade(MessageBox.this, 0);
                    }
                } else if (cb == MessageBox.this.noButton) {
                    MessageBox.this.listener.messageBoxChoiceMade(MessageBox.this, 3);
                } else if (cb == MessageBox.this.cancelButton) {
                    MessageBox.this.listener.messageBoxChoiceMade(MessageBox.this, 1);
                }
            }
            return false;
        }
    }
}

