/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;
import org.lwjgl.util.Color;
import org.lwjgl.util.Point;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.Timer;
import xap.Bindings;
import xap.FluxMouse;
import xap.gui.Component;
import xap.gui.Console;
import xap.gui.ConsoleListener;
import xap.gui.Dialog;
import xap.gui.MouseEvent;
import xap.gui.MousePointer;

public final class Interface {
    public static boolean DEBUG;
    private static final boolean CONSOLE = true;
    private static final ArrayList dialogs;
    private static final ArrayList dialogsToRemove;
    private static final ArrayList dialogsToAdd;
    private static boolean changed;
    private static Dialog dialog;
    private static Dialog activeDialog;
    private static Component focus;
    private static int focusIndex;
    private static boolean focusPathNeedsUpdating;
    private static final ArrayList focusPath;
    private static final Point mousePosition;
    private static MousePointer defaultMousePointer;
    private static MousePointer mousePointer;
    private static final boolean[] keyWasDown;
    private static boolean consoleBindingWasDown;
    static Component lastObjectUnderMouse;
    static Component objectUnderMouse;
    static Component capture;
    static final MouseEvent lastMousePos;
    static final Point local;
    private static boolean ignoreInput;
    private static final Timer timer;
    private static Console console;
    private static GLFont defaultFont;
    private static Color defaultBackground;
    private static Color defaultForeground;
    private static int windowBorderSize;
    private static Color windowActiveTitleBarColor;
    private static Color windowActiveTitleTextColor;
    private static Color windowInactiveTitleBarColor;
    private static Color windowInactiveTitleTextColor;
    private static GLFont windowTitleFont;
    private static Color windowBackgroundColor;
    private static GLFont controlFont;
    private static Color controlSelectedTextColor;
    private static Color controlEnabledTextColor;
    private static Color controlDisabledTextColor;
    private static Color controlBackgroundColor;
    private static float doubleClickTime;
    private static PrintStream defaultOut;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.gui.Interface");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        DEBUG = false;
        dialogs = new ArrayList();
        dialogsToRemove = new ArrayList();
        dialogsToAdd = new ArrayList();
        changed = true;
        focusIndex = 0;
        focusPathNeedsUpdating = false;
        focusPath = new ArrayList();
        mousePosition = new Point();
        keyWasDown = new boolean[256];
        lastMousePos = new MouseEvent();
        local = new Point();
        timer = new Timer();
    }

    private Interface() {
    }

    public static void init() throws Exception {
        Component.screenBounds = new Rectangle(0, 0, 800, 600);
        FluxMouse.setDimensions(800, 600);
        defaultMousePointer = new MousePointer((SpriteImage)Resources.get((String)"spriteimage.mousepointer"));
        defaultMousePointer.create();
        defaultFont = (GLFont)Resources.get((String)"impact-plain-18.glfont");
        defaultForeground = new Color(224, 224, 0);
        defaultBackground = new Color(0, 0, 0);
        windowTitleFont = (GLFont)Resources.get((String)"impact-plain-24.glfont");
        windowActiveTitleBarColor = new Color(128, 0, 255, 128);
        windowInactiveTitleBarColor = new Color(128, 0, 255, 128);
        controlBackgroundColor = new Color(0, 0, 255, 96);
        controlDisabledTextColor = new Color(127, 127, 127, 255);
        controlEnabledTextColor = new Color(255, 255, 255, 255);
        controlSelectedTextColor = new Color(255, 255, 255, 255);
        doubleClickTime = 0.2f;
        console = new Console();
        defaultOut = System.out;
        System.setOut(new PrintStream(Interface.console.output));
        System.setErr(new PrintStream(Interface.console.output));
        Interface.add(console);
    }

    public static void cleanup() {
        System.out.flush();
        if (defaultOut != null) {
            System.setOut(defaultOut);
            System.setErr(defaultOut);
        }
        defaultOut = null;
        console = null;
        dialog = null;
        dialogs.clear();
        dialogsToAdd.clear();
        dialogsToRemove.clear();
        focusPath.clear();
        focus = null;
        lastObjectUnderMouse = null;
        objectUnderMouse = null;
        defaultMousePointer = null;
        mousePointer = null;
        defaultFont = null;
        windowTitleFont = null;
        System.gc();
    }

    static void add(Dialog dialog) {
        dialogsToAdd.add(dialog);
    }

    static void calculateFocusPath(Component root) {
        boolean findOriginalFocus = false;
        if (focusPathNeedsUpdating) {
            focusPath.clear();
            focusPathNeedsUpdating = false;
            findOriginalFocus = focus != null;
            focusIndex = -1;
        }
        if (root == null) {
            return;
        }
        if (root.children != null) {
            Iterator i = root.children.iterator();
            while (i.hasNext()) {
                Component panel = (Component)i.next();
                if (!panel.isVisible() || !panel.isEnabled()) continue;
                if (panel.canFocus) {
                    focusPath.add(panel);
                }
                Interface.calculateFocusPath(panel);
            }
        }
        if (findOriginalFocus && (focusIndex = focusPath.indexOf(focus)) == -1) {
            Interface.setCurrentFocus(Interface.nextFocus());
        }
    }

    public static Component getComponentUnderMouse() {
        if (dialog == null) {
            return null;
        }
        return dialog.getComponentUnderMouse(mousePosition);
    }

    static Component getCurrentFocus() {
        return focus;
    }

    public static float getTime() {
        return timer.getTime();
    }

    static boolean isActiveDialog(Dialog d) {
        return d == activeDialog;
    }

    private static boolean isChanged() {
        return true;
    }

    public static boolean tick() {
        Timer.tick();
        if (dialogsToRemove.size() > 0 || dialogsToAdd.size() > 0) {
            dialogs.removeAll(dialogsToRemove);
            int i = 0;
            while (i < dialogsToRemove.size()) {
                ((Dialog)dialogsToRemove.get(i)).setVisible(false);
                ++i;
            }
            dialogs.removeAll(dialogsToAdd);
            dialogs.addAll(dialogsToAdd);
            dialogsToRemove.clear();
            dialogsToAdd.clear();
            Interface.dialogsShuffled();
        }
        if (dialog == null) {
            return Interface.isChanged();
        }
        if (focusPathNeedsUpdating) {
            Interface.calculateFocusPath(dialog);
            if (Interface.dialog.focus == null) {
                Interface.setCurrentFocus(Interface.nextFocus());
            }
        }
        Interface.processMouse();
        Interface.processKeyboard();
        boolean c = Interface.isChanged();
        int n = dialogs.size();
        int i = 0;
        while (i < n) {
            c |= ((Dialog)dialogs.get(i)).tick();
            ++i;
        }
        if (Bindings.isConsoleDown()) {
            if (!consoleBindingWasDown) {
                if (console.isVisible()) {
                    console.hide();
                } else {
                    console.show();
                }
                consoleBindingWasDown = true;
            }
        } else {
            consoleBindingWasDown = false;
        }
        return c;
    }

    static Component nextFocus() {
        if (focusPathNeedsUpdating) {
            Interface.calculateFocusPath(dialog);
        }
        if (focusPath.size() == 0) {
            return null;
        }
        if (focus.handleNextFocus()) {
            return focus;
        }
        Component next = null;
        do {
            if (++focusIndex == focusPath.size()) {
                focusIndex = 0;
            }
            next = (Component)focusPath.get(focusIndex);
        } while (!next.canFocus || !next.isEnabled());
        return next;
    }

    private static void orthographic() {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)0.0f, (float)800.0f, (float)0.0f, (float)600.0f);
        GL11.glMatrixMode((int)5888);
    }

    static Component priorFocus() {
        if (focusPathNeedsUpdating) {
            Interface.calculateFocusPath(dialog);
        }
        if (focusPath.size() == 0) {
            return null;
        }
        if (focus.handlePriorFocus()) {
            return focus;
        }
        Component next = null;
        do {
            if (--focusIndex < 0) {
                focusIndex = focusPath.size() - 1;
            }
            next = (Component)focusPath.get(focusIndex);
        } while (!next.canFocus || !next.isEnabled());
        return next;
    }

    /*
     * Unable to fully structure code
     */
    private static void processKeyboard() {
        if (!Interface.ignoreInput) ** GOTO lbl19
        return;
lbl-1000:
        // 1 sources

        {
            if (Keyboard.getEventKeyState()) {
                if (Keyboard.getEventKey() == 15) {
                    newFocus = Keyboard.isKeyDown((int)42) != false || Keyboard.isKeyDown((int)54) != false ? Interface.priorFocus() : Interface.nextFocus();
                    Interface.setCurrentFocus(newFocus);
                    continue;
                }
                if (Interface.focus == null) continue;
                if (Interface.focus.keyboardDelegate != null) {
                    Interface.focus.keyboardDelegate.keyDown(Keyboard.getEventKey());
                    continue;
                }
                Interface.focus.keyDown(Keyboard.getEventKey());
                continue;
            }
            if (Interface.focus == null) continue;
            if (Interface.focus.keyboardDelegate != null) {
                Interface.focus.keyboardDelegate.keyUp(Keyboard.getEventKey());
                continue;
            }
            Interface.focus.keyUp(Keyboard.getEventKey());
lbl19:
            // 8 sources

            ** while (Keyboard.next())
        }
lbl20:
        // 1 sources

    }

    private static void processMouse() {
        FluxMouse.poll();
        if (ignoreInput) {
            return;
        }
        mousePosition.setX(FluxMouse.getX());
        mousePosition.setY(FluxMouse.getY());
        int buttonFlags = Mouse.isButtonDown((int)0) ? 1 : 0;
        buttonFlags |= Mouse.getButtonCount() > 1 && Mouse.isButtonDown((int)1) ? 2 : 0;
        if (!$assertionsDisabled && (buttonFlags |= Mouse.getButtonCount() > 2 && Mouse.isButtonDown((int)2) ? 4 : 0) < 0) {
            throw new AssertionError();
        }
        objectUnderMouse = Interface.getComponentUnderMouse();
        mousePointer = objectUnderMouse != null ? objectUnderMouse.getMousePointer() : null;
        if (buttonFlags != Interface.lastMousePos.newButtonFlags || FluxMouse.getDX() != 0 || FluxMouse.getDY() != 0 || Mouse.getDWheel() != 0 || changed) {
            Interface.lastMousePos.oldButtonFlags = Interface.lastMousePos.newButtonFlags;
            Interface.lastMousePos.newButtonFlags = buttonFlags;
            Interface.lastMousePos.oldX = Interface.lastMousePos.x;
            Interface.lastMousePos.oldY = Interface.lastMousePos.y;
            Interface.lastMousePos.x = FluxMouse.getX();
            Interface.lastMousePos.y = FluxMouse.getY();
            Interface.lastMousePos.dz = Mouse.getDWheel();
            if (capture != null) {
                capture.processMouseEvent();
            } else if (objectUnderMouse != lastObjectUnderMouse) {
                if (lastObjectUnderMouse != null) {
                    lastObjectUnderMouse.getLocalLocation(Interface.lastMousePos.oldX, Interface.lastMousePos.oldY, local);
                    lastObjectUnderMouse.mouseExited(local.getX(), local.getY(), Interface.lastMousePos.oldButtonFlags);
                }
                if (objectUnderMouse != null) {
                    objectUnderMouse.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, local);
                    objectUnderMouse.mouseEntered(local.getX(), local.getY(), Interface.lastMousePos.newButtonFlags);
                }
            } else if (objectUnderMouse != null) {
                objectUnderMouse.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, local);
                boolean buttonDownEventSent = false;
                if ((Interface.lastMousePos.oldButtonFlags & 1) == 0 && (Interface.lastMousePos.newButtonFlags & 1) == 1) {
                    objectUnderMouse.leftButtonDown(local.getX(), local.getY());
                    buttonDownEventSent = true;
                }
                if ((Interface.lastMousePos.oldButtonFlags & 2) == 0 && (Interface.lastMousePos.newButtonFlags & 2) == 2) {
                    objectUnderMouse.rightButtonDown(local.getX(), local.getY());
                    buttonDownEventSent = true;
                }
                if (!buttonDownEventSent) {
                    if (FluxMouse.getDX() != 0 || FluxMouse.getDY() != 0) {
                        objectUnderMouse.mouseMoved(local.getX(), local.getY(), Interface.lastMousePos.newButtonFlags);
                    }
                    if (Mouse.getDWheel() != 0) {
                        objectUnderMouse.scrollyWheel(local.getX(), local.getY(), Interface.lastMousePos.dz);
                    }
                }
            }
            lastObjectUnderMouse = objectUnderMouse;
        }
    }

    static void remove(Dialog dialog) {
        dialogsToRemove.add(dialog);
    }

    static void dialogsShuffled() {
        int n;
        changed = true;
        Interface.setFocusPathNeedsUpdating(true);
        capture = null;
        int i = n = dialogs.size();
        while (--i >= 0) {
            Dialog d = (Dialog)dialogs.get(i);
            if (!d.isVisible() || !d.isEnabled()) continue;
            dialog = d;
            if (d.focus == null) {
                Component defaultFocus = d.getDefaultFocus();
                if (defaultFocus != null) {
                    defaultFocus.requestFocus();
                }
            } else {
                Interface.setCurrentFocus(d.focus);
            }
            Interface.calculateFocusPath(d);
            activeDialog = dialog.isPopup() ? (i > 0 ? (Dialog)dialogs.get(i - 1) : null) : dialog;
            return;
        }
        dialog = null;
        Interface.setCurrentFocus(null);
    }

    public static void render() {
        Interface.orthographic();
        GL11.glEnable((int)3089);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        changed = false;
        int n = dialogs.size();
        int i = 0;
        while (i < n) {
            ((Dialog)dialogs.get(i)).render();
            ++i;
        }
        if (mousePointer == null) {
            mousePointer = defaultMousePointer;
        }
        mousePointer.render();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3089);
    }

    static void setCapture(Component capture) {
        if (DEBUG) {
            System.out.println("Set capture to " + capture);
        }
        Interface.capture = capture;
    }

    public static Component getCapture() {
        return capture;
    }

    static void setCurrentFocus(Component newCurrentFocus) {
        if (newCurrentFocus == null) {
            if (focus != null && focus != newCurrentFocus) {
                Interface.focus.hasFocus = false;
                focus.loseFocus();
                focus.setChanged(true);
            }
            focus = null;
            if (dialog != null) {
                Interface.dialog.focus = null;
            }
            focusIndex = -1;
            changed = true;
        } else if (newCurrentFocus.canFocus && !newCurrentFocus.hasFocus) {
            newCurrentFocus.hasFocus = true;
            if (focus != null && focus != newCurrentFocus) {
                Interface.focus.hasFocus = false;
                focus.loseFocus();
                focus.setChanged(true);
            }
            focus = newCurrentFocus;
            Interface.focus.selectDown = false;
            focus.gainFocus();
            focus.setChanged(true);
            if (dialog != null) {
                Interface.dialog.focus = focus;
                if (focusPathNeedsUpdating) {
                    Interface.calculateFocusPath(dialog);
                }
            }
            focusIndex = focusPath.indexOf(focus);
            changed = true;
        }
    }

    static void setCurrentMousePointer(MousePointer pointer) {
        if (pointer != mousePointer) {
            changed = true;
        }
        mousePointer = pointer;
    }

    static void setFocusPathNeedsUpdating(boolean newFocusPathNeedsUpdating) {
        focusPathNeedsUpdating = newFocusPathNeedsUpdating;
    }

    static void bringToFront(Dialog dialog) {
        if (Interface.dialog == dialog) {
            return;
        }
        if (!dialogs.contains(dialog)) {
            return;
        }
        dialogs.remove(dialog);
        dialogs.add(dialog);
        Interface.dialogsShuffled();
    }

    static void sendToBack(Dialog dialog) {
        if (dialogs.size() <= 1) {
            return;
        }
        if (!dialogs.contains(dialog)) {
            return;
        }
        dialogs.remove(dialog);
        dialogs.add(0, dialog);
        Interface.dialogsShuffled();
    }

    public static GLFont getDefaultFont() {
        return defaultFont;
    }

    public static Color getDefaultBackground() {
        return defaultBackground;
    }

    public static Color getDefaultForeground() {
        return defaultForeground;
    }

    public static void setDefaultBackground(Color defaultBackground) {
        Interface.defaultBackground = defaultBackground;
    }

    public static void setDefaultFont(GLFont defaultFont) {
        Interface.defaultFont = defaultFont;
    }

    public static void setDefaultForeground(Color defaultForeground) {
        Interface.defaultForeground = defaultForeground;
    }

    public static Color getControlBackgroundColor() {
        return controlBackgroundColor;
    }

    public static void setControlBackgroundColor(Color controlBackgroundColor) {
        Interface.controlBackgroundColor = controlBackgroundColor;
    }

    public static Color getControlDisabledTextColor() {
        return controlDisabledTextColor;
    }

    public static void setControlDisabledTextColor(Color controlDisabledTextColor) {
        Interface.controlDisabledTextColor = controlDisabledTextColor;
    }

    public static Color getControlEnabledTextColor() {
        return controlEnabledTextColor;
    }

    public static void setControlEnabledTextColor(Color controlEnabledTextColor) {
        Interface.controlEnabledTextColor = controlEnabledTextColor;
    }

    public static GLFont getControlFont() {
        return controlFont;
    }

    public static void setControlFont(GLFont controlFont) {
        Interface.controlFont = controlFont;
    }

    public static Color getControlSelectedTextColor() {
        return controlSelectedTextColor;
    }

    public static void setControlSelectedTextColor(Color controlSelectedTextColor) {
        Interface.controlSelectedTextColor = controlSelectedTextColor;
    }

    public static Color getWindowActiveTitleBarColor() {
        return windowActiveTitleBarColor;
    }

    public static void setWindowActiveTitleBarColor(Color windowActiveTitleBarColor) {
        Interface.windowActiveTitleBarColor = windowActiveTitleBarColor;
    }

    public static Color getWindowActiveTitleTextColor() {
        return windowActiveTitleTextColor;
    }

    public static void setWindowActiveTitleTextColor(Color windowActiveTitleTextColor) {
        Interface.windowActiveTitleTextColor = windowActiveTitleTextColor;
    }

    public static Color getWindowBackgroundColor() {
        return windowBackgroundColor;
    }

    public static void setWindowBackgroundColor(Color windowBackgroundColor) {
        Interface.windowBackgroundColor = windowBackgroundColor;
    }

    public static int getWindowBorderSize() {
        return windowBorderSize;
    }

    public static void setWindowBorderSize(int windowBorderSize) {
        Interface.windowBorderSize = windowBorderSize;
    }

    public static Color getWindowInactiveTitleBarColor() {
        return windowInactiveTitleBarColor;
    }

    public static void setWindowInactiveTitleBarColor(Color windowInactiveTitleBarColor) {
        Interface.windowInactiveTitleBarColor = windowInactiveTitleBarColor;
    }

    public static Color getWindowInactiveTitleTextColor() {
        return windowInactiveTitleTextColor;
    }

    public static void setWindowInactiveTitleTextColor(Color windowInactiveTitleTextColor) {
        Interface.windowInactiveTitleTextColor = windowInactiveTitleTextColor;
    }

    public static GLFont getWindowTitleFont() {
        return windowTitleFont;
    }

    public static void setWindowTitleFont(GLFont windowTitleFont) {
        Interface.windowTitleFont = windowTitleFont;
    }

    static void dumpWindows() {
        int i = 0;
        while (i < dialogs.size()) {
            System.out.println(dialogs.get(i));
            ++i;
        }
    }

    public static float getDoubleClickTime() {
        return doubleClickTime;
    }

    public static void setDoubleClickTime(float doubleClickTime) {
        Interface.doubleClickTime = doubleClickTime;
    }

    public static void addConsoleListener(ConsoleListener listener) {
        console.remove(listener);
        console.add(listener);
    }

    public static void removeConsoleListener(ConsoleListener listener) {
        console.remove(listener);
    }

    public static boolean isConsoleVisible() {
        return console.isVisible();
    }

    public static void setIgnoreInput(boolean ignore) {
        ignoreInput = ignore;
    }
}

