/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLTexture;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.Point;
import org.lwjgl.util.Rectangle;
import xap.FluxMouse;
import xap.gui.Component;
import xap.gui.Dialog;
import xap.gui.DropdownListener;
import xap.gui.Interface;
import xap.gui.Label;
import xap.gui.ListBox;
import xap.gui.ListBoxListener;
import xap.gui.MouseAdapter;
import xap.gui.ScrollPane;
import xap.gui.SelectionListener;
import xap.gui.SwirlyBackground;

public class Dropdown
extends Component {
    private ScrollPane scrollPane;
    private Component button;
    private ListBox listBox;
    private Label label;
    private Dialog popup;
    private static GLTexture dropdownTexture;
    private boolean popupVisible;
    private final SwirlyBackground swirlyBackground = new SwirlyBackground(this, 64.0f, 64.0f, null);
    private static final Rectangle tempBounds;
    private ArrayList dropdownListeners;
    private Object selectedValue;
    private int selectedRow;
    private Object[] value;
    private final EventHandler eventHandler = new EventHandler();

    static {
        tempBounds = new Rectangle();
    }

    public Dropdown(Object[] values) throws Exception {
        this.value = values;
        dropdownTexture = (GLTexture)Resources.get((String)"dropdowns.texture");
        this.setBackgroundColor(Interface.getControlBackgroundColor());
        this.label = new Label();
        this.label.pack();
        this.listBox = new ListBox(this.value);
        this.listBox.setBackgroundColor(new Color(0, 0, 64, 64));
        this.button = new Component(){

            protected void renderSelf() {
                dropdownTexture.render();
                float tx = Dropdown.this.isSelectDown() ? 0.5f : 0.0f;
                GL11.glEnable((int)3553);
                GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                GL11.glBegin((int)7);
                GL11.glTexCoord2f((float)tx, (float)1.0f);
                GL11.glVertex2i((int)0, (int)0);
                GL11.glTexCoord2f((float)(tx + 0.5f), (float)1.0f);
                GL11.glVertex2i((int)16, (int)0);
                GL11.glTexCoord2f((float)(tx + 0.5f), (float)0.0f);
                GL11.glVertex2i((int)16, (int)16);
                GL11.glTexCoord2f((float)tx, (float)0.0f);
                GL11.glVertex2i((int)0, (int)16);
                GL11.glEnd();
            }
        };
        this.scrollPane = new ScrollPane(2, 0);
        this.scrollPane.setSize(this.listBox.getWidth(), this.label.getHeight() * 8);
        this.scrollPane.setView(this.listBox);
        this.scrollPane.setClipped(false);
        this.addChild(this.label);
        this.addChild(this.button);
        this.setSelectedValue(this.value[0]);
        this.label.setDelegate(this);
        this.button.setDelegate(this);
        this.addSelectionListener(this.eventHandler);
        this.listBox.addListListener(this.eventHandler);
        this.popup = new Dialog(){
            {
                this.addChild(Dropdown.this.scrollPane);
                this.setSize(Dropdown.this.scrollPane.getWidth(), Dropdown.this.scrollPane.getHeight());
            }

            public void doLayout() {
                this.setSize(Dropdown.this.scrollPane.getWidth(), Dropdown.this.scrollPane.getHeight());
            }

            protected boolean isPopup() {
                return true;
            }

            protected boolean doTick() {
                if (Mouse.isButtonDown((int)0) && Interface.getCapture() == null && this.getComponentUnderMouse(new Point(FluxMouse.getX(), FluxMouse.getY())) == null) {
                    Dropdown.this.setPopupVisible(false);
                }
                return super.doTick();
            }
        };
        this.layout();
    }

    protected boolean doTick() {
        if (this.hasFocus()) {
            this.swirlyBackground.doTick();
        }
        return super.doTick();
    }

    protected void renderBackground() {
        if (this.hasFocus()) {
            this.swirlyBackground.render();
        } else {
            super.renderBackground();
        }
    }

    public void doLayout() {
        this.label.setWidth(this.getWidth() - (this.button.getWidth() + 3));
        this.button.setBounds(this.label.getX() + this.label.getWidth() + 3, 0, 16, 16);
        this.scrollPane.setSize(this.getWidth(), this.label.getHeight() * 8);
        this.popup.layout();
    }

    public void toggle() {
        this.setPopupVisible(!this.popupVisible);
    }

    public boolean isPopupVisible() {
        return this.popupVisible;
    }

    public void setPopupVisible(boolean visible) {
        this.popupVisible = visible;
        if (this.popupVisible) {
            Point loc = this.getScreenLocation(null);
            loc.setY(Math.max(0, loc.getY() - this.popup.getHeight()));
            this.popup.setLocation(loc.getX(), loc.getY());
            this.popup.open();
        } else {
            this.popup.close();
        }
    }

    public void addDropdownListener(DropdownListener listener) {
        if (this.dropdownListeners == null) {
            this.dropdownListeners = new ArrayList(1);
        }
        this.dropdownListeners.add(listener);
    }

    public void removeDropdownListener(DropdownListener listener) {
        if (this.dropdownListeners != null) {
            this.dropdownListeners.remove(listener);
            if (this.dropdownListeners.size() == 0) {
                this.dropdownListeners = null;
            }
        }
    }

    private void fireSelectionEvent() {
        if (this.dropdownListeners != null) {
            Iterator i = this.dropdownListeners.iterator();
            while (i.hasNext()) {
                ((DropdownListener)i.next()).selectionMade(this, this.getSelectedValue());
            }
        }
    }

    public Object getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(Object newSelectedValue) {
        int i = 0;
        while (i < this.value.length) {
            if (this.value[i].equals(newSelectedValue)) {
                this.listBox.selectRow(this.selectedRow, false);
                this.selectedRow = i;
                this.listBox.selectRow(this.selectedRow, true);
                this.selectedValue = this.value[i];
                this.label.setText(this.selectedValue.toString());
                return;
            }
            ++i;
        }
    }

    private class EventHandler
    extends MouseAdapter
    implements SelectionListener,
    ListBoxListener {
        EventHandler() {
        }

        public boolean selected(Component src) {
            Dropdown.this.toggle();
            return false;
        }

        public boolean selectDown(Component src) {
            return false;
        }

        public boolean selectUp(Component src) {
            return false;
        }

        public void rowSelected(ListBox list, int row, boolean selected) {
            if (selected) {
                Dropdown.this.setPopupVisible(false);
                Dropdown.this.setSelectedValue(Dropdown.this.value[row]);
            }
        }

        public void rowsDeleted(ListBox list, int start, int end) {
        }

        public void rowsInserted(ListBox list, int start, int end) {
        }

        public void rowsUpdated(ListBox list, int start, int end) {
        }
    }
}

