/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import java.util.Iterator;
import org.lwjgl.util.Color;
import xap.gui.Component;
import xap.gui.Interface;
import xap.gui.Panel;
import xap.gui.SwirlyBackground;

public class Dialog
extends Panel {
    private final String name;
    Component focus;
    private Component defaultFocus;
    private static final float COLOR_VARIATION = 90.0f;
    private static final float ALPHA_VARIATION = 0.0f;
    private final SwirlyBackground swirlyBackground = new SwirlyBackground(this, 90.0f, 0.0f, null);
    boolean addedToGui;

    public Dialog() {
        this("Dialog");
    }

    public Dialog(String name) {
        this.name = name;
        this.setBackgroundColor(new Color(64, 64, 64, 128));
        this.setVisible(false);
    }

    public Component centre() {
        this.setLocation((800 - this.getWidth()) / 2 + this.border.getX(), (600 - this.getHeight()) / 2 + this.border.getY());
        return this;
    }

    public void close() {
        if (!this.isVisible()) {
            return;
        }
        Interface.remove(this);
        this.addedToGui = false;
    }

    public void open() {
        this.setVisible(true);
    }

    protected boolean doTick() {
        return this.swirlyBackground.doTick();
    }

    public final Component getCurrentFocus() {
        return this.focus;
    }

    public final boolean isActive() {
        return this.isPopup() || Interface.isActiveDialog(this);
    }

    protected void renderBackground() {
        this.swirlyBackground.render();
    }

    public void toFront() {
        Interface.bringToFront(this);
    }

    public void setDefaultFocus(Component df) {
        this.defaultFocus = df;
    }

    public Component getDefaultFocus() {
        if (this.defaultFocus != null) {
            return this.defaultFocus;
        }
        return this.findDefaultFocus(this);
    }

    private Component findDefaultFocus(Component root) {
        if (root.children == null) {
            return null;
        }
        Iterator i = root.children.iterator();
        while (i.hasNext()) {
            Component panel = (Component)i.next();
            if (panel.isVisible() && panel.isEnabled() && panel.canFocus) {
                return panel;
            }
            if ((panel = this.findDefaultFocus(panel)) == null) continue;
            return panel;
        }
        return null;
    }

    public void toBack() {
        Interface.sendToBack(this);
    }

    public Component setEnabled(boolean newEnabled) {
        super.setEnabled(newEnabled);
        Interface.dialogsShuffled();
        return this;
    }

    public Component setVisible(boolean newVisible) {
        if (newVisible != this.isVisible()) {
            super.setVisible(newVisible);
            if (newVisible && !this.addedToGui) {
                this.addedToGui = true;
                Interface.add(this);
            } else {
                Interface.dialogsShuffled();
            }
        }
        return this;
    }

    public String toString() {
        return this.name;
    }

    public Dialog getDialog() {
        return this;
    }

    protected boolean isPopup() {
        return false;
    }
}

