/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.CosineInterpolator;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLString;
import com.shavenpuppy.jglib.opengl.GLTexture;
import com.shavenpuppy.jglib.util.ImprovedStringTokenizer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.Timer;
import xap.gui.Component;
import xap.gui.ConsoleListener;
import xap.gui.Dialog;
import xap.gui.Editor;
import xap.gui.EditorListener;
import xap.gui.KeyboardListener;
import xap.gui.Slider;
import xap.gui.SliderListener;
import xap.gui.TextField;

public class Console
extends Dialog {
    private static final Color defaultBackgroundColor = new Color(128, 128, 128);
    private static final int MAX_LINES = 200;
    private static final int MAX_DISPLAYED = 50;
    private static final int MAX_HISTORY = 100;
    private final ArrayList lines = new ArrayList(200);
    private final ArrayList strings = new ArrayList(50);
    private final ArrayList history = new ArrayList(100);
    private int numLinesVisible;
    private StringBuffer buffer = new StringBuffer(80);
    private int currentLine = 0;
    private int startDisplay = -1;
    private GLTexture texture;
    private final TextField editor;
    private final Slider scrollBar;
    private final ArrayList listeners = new ArrayList();
    private static final int STATE_UP = 0;
    private static final int STATE_DOWN = 1;
    private static final float TRANSITION_SPEED = 0.5f;
    private int state = 0;
    private final Timer timer = new Timer();
    final ConsoleOutput output;
    private boolean textUpdated;

    public Console() throws Exception {
        this.timer.set(0.5f);
        this.output = new ConsoleOutput(System.out);
        this.textUpdated = true;
        this.setFont((GLFont)Resources.get((String)"arial-plain-12.glfont"));
        this.setBounds(0, 600, 800, 300);
        this.editor = new TextField(255);
        this.editor.setLocation(0, 0);
        this.editor.setText("");
        this.addChild(this.editor);
        this.editor.addEditorListener(new EditorListener(){

            public boolean editChanged(Editor editor, int key) {
                if (key == 28) {
                    String cmd = editor.getText();
                    Console.this.fireConsoleEvent(cmd);
                    int s = Console.this.history.size();
                    if (s == 0 || !Console.this.history.get(s - 1).equals(cmd)) {
                        Console.this.history.add(cmd);
                        Console.this.currentLine = s + 1;
                    } else {
                        Console.this.currentLine = s;
                    }
                    Console.this.editor.setText("");
                }
                return true;
            }
        });
        this.editor.addKeyboardListener(new KeyboardListener(){

            public boolean keyUp(Component src, int key) {
                return false;
            }

            public boolean keyDown(Component src, int key) {
                return false;
            }

            public boolean keyTyped(Component src, int key) {
                switch (key) {
                    case 201: {
                        Console.this.startDisplay = Math.max(Console.this.numLinesVisible, Console.this.startDisplay - 1);
                        break;
                    }
                    case 209: {
                        Console.this.startDisplay = Math.min(Console.this.lines.size() - 1, Console.this.startDisplay + 1);
                        break;
                    }
                    case 200: {
                        if (Console.this.currentLine <= 0) break;
                        Console console = Console.this;
                        console.currentLine = console.currentLine - 1;
                        Console.this.editor.setText((String)Console.this.history.get(Console.this.currentLine));
                        break;
                    }
                    case 208: {
                        if (Console.this.currentLine < Console.this.history.size() - 1) {
                            Console console = Console.this;
                            console.currentLine = console.currentLine + 1;
                            Console.this.editor.setText((String)Console.this.history.get(Console.this.currentLine));
                            break;
                        }
                        if (Console.this.currentLine != Console.this.history.size() - 1) break;
                        Console console = Console.this;
                        console.currentLine = console.currentLine + 1;
                        Console.this.editor.setText("");
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        });
        this.scrollBar = new Slider(1, true);
        this.scrollBar.setBounds(this.getWidth() - 16, 16, 16, 284);
        this.scrollBar.setMinValue(0);
        this.scrollBar.setMaxValue(0);
        this.scrollBar.setVisible(false);
        this.addChild(this.scrollBar);
        this.scrollBar.addSliderListener(new SliderListener(){

            public boolean valueChanged(Slider slider, int oldValue, int newValue) {
                Console.this.startDisplay = newValue;
                Console.this.textUpdated = true;
                Console.this.setChanged(true);
                return false;
            }
        });
    }

    protected boolean doTick() {
        super.doTick();
        float time = this.timer.getTime();
        if (time < 0.5f) {
            switch (this.state) {
                case 1: {
                    this.setLocation(0, (int)CosineInterpolator.instance.interpolate(600.0f, 300.0f, time / 0.5f));
                    break;
                }
                case 0: {
                    this.setLocation(0, (int)CosineInterpolator.instance.interpolate(300.0f, 600.0f, time / 0.5f));
                }
            }
        } else if (this.state == 0) {
            if (this.isVisible()) {
                this.setVisible(false);
                this.toBack();
            }
        } else {
            this.setLocation(0, 300);
            this.toFront();
        }
        if (this.isChanged()) {
            this.editor.setSize(this.getWidth(), this.getFont().getHeight());
            this.editor.setFont(this.getFont());
            this.editor.layout();
        }
        return true;
    }

    public void hide() {
        if (this.state != 0) {
            this.state = 0;
            this.timer.reset();
            this.setChanged(true);
        }
    }

    public synchronized void println(String s) {
        this.lines.add(s);
        if (this.lines.size() >= 200) {
            this.lines.remove(0);
        }
        if (!this.scrollBar.isVisible() || this.scrollBar.getCurrentValue() == this.startDisplay) {
            this.startDisplay = this.lines.size() - 1;
            this.scrollBar.setMinValue(this.startDisplay);
            this.scrollBar.setCurrentValue(this.startDisplay);
        } else {
            this.scrollBar.setMinValue(this.lines.size() - 1);
        }
        this.setChanged(true);
        this.textUpdated = true;
    }

    private synchronized void rebuild() {
        this.numLinesVisible = this.size.getHeight() / this.getFont().getHeight();
        int n = this.strings.size();
        if (n < this.numLinesVisible) {
            int i = 0;
            while (i < this.numLinesVisible - n) {
                this.strings.add(new GLString(132));
                ++i;
            }
        }
        n = Math.max(this.numLinesVisible, n);
        int count = 0;
        int i = this.startDisplay;
        while (i >= 0 && i > this.startDisplay - this.numLinesVisible) {
            GLString s = (GLString)this.strings.get(count);
            s.setFont(this.getFont());
            s.setText((String)this.lines.get(i));
            s.setLocation(0, this.getFont().getHeight() * ++count);
            --i;
        }
        if (this.lines.size() > this.numLinesVisible) {
            this.scrollBar.setVisible(true);
            this.scrollBar.setCurrentRange(this.numLinesVisible);
        }
        this.textUpdated = false;
    }

    public void renderBackground() {
        Color fg;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.texture != null) {
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            GL11.glEnable((int)3553);
            this.texture.render();
        }
        if ((fg = this.getBackgroundColor()) == null) {
            fg = defaultBackgroundColor;
        }
        GL11.glBegin((int)7);
        this.setGLColor(fg.getRed(), fg.getGreen(), fg.getBlue(), 255);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2i((int)0, (int)this.size.getHeight());
        this.setGLColor(fg.getRed(), fg.getGreen(), fg.getBlue(), 0);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2i((int)0, (int)0);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2i((int)this.size.getWidth(), (int)0);
        this.setGLColor(fg.getRed(), fg.getGreen(), fg.getBlue(), 255);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2i((int)this.size.getWidth(), (int)this.size.getHeight());
        GL11.glEnd();
        if (this.texture != null) {
            GL11.glDisable((int)3553);
        }
        GL11.glDisable((int)3042);
    }

    public synchronized void renderSelf() {
        if (this.textUpdated) {
            this.rebuild();
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
        int count = 0;
        int i = this.startDisplay;
        while (i >= 0 && i > this.startDisplay - this.numLinesVisible) {
            GLString s = (GLString)this.strings.get(count++);
            s.render();
            --i;
        }
        GL11.glDisable((int)3553);
    }

    public void setTexture(GLTexture texture) {
        this.texture = texture;
        this.setChanged(true);
    }

    public void show() {
        if (this.state != 1) {
            this.state = 1;
            this.setVisible(true);
            this.timer.reset();
            this.setChanged(true);
            this.requestFocus();
        }
    }

    public void write(byte[] b) throws IOException {
        int i = 0;
        while (i < b.length) {
            this.write(b[i]);
            ++i;
        }
    }

    public void write(byte[] b, int off, int len) {
        int i = off;
        while (i < off + len) {
            this.write(b[i]);
            ++i;
        }
    }

    public void write(int b) {
        if (b == 10) {
            this.println(this.buffer.toString());
            this.buffer.setLength(0);
        } else {
            if (b == 13) {
                return;
            }
            this.buffer.append((char)b);
        }
    }

    public void add(ConsoleListener listener) {
        this.listeners.add(listener);
    }

    public void remove(ConsoleListener listener) {
        this.listeners.remove(listener);
    }

    private void fireConsoleEvent(String commandLine) {
        ArrayList<String> cmnds = new ArrayList<String>();
        ImprovedStringTokenizer st = new ImprovedStringTokenizer(commandLine);
        while (st.hasMoreTokens()) {
            cmnds.add(st.nextToken());
        }
        String[] parsed = new String[cmnds.size()];
        cmnds.toArray(parsed);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ConsoleListener)i.next()).commandEntered(parsed);
        }
    }

    public String toString() {
        return "Console";
    }

    private class ConsoleOutput
    extends OutputStream {
        private PrintStream out;

        public ConsoleOutput(PrintStream original) {
            this.out = original;
        }

        public void write(byte[] b) throws IOException {
            Console.this.write(b);
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) {
            Console.this.write(b, off, len);
            this.out.write(b, off, len);
        }

        public void write(int b) {
            Console.this.write(b);
            this.out.write(b);
        }
    }
}

