/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.GLTexture;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.ReadableColor;
import xap.gui.CommandButton;
import xap.gui.CommandButtonListener;
import xap.gui.Component;
import xap.gui.Interface;
import xap.gui.Label;
import xap.gui.MouseAdapter;
import xap.gui.SelectionListener;

public class CommandButton
extends Component {
    protected Label label;
    protected boolean isDefault;
    protected boolean isCancel;
    protected boolean useEffect = true;
    private static final int DEFAULT = 0;
    private static final int HIGHLIGHTED = 1;
    private int currentState = 0;
    private int newState = 0;
    private static final int TRANSITION_SPEED = 12;
    private static final int TOTAL_TRANSITION = 24;
    private int ticker = 1;
    private final Color disabledColor = new Color(192, 192, 192, 128);
    private final Color highlightColor = new Color(255, 255, 255, 255);
    private final Color defaultColor = new Color((ReadableColor)Interface.getDefaultForeground());
    private final Dimension labelSize = new Dimension();
    private ArrayList commandButtonListeners = new ArrayList();
    private GLTexture roundedRectangle;
    private final int CORNER_RADIUS = 16;
    private final int LEFT_MARGIN = 12;
    private final int RIGHT_MARGIN = 8;
    private final Color textColor = new Color();

    public CommandButton() throws Exception {
        this("");
    }

    public CommandButton(String text) throws Exception {
        this.label = new Label();
        this.label.setDelegate(this);
        this.label.setCanFocus(false);
        this.label.setAlignment(1);
        this.label.setClipped(false);
        this.addChild(this.label);
        this.setClipped(!this.useEffect);
        this.setText(text);
        this.pack();
        this.layout();
        this.setBorder(5, 5, 5, 5);
        this.roundedRectangle = (GLTexture)Resources.get((String)"commandbutton.texture");
        class EventHandler
        extends MouseAdapter
        implements SelectionListener {
            final /* synthetic */ CommandButton this$0;

            EventHandler(CommandButton commandButton) {
                this.this$0 = commandButton;
            }

            public boolean selectDown(Component src) {
                return false;
            }

            public boolean selectUp(Component src) {
                return false;
            }

            public boolean selected(Component src) {
                Iterator<E> i = CommandButton.access$0(this.this$0).iterator();
                while (i.hasNext()) {
                    ((CommandButtonListener)i.next()).selected(this.this$0);
                }
                this.this$0.setChanged(true);
                return false;
            }

            public boolean mouseEntered(Component src, int x, int y, int buttonFlags) {
                CommandButton.access$1(this.this$0, 1);
                CommandButton.access$3(this.this$0, 12 - Math.min(12, CommandButton.access$2(this.this$0)));
                return false;
            }

            public boolean mouseExited(Component src, int x, int y, int buttonFlags) {
                CommandButton.access$1(this.this$0, 0);
                CommandButton.access$3(this.this$0, 24 - CommandButton.access$2(this.this$0));
                return false;
            }
        }
        EventHandler eventHandler = new EventHandler(this);
        this.addMouseListener(eventHandler);
        this.addSelectionListener(eventHandler);
    }

    public void addCommandButtonListener(CommandButtonListener listener) {
        this.commandButtonListeners.add(listener);
    }

    public void doLayout() {
        this.label.setWidth(this.size.getWidth() - 20);
    }

    protected boolean doTick() {
        boolean ret = false;
        if (!this.isEnabled()) {
            if (this.isChanged()) {
                this.label.setForegroundColor(this.disabledColor);
            }
        } else if (this.currentState != this.newState || this.ticker > 0) {
            if (this.ticker > 0) {
                --this.ticker;
            }
            if (this.ticker == 0) {
                this.currentState = this.newState;
            }
            float transition = (float)Math.min(12, this.ticker) / 12.0f;
            Color fg = this.getForegroundColor();
            if (fg == null) {
                fg = this.defaultColor;
            }
            switch (this.newState) {
                case 0: {
                    this.textColor.set((int)LinearInterpolator.instance.interpolate((float)fg.getRed(), (float)this.highlightColor.getRed(), transition), (int)LinearInterpolator.instance.interpolate((float)fg.getGreen(), (float)this.highlightColor.getGreen(), transition), (int)LinearInterpolator.instance.interpolate((float)fg.getBlue(), (float)this.highlightColor.getBlue(), transition), (int)LinearInterpolator.instance.interpolate((float)fg.getAlpha(), (float)this.highlightColor.getAlpha(), transition));
                    this.label.setForegroundColor(this.textColor);
                    break;
                }
                case 1: {
                    this.textColor.set((int)LinearInterpolator.instance.interpolate((float)this.highlightColor.getRed(), (float)fg.getRed(), transition), (int)LinearInterpolator.instance.interpolate((float)this.highlightColor.getGreen(), (float)fg.getGreen(), transition), (int)LinearInterpolator.instance.interpolate((float)this.highlightColor.getBlue(), (float)fg.getBlue(), transition), (int)LinearInterpolator.instance.interpolate((float)this.highlightColor.getAlpha(), (float)fg.getAlpha(), transition));
                    this.label.setForegroundColor(this.textColor);
                    break;
                }
            }
            ret = true;
        } else if (this.isChanged()) {
            switch (this.currentState) {
                case 0: {
                    Color fg = this.getForegroundColor();
                    if (fg == null) {
                        fg = this.defaultColor;
                    }
                    this.label.setForegroundColor(fg);
                    break;
                }
                case 1: {
                    this.label.setForegroundColor(this.highlightColor);
                }
            }
        }
        this.label.getSize(this.labelSize);
        if (this.isSelectDown()) {
            this.label.setLocation(12, 0);
        } else {
            this.label.setLocation(10, 2);
        }
        return ret;
    }

    public void setUseEffect(boolean useEffect) {
        this.useEffect = useEffect;
        this.setClipped(!useEffect);
    }

    protected void postRender() {
        if (this.hasFocus() && this.useEffect) {
            GL11.glPopMatrix();
        }
    }

    protected void preRender() {
        if (this.hasFocus() && this.useEffect) {
            GL11.glPushMatrix();
            float scale = (float)Math.cos(Interface.getTime() * 8.0f) / 16.0f + 1.0f;
            GL11.glTranslatef((float)((float)this.getWidth() / 2.0f), (float)((float)this.getHeight() / 2.0f), (float)0.0f);
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            GL11.glTranslatef((float)((float)this.getWidth() / -2.0f), (float)((float)this.getHeight() / -2.0f), (float)0.0f);
        }
    }

    public void removeCommandButtonListener(CommandButtonListener listener) {
        this.commandButtonListeners.remove(listener);
    }

    protected void renderBackground() {
        GL11.glEnable((int)3553);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glBlendFunc((int)770, (int)1);
        this.setGLColor(60, 40, 100, 128 >> (this.getDialog().isActive() ? 0 : 2));
        this.roundedRectangle.render();
        int cornerRadius = Math.min(Math.min(16, this.getHeight() / 2), this.getWidth() / 2);
        GL11.glBegin((int)8);
        this.vertex(0, 0, 0.0f, 1.0f);
        this.vertex(0, cornerRadius, 0.0f, 0.6666667f);
        this.vertex(cornerRadius, 0, 0.3333333f, 1.0f);
        this.vertex(cornerRadius, cornerRadius, 0.3333333f, 0.6666667f);
        this.vertex(this.getWidth() - cornerRadius, 0, 0.6666667f, 1.0f);
        this.vertex(this.getWidth() - cornerRadius, cornerRadius, 0.6666667f, 0.6666667f);
        this.vertex(this.getWidth(), 0, 1.0f, 1.0f);
        this.vertex(this.getWidth(), cornerRadius, 1.0f, 0.6666667f);
        GL11.glEnd();
        GL11.glBegin((int)8);
        this.vertex(0, cornerRadius, 0.0f, 0.6666667f);
        this.vertex(0, this.getHeight() - cornerRadius, 0.0f, 0.3333333f);
        this.vertex(cornerRadius, cornerRadius, 0.3333333f, 0.6666667f);
        this.vertex(cornerRadius, this.getHeight() - cornerRadius, 0.3333333f, 0.3333333f);
        this.vertex(this.getWidth() - cornerRadius, cornerRadius, 0.6666667f, 0.6666667f);
        this.vertex(this.getWidth() - cornerRadius, this.getHeight() - cornerRadius, 0.6666667f, 0.3333333f);
        this.vertex(this.getWidth(), cornerRadius, 1.0f, 0.6666667f);
        this.vertex(this.getWidth(), this.getHeight() - cornerRadius, 1.0f, 0.3333333f);
        GL11.glEnd();
        GL11.glBegin((int)8);
        this.vertex(0, this.getHeight() - cornerRadius, 0.0f, 0.3333333f);
        this.vertex(0, this.getHeight(), 0.0f, 0.0f);
        this.vertex(cornerRadius, this.getHeight() - cornerRadius, 0.3333333f, 0.3333333f);
        this.vertex(cornerRadius, this.getHeight(), 0.3333333f, 0.0f);
        this.vertex(this.getWidth() - cornerRadius, this.getHeight() - cornerRadius, 0.6666667f, 0.3333333f);
        this.vertex(this.getWidth() - cornerRadius, this.getHeight(), 0.6666667f, 0.0f);
        this.vertex(this.getWidth(), this.getHeight() - cornerRadius, 1.0f, 0.3333333f);
        this.vertex(this.getWidth(), this.getHeight(), 1.0f, 0.0f);
        GL11.glEnd();
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private void vertex(int x, int y, float tx, float ty) {
        GL11.glTexCoord2f((float)tx, (float)ty);
        GL11.glVertex2i((int)x, (int)y);
    }

    public void renderForeground() {
    }

    public CommandButton setText(String text) {
        this.label.setText(text);
        this.label.pack();
        this.setChanged(true);
        return this;
    }

    public String toString() {
        try {
            return "CommandButton " + this.label.getText();
        }
        catch (NullPointerException e) {
            return "CommandButton <unlabeled at construction>";
        }
    }

    public Component setEnabled(boolean newEnabled) {
        if (newEnabled && !this.isEnabled()) {
            this.updateLabelColor();
        }
        return super.setEnabled(newEnabled);
    }

    private void updateLabelColor() {
        if (this.currentState == 0) {
            this.setForegroundColor(this.defaultColor);
        } else if (this.currentState == 1) {
            this.setForegroundColor(this.highlightColor);
        }
        this.setChanged(true);
    }

    public void setHighlightColor(int r, int g, int b, int a) {
        this.highlightColor.set(r, g, b, a);
        this.setChanged(true);
        this.updateLabelColor();
    }

    public void setDisabledColor(int r, int g, int b, int a) {
        this.disabledColor.set(r, g, b, a);
        this.setChanged(true);
        this.updateLabelColor();
    }

    public void setDefaultColor(int r, int g, int b, int a) {
        this.defaultColor.set(r, g, b, a);
        this.setChanged(true);
        this.updateLabelColor();
    }

    static /* synthetic */ ArrayList access$0(CommandButton commandButton) {
        return commandButton.commandButtonListeners;
    }

    static /* synthetic */ void access$1(CommandButton commandButton, int n) {
        commandButton.newState = n;
    }

    static /* synthetic */ int access$2(CommandButton commandButton) {
        return commandButton.ticker;
    }

    static /* synthetic */ void access$3(CommandButton commandButton, int n) {
        commandButton.ticker = n;
    }
}

