/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.Game;
import xap.Gidrah;
import xap.features.EntityFeature;
import xap.features.GidrahFeature;
import xap.gidrahs.BasicGidrahFeature;
import xap.resources.HVMovement;
import xap.resources.HVMovementResource;

public class ZSphereFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    private String animation;
    private String shadowAnimation;
    private String splitsInto;
    private int minSplits;
    private int maxSplits;
    private int difficultyFactor;
    private HVMovementResource hvMovement;
    private transient Animation animationResource;
    private transient Animation shadowAnimationResource;
    private transient GidrahFeature splitsIntoFeature;

    public ZSphereFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new ZSphereInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.animation = XMLUtil.getString((Element)element, (String)"animation");
        this.shadowAnimation = XMLUtil.getString((Element)element, (String)"shadowanimation");
        this.splitsInto = XMLUtil.getString((Element)element, (String)"splitsinto");
        this.minSplits = XMLUtil.getInt((Element)element, (String)"minsplits");
        this.maxSplits = XMLUtil.getInt((Element)element, (String)"maxsplits");
        this.difficultyFactor = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"difficultyfactor"));
        this.hvMovement = new HVMovementResource();
        this.hvMovement.load(element, loader);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.animationResource = (Animation)Resources.get((String)this.animation);
        this.shadowAnimationResource = (Animation)Resources.get((String)this.shadowAnimation);
        this.splitsIntoFeature = (GidrahFeature)Resources.get((String)this.splitsInto);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.animationResource = null;
        this.shadowAnimationResource = null;
        this.splitsIntoFeature = null;
    }

    private class ZSphereInstance
    extends BasicGidrahFeature.BasicGidrahInstance {
        private HVMovement hvMovementInstance;

        ZSphereInstance() {
            this.hvMovementInstance = ZSphereFeature.this.hvMovement.spawn(this);
        }

        protected void initSprite() {
            this.sprite.setAnimation(ZSphereFeature.this.animationResource);
            this.shadowSprite.setAnimation(ZSphereFeature.this.shadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            this.hvMovementInstance.tick();
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
        }

        protected void doResIn() {
            this.randomLocation(this.position);
        }

        protected void onDeath() {
            super.onDeath();
            int mult = Game.getCurrentLevel() * ZSphereFeature.this.difficultyFactor;
            int num = ZSphereFeature.this.minSplits + FPMath.intValue((int)FPMath.mul((int)mult, (int)ZSphereFeature.this.maxSplits));
            int i = 0;
            while (i < num) {
                Gidrah gidrah = (Gidrah)ZSphereFeature.this.splitsIntoFeature.spawn();
                gidrah.setPosition(this.position.getX() + Util.random((int)(-FPMath.EIGHT), (int)FPMath.EIGHT), this.position.getY() + Util.random((int)(-FPMath.EIGHT), (int)FPMath.EIGHT), 0);
                ++i;
            }
        }
    }
}

