/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.features.EntityFeature;
import xap.gidrahs.BasicGidrahFeature;
import xap.resources.HVMovement;
import xap.resources.HVMovementResource;

public class ISphereFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    private String animation;
    private String shadowAnimation;
    private HVMovementResource hvMovement;
    private transient Animation animationResource;
    private transient Animation shadowAnimationResource;

    public ISphereFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new ISphereInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.animation = XMLUtil.getString((Element)element, (String)"animation");
        this.shadowAnimation = XMLUtil.getString((Element)element, (String)"shadowanimation");
        this.hvMovement = new HVMovementResource();
        this.hvMovement.load(element, loader);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.animationResource = (Animation)Resources.get((String)this.animation);
        this.shadowAnimationResource = (Animation)Resources.get((String)this.shadowAnimation);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.animationResource = null;
        this.shadowAnimationResource = null;
    }

    private class ISphereInstance
    extends BasicGidrahFeature.BasicGidrahInstance {
        private HVMovement hvMovementInstance;

        ISphereInstance() {
            this.hvMovementInstance = ISphereFeature.this.hvMovement.spawn(this);
        }

        protected void initSprite() {
            this.sprite.setAnimation(ISphereFeature.this.animationResource);
            this.shadowSprite.setAnimation(ISphereFeature.this.shadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            this.hvMovementInstance.tick();
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
        }

        protected void doResIn() {
        }
    }
}

