/*
 * Decompiled with CFR 0.152.
 */
package xap.features.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.Entity;
import xap.Game;
import xap.Nuke;
import xap.effects.StrobeEffect;
import xap.features.EntityFeature;

public class NukeFeature
extends EntityFeature {
    public static final long serialVersionUID = 1L;
    private static NukeFeature instance;
    private static final Color color;
    private String soundEffect;
    private int duration;
    private String colorSeq;
    private int shakeDuration;
    private int shakeMagnitude;
    private transient ALBuffer soundEffectResource;
    private transient ColorSequenceResource colorSeqResource;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.full.NukeFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        color = new Color();
    }

    public NukeFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new NukeInstance();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        if (Game.hasSound()) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
        this.colorSeqResource = (ColorSequenceResource)Resources.get((String)this.colorSeq);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.soundEffectResource = null;
        this.colorSeqResource = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect");
        this.duration = XMLUtil.getInt((Element)element, (String)"duration");
        this.colorSeq = XMLUtil.getString((Element)element, (String)"colorseq");
        this.shakeDuration = XMLUtil.getInt((Element)element, (String)"shakeduration");
        this.shakeMagnitude = XMLUtil.getInt((Element)element, (String)"shakemagnitude");
    }

    public void register() {
        super.register();
        if (!$assertionsDisabled && instance != null) {
            throw new AssertionError();
        }
        instance = this;
    }

    public void deregister() {
        super.deregister();
        instance = null;
    }

    public static void fire() throws Exception {
        if (!instance.isCreated()) {
            instance.create();
        }
        instance.spawn();
    }

    private class NukeInstance
    extends EntityFeature.EntityInstance
    implements Nuke {
        private int tick;

        public boolean canCollide() {
            return this.tick < 10;
        }

        protected void doRemove() {
        }

        public void spawn() {
            Game.shake(NukeFeature.this.shakeDuration, NukeFeature.this.shakeMagnitude);
            Game.allocateBackgroundSound(NukeFeature.this.soundEffectResource, this);
            StrobeEffect.spawn(NukeFeature.this.colorSeqResource);
        }

        protected void tick() {
            this.tick += Game.getOptions().getTicksPerFrame();
            if (this.tick > NukeFeature.this.duration) {
                this.remove();
            }
        }

        public void inCollisionWith(Entity dest) {
            dest.inCollisionWithNuke(this);
        }

        public boolean isTouching(Entity dest) {
            return true;
        }

        public float getRadarBlip(Color color, Vector3i pos) {
            return 0.0f;
        }
    }
}

