/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.util.ArrayList;
import xap.Feature;
import xap.Game;
import xap.SpecialEffect;
import xap.Ticked;
import xap.Ticker;
import xap.features.GameModeFeature;

public abstract class SpecialEffectFeature
extends Feature {
    public static final long serialVersionUID = 1L;
    private static final ArrayList backgroundEffects = new ArrayList(8);
    private static final ArrayList foregroundEffects = new ArrayList(8);
    private static final ArrayList effectsCopy = new ArrayList(8);

    static {
        if (Game.isRunning()) {
            Ticker.register(new Ticked(){

                public boolean tick() {
                    SpecialEffectFeature.tickAllEffects();
                    return true;
                }
            });
            GameModeFeature.addGameEventListener(new Feature(){

                public void onEndGame() throws Exception {
                    super.onEndGame();
                    SpecialEffectFeature.removeAllEffects();
                }

                public void onIntermission() throws Exception {
                    super.onIntermission();
                    SpecialEffectFeature.removeAllEffects();
                }
            });
        }
    }

    protected SpecialEffectFeature() {
    }

    protected SpecialEffectFeature(String name) {
        super(name);
    }

    public final SpecialEffect spawn(int x, int y, int z, int vx, int vy, int vz, boolean foreground) {
        SpecialEffectInstance ret = this.doSpawn();
        ret.foreground = foreground;
        ret.setPosition(x, y, z);
        ret.setVelocity(vx, vy, vz);
        if (foreground) {
            foregroundEffects.add(ret);
        } else {
            backgroundEffects.add(ret);
        }
        return ret;
    }

    protected abstract SpecialEffectInstance doSpawn();

    public static void tickAllEffects() {
        SpecialEffectInstance li;
        effectsCopy.clear();
        effectsCopy.addAll(backgroundEffects);
        int n = effectsCopy.size();
        int i = 0;
        while (i < n) {
            li = (SpecialEffectInstance)effectsCopy.get(i);
            li.tick();
            ++i;
        }
        effectsCopy.clear();
        effectsCopy.addAll(foregroundEffects);
        n = effectsCopy.size();
        i = 0;
        while (i < n) {
            li = (SpecialEffectInstance)effectsCopy.get(i);
            li.tick();
            ++i;
        }
    }

    public static void removeAllEffects() {
        SpecialEffectInstance li;
        effectsCopy.clear();
        effectsCopy.addAll(backgroundEffects);
        int n = effectsCopy.size();
        int i = 0;
        while (i < n) {
            li = (SpecialEffectInstance)effectsCopy.get(i);
            li.remove();
            ++i;
        }
        effectsCopy.clear();
        effectsCopy.addAll(foregroundEffects);
        n = effectsCopy.size();
        i = 0;
        while (i < n) {
            li = (SpecialEffectInstance)effectsCopy.get(i);
            li.remove();
            ++i;
        }
    }

    public static void renderBackgroundEffects() {
        int n = backgroundEffects.size();
        int i = 0;
        while (i < n) {
            SpecialEffectInstance li = (SpecialEffectInstance)backgroundEffects.get(i);
            try {
                li.render();
                ++i;
            }
            catch (Exception e) {
                System.out.println("Special effect " + li + " failed to render:");
                Game.handleException(e);
                backgroundEffects.remove(i);
                --n;
            }
        }
    }

    public static void renderForegroundEffects() {
        int n = foregroundEffects.size();
        int i = 0;
        while (i < n) {
            SpecialEffectInstance li = (SpecialEffectInstance)foregroundEffects.get(i);
            try {
                li.render();
                ++i;
            }
            catch (Exception e) {
                System.out.println("Special effect " + li + " failed to render:");
                Game.handleException(e);
                foregroundEffects.remove(i);
                --n;
            }
        }
    }

    protected abstract class SpecialEffectInstance
    implements SpecialEffect,
    GLRenderable {
        protected final Vector3i position = new Vector3i();
        protected final Vector3i velocity = new Vector3i();
        private int tick = -1;
        private boolean foreground;

        protected SpecialEffectInstance() {
        }

        public final Vector3i getPosition() {
            return this.position;
        }

        public final Vector3i getVelocity() {
            return this.velocity;
        }

        public final void setPosition(int x, int y, int z) {
            this.position.set(x, y, z);
        }

        public final void setVelocity(int x, int y, int z) {
            this.velocity.set(x, y, z);
        }

        public final Vector3i getPosition(Vector3i dest) {
            if (dest == null) {
                return new Vector3i((ReadableVector3i)this.position);
            }
            dest.set((ReadableVector3i)this.position);
            return dest;
        }

        public final Vector3i getVelocity(Vector3i dest) {
            if (dest == null) {
                return new Vector3i((ReadableVector3i)this.velocity);
            }
            dest.set((ReadableVector3i)this.velocity);
            return dest;
        }

        public final void tick() {
            this.tick += Game.getOptions().getTicksPerFrame();
            this.doTick();
            if (this.isVisible()) {
                this.position.translate(this.velocity.getX(), this.velocity.getY(), this.velocity.getZ());
            } else {
                this.remove();
            }
        }

        public final int getTick() {
            return this.tick;
        }

        public final void reset() {
            this.tick = -1;
        }

        public void remove() {
            if (this.foreground) {
                foregroundEffects.remove(this);
            } else {
                backgroundEffects.remove(this);
            }
            this.doRemove();
        }

        protected void doRemove() {
        }

        protected abstract void doTick();
    }
}

