/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.CosineInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.Entity;
import xap.Game;
import xap.SmartBomb;
import xap.effects.StrobeEffect;
import xap.features.EntityFeature;
import xap.features.PlayerFeature;

public class SmartBombFeature
extends EntityFeature {
    public static final long serialVersionUID = 1L;
    private static SmartBombFeature smartBombFeature;
    private static final Color tempColor0;
    private static final Color tempColor1;
    private int damage;
    private float blastRadius;
    private String colorSequence;
    private int duration;
    private int numBlastWaves;
    private String soundEffect;
    private int shakeDuration;
    private int shakeMagnitude;
    private String strobe;
    private transient ColorSequenceResource colorSequenceResource;
    private transient ALBuffer soundEffectResource;
    private transient ColorSequenceResource strobeResource;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.SmartBombFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        tempColor0 = new Color();
        tempColor1 = new Color();
    }

    public SmartBombFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.damage = XMLUtil.getInt((Element)element, (String)"damage");
        this.blastRadius = XMLUtil.getFloat((Element)element, (String)"blastradius");
        this.duration = XMLUtil.getInt((Element)element, (String)"duration");
        this.colorSequence = XMLUtil.getString((Element)element, (String)"colorsequence");
        this.numBlastWaves = XMLUtil.getInt((Element)element, (String)"numblastwaves");
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect");
        this.shakeDuration = XMLUtil.getInt((Element)element, (String)"shakeduration");
        this.shakeMagnitude = XMLUtil.getInt((Element)element, (String)"shakemagnitude");
        this.strobe = XMLUtil.getString((Element)element, (String)"strobe");
    }

    protected void doCreate() throws Exception {
        this.colorSequenceResource = (ColorSequenceResource)Resources.get((String)this.colorSequence);
        if (Game.hasSound()) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
        this.strobeResource = (ColorSequenceResource)Resources.get((String)this.strobe);
    }

    protected void doDestroy() {
        this.colorSequenceResource = null;
        this.soundEffectResource = null;
        this.strobeResource = null;
    }

    public void register() {
        super.register();
        if (!$assertionsDisabled && smartBombFeature != null) {
            throw new AssertionError();
        }
        smartBombFeature = this;
    }

    public void deregister() {
        super.deregister();
        smartBombFeature = null;
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new SmartBombInstance();
    }

    public static void fire() throws Exception {
        if (!smartBombFeature.isCreated()) {
            smartBombFeature.create();
        }
        smartBombFeature.spawn();
    }

    public static int getSmartBombRadius() {
        return FPMath.fpValue((float)SmartBombFeature.smartBombFeature.blastRadius);
    }

    private final class SmartBombInstance
    extends EntityFeature.EntityInstance
    implements SmartBomb {
        private int tick;
        private final Blast[] blast;

        SmartBombInstance() {
            this.blast = new Blast[SmartBombFeature.this.numBlastWaves];
            int delay = 0;
            int i = 0;
            while (i < this.blast.length) {
                this.blast[i] = new Blast();
                delay = this.blast[i].init(delay);
                ++i;
            }
        }

        public void spawn() {
            this.position.set((ReadableVector3i)PlayerFeature.getPlayer().getPosition());
            Game.allocateBackgroundSound(SmartBombFeature.this.soundEffectResource, this);
            Game.shake(SmartBombFeature.this.shakeDuration, SmartBombFeature.this.shakeMagnitude);
            StrobeEffect.spawn(SmartBombFeature.this.strobeResource);
        }

        protected void doRemove() {
        }

        protected void tick() {
            ++this.tick;
            int duration2 = SmartBombFeature.this.duration >> Game.getOptions().getSpeedShift();
            if (this.tick <= duration2) {
                this.setRadius(FPMath.fpValue((float)CosineInterpolator.instance.interpolate(0.0f, SmartBombFeature.this.blastRadius, (float)this.tick / (float)duration2)));
            }
            boolean dontRemove = false;
            int i = 0;
            while (i < this.blast.length) {
                this.blast[i].tick();
                if (this.blast[i].active) {
                    dontRemove = true;
                }
                ++i;
            }
            if (!dontRemove) {
                this.remove();
            }
        }

        public boolean canCollide() {
            return true;
        }

        public int getDamage() {
            return SmartBombFeature.this.damage;
        }

        public void inCollisionWith(Entity entity) {
            entity.inCollisionWithSmartBomb(this);
        }

        public void render() {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            int i = 0;
            while (i < this.blast.length) {
                this.blast[i].render();
                ++i;
            }
            GL11.glBlendFunc((int)1, (int)0);
            GL11.glDisable((int)3042);
        }

        public float getRadarBlip(Color color, Vector3i pos) {
            return 0.0f;
        }

        private class Blast {
            int tick;
            boolean active;

            Blast() {
            }

            int init(int delay) {
                int waitDuration = delay + Util.random((int)4, (int)8);
                this.tick = -waitDuration;
                this.active = true;
                return waitDuration;
            }

            void tick() {
                if (!this.active) {
                    return;
                }
                ++this.tick;
                if (this.tick >= SmartBombFeature.this.duration) {
                    this.active = false;
                }
            }

            void render() {
                if (!this.active || this.tick < 0) {
                    return;
                }
                SmartBombFeature.this.colorSequenceResource.getColor(this.tick, tempColor0);
                SmartBombFeature.this.colorSequenceResource.getColor(Math.max(0, this.tick - 5), tempColor1);
                tempColor1.setAlpha(0);
                int duration2 = SmartBombFeature.this.duration >> Game.getOptions().getSpeedShift();
                float outerRadius = CosineInterpolator.instance.interpolate(0.0f, SmartBombFeature.this.blastRadius, (float)this.tick / (float)duration2);
                float innerRadius = CosineInterpolator.instance.interpolate(0.0f, SmartBombFeature.this.blastRadius, (float)Math.max(0, this.tick - 1) / (float)duration2);
                GL11.glBegin((int)5);
                int i = 0;
                while (i <= 360) {
                    GL11.glColor4ub((byte)tempColor1.getRedByte(), (byte)tempColor1.getGreenByte(), (byte)tempColor1.getBlueByte(), (byte)tempColor1.getAlphaByte());
                    GL11.glVertex2f((float)(FPMath.floatValue((int)SmartBombInstance.this.position.getX()) + (float)Math.cos(Math.toRadians(i)) * innerRadius), (float)(FPMath.floatValue((int)SmartBombInstance.this.position.getY()) + (float)Math.sin(Math.toRadians(i)) * innerRadius));
                    GL11.glColor4ub((byte)tempColor0.getRedByte(), (byte)tempColor0.getGreenByte(), (byte)tempColor0.getBlueByte(), (byte)tempColor0.getAlphaByte());
                    GL11.glVertex2f((float)(FPMath.floatValue((int)SmartBombInstance.this.position.getX()) + (float)Math.cos(Math.toRadians(i)) * outerRadius), (float)(FPMath.floatValue((int)SmartBombInstance.this.position.getY()) + (float)Math.sin(Math.toRadians(i)) * outerRadius));
                    i += 12;
                }
                GL11.glEnd();
            }
        }
    }
}

