/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.Blob;
import xap.Entity;
import xap.Game;
import xap.Gidrah;
import xap.Rocket;
import xap.ThrusterEmitter;
import xap.effects.RocketTargetingEffect;
import xap.emitters.ThrusterEmitterFeature;
import xap.features.EntityFeature;

public class RocketFeature
extends EntityFeature {
    public static final long serialVersionUID = 1L;
    private static RocketFeature rocketFeature;
    private static final int DORMANT = 0;
    private static final int LOCKING_ON = 1;
    private static final int LAUNCHED = 2;
    private String spriteImagePrefix;
    private String shadowSpriteImagePrefix;
    private String exhaustEmitter;
    private int maxSpeed;
    private int thrust;
    private int launchDelay;
    private int range;
    private int shakeDuration;
    private int shakeMagnitude;
    private transient SpriteImage[] spriteImage;
    private transient SpriteImage[] shadowSpriteImage;
    private ThrusterEmitterFeature exhaustEmitterFeature;

    public RocketFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new RocketInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.spriteImagePrefix = XMLUtil.getString((Element)element, (String)"spriteimageprefix");
        this.shadowSpriteImagePrefix = XMLUtil.getString((Element)element, (String)"shadowspriteimageprefix");
        this.exhaustEmitter = XMLUtil.getString((Element)element, (String)"exhaustemitter");
        this.maxSpeed = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"maxspeed"));
        this.thrust = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"thrust"));
        this.launchDelay = XMLUtil.getInt((Element)element, (String)"launchdelay");
        this.range = XMLUtil.getInt((Element)element, (String)"range");
        this.shakeDuration = XMLUtil.getInt((Element)element, (String)"shakeduration");
        this.shakeMagnitude = XMLUtil.getInt((Element)element, (String)"shakemagnitude");
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.exhaustEmitterFeature = (ThrusterEmitterFeature)Resources.get((String)this.exhaustEmitter);
        this.spriteImage = new SpriteImage[32];
        int i = 0;
        while (i < 32) {
            this.spriteImage[i] = i < 10 ? (SpriteImage)Resources.get((String)("spriteimage." + this.spriteImagePrefix + "000" + i)) : (SpriteImage)Resources.get((String)("spriteimage." + this.spriteImagePrefix + "00" + i));
            ++i;
        }
        this.shadowSpriteImage = new SpriteImage[32];
        i = 0;
        while (i < 32) {
            this.shadowSpriteImage[i] = i < 10 ? (SpriteImage)Resources.get((String)("spriteimage." + this.shadowSpriteImagePrefix + "000" + i)) : (SpriteImage)Resources.get((String)("spriteimage." + this.shadowSpriteImagePrefix + "00" + i));
            ++i;
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.exhaustEmitterFeature = null;
        this.spriteImage = null;
        this.shadowSpriteImage = null;
    }

    public void register() {
        super.register();
        rocketFeature = this;
    }

    public void deregister() {
        super.deregister();
        rocketFeature = null;
    }

    public static RocketFeature getRocketFeature() throws Exception {
        if (!rocketFeature.isCreated()) {
            rocketFeature.create();
        }
        return rocketFeature;
    }

    private final class RocketInstance
    extends EntityFeature.EntityInstance
    implements Rocket {
        private Sprite sprite;
        private Sprite shadowSprite;
        private ThrusterEmitter exhaust;
        private int tick;
        private final Vector3i target = new Vector3i();
        private final Vector3i jet = new Vector3i();
        private int phase = 0;
        private Blob blob;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.features.RocketFeature$RocketInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        RocketInstance() {
        }

        public boolean canCollide() {
            return this.phase == 2;
        }

        protected void doRemove() {
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.shadowSprite.deallocate();
                this.sprite = null;
                this.shadowSprite = null;
                this.exhaust.remove();
            }
        }

        public void inCollisionWithGidrah(Gidrah gidrah) {
            this.remove();
        }

        public void spawn() {
        }

        protected void tick() {
            switch (this.phase) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!Game.getPlayer().isAlive() || !this.blob.isCaptured()) {
                        Game.getPlayer().addHomingRockets(1);
                        this.remove();
                        break;
                    }
                    ++this.tick;
                    this.tick += Game.getOptions().getSpeedShift();
                    if (this.tick <= RocketFeature.this.launchDelay) break;
                    this.tick = 0;
                    this.phase = 2;
                    this.sprite = Game.allocateSprite(this);
                    this.shadowSprite = Game.allocateSprite(this);
                    this.shadowSprite.setLayer(-2);
                    Game.getPlayer().getPosition(this.position);
                    Vector3i.sub((ReadableVector3i)this.target, (ReadableVector3i)this.position, (WritableVector3i)this.jet);
                    double angle = Math.atan2(this.jet.getY(), this.jet.getX());
                    int spriteAngle = (int)((double)RocketFeature.this.spriteImage.length * angle / (Math.PI * 2));
                    spriteAngle += 40;
                    this.sprite.setImage(RocketFeature.this.spriteImage[spriteAngle %= 32]);
                    this.shadowSprite.setImage(RocketFeature.this.shadowSpriteImage[spriteAngle]);
                    this.exhaust = (ThrusterEmitter)RocketFeature.this.exhaustEmitterFeature.spawn(this.position.getX(), this.position.getY(), 0, 0, 0, 0);
                    this.exhaust.setAngle(FPMath.fpYaklyDegrees((double)angle));
                    this.exhaust.setThrustOn(true);
                    if (this.jet.getX() != 0 || this.jet.getY() != 0) {
                        this.jet.normalize();
                        this.jet.scale(RocketFeature.this.thrust << Game.getOptions().getSpeedShift());
                    } else {
                        this.remove();
                    }
                    Game.shake(RocketFeature.this.shakeDuration, RocketFeature.this.shakeMagnitude);
                }
                case 2: {
                    this.tick += 1 + Game.getOptions().getSpeedShift();
                    if (this.tick > RocketFeature.this.range) {
                        this.remove();
                        break;
                    }
                    this.accelerate();
                    Vector3i.add((ReadableVector3i)this.position, (ReadableVector3i)this.velocity, (WritableVector3i)this.position);
                    this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
                    this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
                    this.exhaust.setPosition(this.position.getX(), this.position.getY(), 0);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        private void accelerate() {
            Vector3i.add((ReadableVector3i)this.velocity, (ReadableVector3i)this.jet, (WritableVector3i)this.velocity);
            int maxSpeed2 = RocketFeature.this.maxSpeed << Game.getOptions().getSpeedShift();
            if (this.velocity.lengthSquared() > (long)FPMath.mul((int)maxSpeed2, (int)maxSpeed2)) {
                this.velocity.normalize();
                this.velocity.scale(maxSpeed2);
            }
        }

        public void fireAt(Blob blob) {
            if (!$assertionsDisabled && this.phase != 0) {
                throw new AssertionError((Object)"Invalid state change.");
            }
            this.blob = blob;
            this.target.set(blob.getPosition().getX(), blob.getPosition().getY(), 0);
            this.phase = 1;
            RocketTargetingEffect.spawn(blob);
        }

        public void inCollisionWith(Entity dest) {
            dest.inCollisionWithRocket(this);
        }

        public float getRadarBlip(Color color, Vector3i pos) {
            return 0.0f;
        }
    }
}

