/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xap.Feature;
import xap.Game;
import xap.Moving;
import xap.Particle;
import xap.features.EmitterFeature;
import xap.features.GameModeFeature;

public abstract class ParticleFeature
extends Feature {
    public static final long serialVersionUID = 1L;
    private static int maxParticles;
    private static int totalParticles;
    private static final ArrayList registeredParticleFeatures;
    private int poolSize;
    private int duration;
    protected boolean important;
    private ArrayList particleChain;
    private ArrayList emitterChain;
    private int delay;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private transient ParticleInstance[] particle;
    private transient ParticleInstance[] particleCopy;
    private transient int numParticles;
    private transient boolean locked;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.ParticleFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        registeredParticleFeatures = new ArrayList();
        if (Game.isRunning()) {
            GameModeFeature.addGameEventListener(new Feature(){

                public void onEndGame() throws Exception {
                    super.onEndGame();
                    ParticleFeature.removeAllParticles();
                }

                public void onIntermission() throws Exception {
                    super.onIntermission();
                    ParticleFeature.removeAllParticles();
                }
            });
        }
    }

    public ParticleFeature() {
    }

    public ParticleFeature(String name) {
        super(name);
    }

    public void register() {
        super.register();
        registeredParticleFeatures.add(this);
        maxParticles += this.poolSize;
    }

    public void deregister() {
        super.deregister();
        registeredParticleFeatures.remove(this);
        maxParticles -= this.poolSize;
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.particle = new ParticleInstance[this.poolSize];
        int i = 0;
        while (i < this.poolSize) {
            this.particle[i] = this.createParticle();
            this.particle[i].index = i;
            ++i;
        }
        this.particleCopy = new ParticleInstance[this.poolSize];
        i = 0;
        while (i < this.particleChain.size()) {
            ParticleFeature p = (ParticleFeature)this.particleChain.get(i);
            p.register();
            p.create();
            ++i;
        }
        i = 0;
        while (i < this.emitterChain.size()) {
            EmitterFeature e = (EmitterFeature)this.emitterChain.get(i);
            e.register();
            e.create();
            ++i;
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.particle = null;
        this.particleCopy = null;
        int i = 0;
        while (i < this.particleChain.size()) {
            ParticleFeature p = (ParticleFeature)this.particleChain.get(i);
            p.destroy();
            p.deregister();
            ++i;
        }
        i = 0;
        while (i < this.emitterChain.size()) {
            EmitterFeature e = (EmitterFeature)this.emitterChain.get(i);
            e.destroy();
            e.deregister();
            ++i;
        }
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.poolSize = XMLUtil.getInt((Element)element, (String)"poolsize");
        this.duration = XMLUtil.getInt((Element)element, (String)"duration");
        this.delay = XMLUtil.getInt((Element)element, (String)"delay", (int)0);
        this.important = XMLUtil.getBoolean((Element)element, (String)"important", (boolean)false);
        this.offsetX = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"offsetx", (float)0.0f));
        this.offsetY = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"offsety", (float)0.0f));
        this.offsetZ = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"offsetz", (float)0.0f));
        this.particleChain = new ArrayList();
        this.emitterChain = new ArrayList();
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i) instanceof Element) {
                Element childNode = (Element)childNodes.item(i);
                Resource r = loader.load(childNode);
                if (r instanceof ParticleFeature) {
                    this.particleChain.add(r);
                } else if (r instanceof EmitterFeature) {
                    this.emitterChain.add(r);
                } else {
                    throw new Exception("Only particles or emitters are allowed as children");
                }
            }
            ++i;
        }
    }

    private static void removeAllParticles() throws Exception {
        int n = registeredParticleFeatures.size();
        int i = 0;
        while (i < n) {
            ((ParticleFeature)registeredParticleFeatures.get(i)).reset();
            ++i;
        }
    }

    protected int getDuration() {
        return this.duration;
    }

    public static void tickAllParticles() {
        int n = registeredParticleFeatures.size();
        int i = 0;
        while (i < n) {
            ((ParticleFeature)registeredParticleFeatures.get(i)).tick();
            ++i;
        }
    }

    public static void reduceTotalParticleCount() {
        maxParticles = (int)((float)maxParticles * 0.9f);
        int n = registeredParticleFeatures.size();
        int i = 0;
        while (i < n) {
            ((ParticleFeature)registeredParticleFeatures.get(i)).reduceParticleCount();
            ++i;
        }
    }

    public static int getTotalParticleCount() {
        return totalParticles;
    }

    protected void reduceParticleCount() {
        if (!this.important) {
            this.poolSize = (int)((float)this.poolSize * 0.85f);
        }
    }

    private void tick() {
        if (!this.isCreated()) {
            return;
        }
        System.arraycopy(this.particle, 0, this.particleCopy, 0, this.numParticles);
        int n = this.numParticles;
        this.locked = true;
        int i = 0;
        while (i < n) {
            this.particleCopy[i].tick();
            ++i;
        }
        this.locked = false;
    }

    private ParticleInstance allocateChild(ParticleInstance parent) {
        if (!$assertionsDisabled && this.locked) {
            throw new AssertionError();
        }
        if (totalParticles >= maxParticles) {
            return null;
        }
        if (this.numParticles >= this.poolSize) {
            return null;
        }
        ParticleInstance ret = this.particle[this.numParticles++];
        ++totalParticles;
        ret.parent = parent;
        ret.spawn();
        return ret;
    }

    public final Particle allocate(int x, int y, int z, int vx, int vy, int vz) {
        if (!$assertionsDisabled && this.locked) {
            throw new AssertionError();
        }
        if (totalParticles >= maxParticles) {
            return null;
        }
        if (this.numParticles >= this.poolSize) {
            return null;
        }
        ParticleInstance ret = this.particle[this.numParticles++];
        ++totalParticles;
        ret.setPosition(x + this.offsetX, y + this.offsetY, Math.abs(z) + this.offsetZ);
        ret.setVelocity(vx, vy, vz);
        ret.spawn();
        return ret;
    }

    private void returnParticleToPool(ParticleInstance p) {
        this.particle[((ParticleInstance)p).index] = this.particle[this.numParticles - 1];
        this.particle[p.index].index = p.index;
        this.particle[this.numParticles - 1] = p;
        p.index = --this.numParticles;
        --totalParticles;
    }

    protected abstract ParticleInstance createParticle();

    private void reset() {
        int i = this.numParticles;
        while (--i >= 0) {
            this.particle[i].deallocate();
        }
    }

    protected int getDelay() {
        return this.delay;
    }

    protected final int getNumParticles() {
        return this.numParticles;
    }

    protected final ParticleInstance[] getParticles() {
        return this.particle;
    }

    protected abstract class ParticleInstance
    implements Particle {
        protected final Vector3i position = new Vector3i();
        protected final Vector3i velocity = new Vector3i();
        private int index;
        private int tick;
        private int lifespan;
        private ParticleInstance parent;
        private boolean spawned;

        protected ParticleInstance() {
        }

        private final void spawn() {
            Moving moving;
            this.tick = -ParticleFeature.this.delay - Game.getOptions().getTicksPerFrame();
            this.lifespan = this.getDuration();
            this.spawned = false;
            int n = ParticleFeature.this.particleChain.size();
            int i = 0;
            while (i < n) {
                ParticleFeature p = (ParticleFeature)ParticleFeature.this.particleChain.get(i);
                moving = p.allocateChild(this);
                ++i;
            }
            n = ParticleFeature.this.emitterChain.size();
            i = 0;
            while (i < n) {
                EmitterFeature e = (EmitterFeature)ParticleFeature.this.emitterChain.get(i);
                moving = e.spawnChild(this);
                ++i;
            }
        }

        protected abstract void doSpawn();

        protected final int getTick() {
            return this.tick;
        }

        protected int getDuration() {
            return ParticleFeature.this.getDuration();
        }

        private final void tick() {
            this.tick += Game.getOptions().getTicksPerFrame();
            if (this.spawned && (this.tick >= this.lifespan || !this.isActive())) {
                this.deallocate();
            } else {
                if (this.tick < 0) {
                    return;
                }
                if (this.tick >= 0 && !this.spawned) {
                    if (this.parent != null) {
                        this.position.set((ReadableVector3i)this.parent.position);
                        this.velocity.set((ReadableVector3i)this.parent.velocity);
                    }
                    this.parent = null;
                    this.spawned = true;
                    this.doSpawn();
                }
                this.doTick();
            }
        }

        protected abstract boolean isActive();

        protected abstract void doTick();

        protected final void deallocate() {
            if (this.index == -1) {
                return;
            }
            this.parent = null;
            this.doDeallocate();
            ParticleFeature.this.returnParticleToPool(this);
        }

        protected abstract void doDeallocate();

        public final Vector3i getPosition() {
            return this.position;
        }

        public final Vector3i getPosition(Vector3i dest) {
            if (dest == null) {
                dest = new Vector3i((ReadableVector3i)this.position);
            } else {
                dest.set((ReadableVector3i)this.position);
            }
            return dest;
        }

        public final void setPosition(int x, int y, int z) {
            this.position.set(x, y, z);
        }

        public final Vector3i getVelocity() {
            return this.velocity;
        }

        public final Vector3i getVelocity(Vector3i dest) {
            if (dest == null) {
                dest = new Vector3i((ReadableVector3i)this.velocity);
            } else {
                dest.set((ReadableVector3i)this.velocity);
            }
            return dest;
        }

        public final void setVelocity(int x, int y, int z) {
            this.velocity.set(x, y, z);
        }
    }
}

