/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.sprites.Sprite;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import xap.Feature;
import xap.Game;
import xap.GameEventListener;
import xap.GamePanel;
import xap.MainDialog;
import xap.features.GameModeFeature;
import xap.features.GamePanelFeature;
import xap.gui.Component;
import xap.gui.Dialog;
import xap.gui.Label;
import xap.menu.MainMenu;

public class MainDialogFeature
extends Feature {
    public static final long serialVersionUID = 1L;
    private static MainDialogFeature feature;
    private transient MainDialogInstance instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.MainDialogFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public MainDialogFeature() {
    }

    public MainDialogFeature(String name) {
        super(name);
    }

    public void register() {
        super.register();
        if (!$assertionsDisabled && feature != null) {
            throw new AssertionError();
        }
        feature = this;
        GameModeFeature.addGameEventListener(this);
    }

    public void deregister() {
        super.deregister();
        feature = null;
        GameModeFeature.removeGameEventListener(this);
    }

    public static MainDialog spawn() throws Exception {
        return feature.doSpawn();
    }

    private MainDialogInstance doSpawn() throws Exception {
        this.instance = new MainDialogInstance();
        return this.instance;
    }

    public void onEndGame() throws Exception {
        super.onEndGame();
        this.instance.onEndGame();
    }

    public void onEndLevel() throws Exception {
        super.onEndLevel();
        this.instance.onEndLevel();
    }

    public void onGameOver() throws Exception {
        super.onGameOver();
        this.instance.onGameOver();
    }

    public void onNewGame() throws Exception {
        super.onNewGame();
        this.instance.onNewGame();
    }

    public void onPlayerDeath() throws Exception {
        super.onPlayerDeath();
        this.instance.onPlayerDeath();
    }

    public void onPlayerSpawn() throws Exception {
        super.onPlayerSpawn();
        this.instance.onPlayerSpawn();
    }

    public void onNewLevel() throws Exception {
        super.onNewLevel();
        this.instance.onNewLevel();
    }

    public void onIntermission() throws Exception {
        super.onIntermission();
        this.instance.onIntermission();
    }

    public void onLastBlobDeath() throws Exception {
        super.onLastBlobDeath();
        this.instance.onLastBlobDeath();
    }

    private class MainDialogInstance
    extends Dialog
    implements MainDialog,
    GameEventListener {
        boolean debugVisible;
        Label bgstFps;
        MainMenu mainMenu;
        GamePanel gamePanel;

        MainDialogInstance() throws Exception {
            super("Background");
            this.bgstFps = new Label();
            this.mainMenu = new MainMenu();
            this.setSize(800, 600).setLocation(0, 0);
            this.setBackgroundColor(null);
            this.gamePanel = GamePanelFeature.spawn();
            this.open();
            this.addChild(this.gamePanel.getComponent());
            this.addChild(this.bgstFps);
        }

        public void openMainMenu() {
            this.mainMenu.open();
        }

        public Component getComponent() {
            return this;
        }

        protected boolean doTick() {
            boolean ret = super.doTick();
            if (Game.showFPS) {
                this.bgstFps.setText(String.valueOf(String.valueOf(Game.fps)) + " FPS / frame time:" + Game.fmt.format(Game.frameTime * 1000.0f) + "ms");
                this.bgstFps.pack();
                this.debugVisible = true;
            } else if (this.debugVisible) {
                this.bgstFps.setText("");
                this.debugVisible = false;
            }
            return ret;
        }

        public Sprite allocateSprite(Object owner) {
            return this.gamePanel.allocateSprite(owner);
        }

        public void shake(int duration, int magnitude) {
            this.gamePanel.shake(duration, magnitude);
        }

        public void updateRegistrationDetails(RegistrationDetails details) {
            this.mainMenu.updateRegistrationDetails(details);
        }

        public void onEndGame() throws Exception {
            this.mainMenu.setVisible(true);
        }

        public void onEndLevel() throws Exception {
        }

        public void onGameOver() throws Exception {
        }

        public void onPlayerDeath() throws Exception {
        }

        public void onPlayerSpawn() throws Exception {
        }

        public void onIntermission() throws Exception {
        }

        public void onNewGame() throws Exception {
            this.mainMenu.setVisible(false);
        }

        public void onNewLevel() throws Exception {
        }

        public void onLastBlobDeath() throws Exception {
        }
    }
}

