/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.CosineInterpolator;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Point;
import xap.BattleZone;
import xap.Bindings;
import xap.Blob;
import xap.ControlPanel;
import xap.Entity;
import xap.Feature;
import xap.FluxMouse;
import xap.Game;
import xap.GameEventListener;
import xap.GamePanel;
import xap.Gidrah;
import xap.Powerup;
import xap.SpecialEffect;
import xap.Ticker;
import xap.features.BattleZoneFeature;
import xap.features.ControlPanelFeature;
import xap.features.EntityFeature;
import xap.features.GameModeFeature;
import xap.features.SpecialEffectFeature;
import xap.gui.Component;
import xap.gui.Interface;
import xap.gui.MouseAdapter;
import xap.gui.MousePointer;
import xap.gui.Panel;

public class GamePanelFeature
extends Feature {
    public static final long serialVersionUID = 1L;
    private static GamePanelFeature feature;
    private static final Point tempPoint;
    private static int tix;
    private static final int STOPPED = 0;
    private static final int PLAYING = 1;
    private static final int LEVEL_ENDED = 2;
    private static final int INTERMISSION = 3;
    private static final int GAME_OVER = 4;
    private transient GamePanelInstance instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.GamePanelFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        tempPoint = new Point();
    }

    public GamePanelFeature() {
    }

    public GamePanelFeature(String name) {
        super(name);
    }

    public void register() {
        super.register();
        if (!$assertionsDisabled && feature != null) {
            throw new AssertionError();
        }
        feature = this;
        GameModeFeature.addGameEventListener(this);
    }

    public void deregister() {
        super.deregister();
        feature = null;
        GameModeFeature.removeGameEventListener(this);
    }

    public static GamePanel spawn() throws Exception {
        return feature.doSpawn();
    }

    private GamePanelInstance doSpawn() throws Exception {
        this.instance = new GamePanelInstance();
        return this.instance;
    }

    public void onEndGame() throws Exception {
        super.onEndGame();
        this.instance.onEndGame();
    }

    public void onEndLevel() throws Exception {
        super.onEndLevel();
        this.instance.onEndLevel();
    }

    public void onPlayerDeath() throws Exception {
        super.onPlayerDeath();
        this.instance.onPlayerDeath();
    }

    public void onPlayerSpawn() throws Exception {
        super.onPlayerSpawn();
        this.instance.onPlayerSpawn();
    }

    public void onGameOver() throws Exception {
        super.onGameOver();
        this.instance.onGameOver();
    }

    public void onNewGame() throws Exception {
        super.onNewGame();
        this.instance.onNewGame();
    }

    public void onNewLevel() throws Exception {
        super.onNewLevel();
        this.instance.onNewLevel();
    }

    public void onIntermission() throws Exception {
        super.onIntermission();
        this.instance.onIntermission();
    }

    public void onLastBlobDeath() throws Exception {
        super.onLastBlobDeath();
        this.instance.onLastBlobDeath();
    }

    public static GamePanel getInstance() {
        return GamePanelFeature.feature.instance;
    }

    public static int getTix() {
        int oldTix = tix;
        tix = 0;
        return oldTix;
    }

    private class GamePanelInstance
    extends Panel
    implements GamePanel,
    GameEventListener {
        private int state;
        private ControlPanel controlPanel;
        private BattleZone battleZone;
        private final Vector3i target = new Vector3i();
        private final Vector3i eye = new Vector3i();
        private final Vector3i eyeDest = new Vector3i();
        private final Vector3i eyeSource = new Vector3i();
        private int eyeTick;
        private int zoomDuration;
        private final ArrayList targeted = new ArrayList(32);
        private int shakeDuration;
        private int shakeMagnitude;
        private int shakeTick;
        private float shakeX;
        private float shakeY;
        private SpecialEffect gameOverEffect;
        private MousePointer crosshairDefault;
        private MousePointer crosshairTarget;
        private MousePointer crosshairFriendly;
        private final EventHandler eventHandler = new EventHandler();
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.features.GamePanelFeature$GamePanelInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public GamePanelInstance() throws Exception {
            this.controlPanel = ControlPanelFeature.spawn();
            this.battleZone = BattleZoneFeature.spawn();
            this.createGUI();
            this.initEvents();
            this.crosshairDefault = new MousePointer((SpriteImage)Resources.get((String)"spriteimage.crosshair_default"));
            this.crosshairDefault.create();
            this.crosshairTarget = new MousePointer((SpriteImage)Resources.get((String)"spriteimage.crosshair_target"));
            this.crosshairTarget.create();
            this.crosshairFriendly = new MousePointer((SpriteImage)Resources.get((String)"spriteimage.crosshair_friendly"));
            this.crosshairFriendly.create();
        }

        private void createGUI() throws Exception {
            this.setVisible(false);
            this.setSize(800, 600);
            Component controlPanelComponent = this.controlPanel.getComponent();
            this.addChild(controlPanelComponent);
            controlPanelComponent.setY(600 - (controlPanelComponent.getHeight() + 5));
            controlPanelComponent.setDelegate(this);
            this.layout();
        }

        private void initEvents() {
            this.addMouseListener(this.eventHandler);
        }

        public Component getComponent() {
            return this;
        }

        protected boolean doTick() {
            try {
                switch (this.state) {
                    case 0: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)"Shouldn't tick if game is stopped.");
                        }
                        return false;
                    }
                    case 1: {
                        tix = tix + Game.getOptions().getTicksPerFrame();
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        this.doAnimationTick();
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("Illegal state: " + this.state));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        public ReadableVector3i getEyeLocation() {
            return this.eye;
        }

        private void doAnimationTick() throws Exception {
            if (Game.isPaused()) {
                return;
            }
            if (this.state == 1) {
                this.getScreenLocation(tempPoint);
                tempPoint.translate(FluxMouse.getX(), FluxMouse.getY());
                this.target.set(FPMath.fpValue((int)(tempPoint.getX() - 400)) + this.eye.getX(), FPMath.fpValue((int)(tempPoint.getY() - 300)) + this.eye.getY(), 0);
                EntityFeature.calculateProximity(this.target.getX(), this.target.getY(), FPMath.FOUR, this.targeted);
                int n = this.targeted.size();
                this.setMousePointer(this.crosshairDefault);
                int i = 0;
                while (i < n) {
                    Entity ent = (Entity)this.targeted.get(i);
                    if (ent instanceof Gidrah) {
                        this.setMousePointer(this.crosshairTarget);
                        break;
                    }
                    if (ent instanceof Blob) {
                        this.setMousePointer(this.crosshairFriendly);
                        ((Blob)ent).displayName();
                        break;
                    }
                    if (ent instanceof Powerup) {
                        this.setMousePointer(this.crosshairFriendly);
                        ((Powerup)ent).displayName();
                    }
                    ++i;
                }
                if (Game.getPlayer().isSpawning()) {
                    FluxMouse.setPosition(400, 300);
                    if (this.eyeTick > this.zoomDuration) {
                        this.eye.set((ReadableVector3i)this.target);
                        Game.getPlayer().setBeamInTarget(this.target.getX(), this.target.getY());
                    } else {
                        this.eyeTick += Game.getOptions().getTicksPerFrame();
                        int ratio = FPMath.fpValue((float)((float)this.eyeTick / (float)this.zoomDuration));
                        this.eye.set(CosineInterpolator.instance.interpolate(this.eyeSource.getX(), this.eyeDest.getX(), ratio), CosineInterpolator.instance.interpolate(this.eyeSource.getY(), this.eyeDest.getY(), ratio), 0);
                    }
                } else if (Game.getPlayer().isAlive()) {
                    Game.getPlayer().setTarget(this.target.getX(), this.target.getY());
                    boolean thrust = false;
                    if (Bindings.isThrustDown()) {
                        Game.getPlayer().accelerate(this.target.getX(), this.target.getY());
                        thrust = true;
                    } else {
                        int tx = Game.getPlayer().getPosition().getX();
                        int ty = Game.getPlayer().getPosition().getY();
                        if (Bindings.isThrustUpDown()) {
                            ty += FPMath.ONE;
                            thrust = true;
                        } else if (Bindings.isThrustDownDown()) {
                            ty -= FPMath.ONE;
                            thrust = true;
                        }
                        if (Bindings.isThrustLeftDown()) {
                            tx -= FPMath.ONE;
                            thrust = true;
                        } else if (Bindings.isThrustRightDown()) {
                            tx += FPMath.ONE;
                            thrust = true;
                        }
                        if (thrust) {
                            Game.getPlayer().accelerate(tx, ty);
                        }
                    }
                    if (!thrust) {
                        Game.getPlayer().decelerate();
                    }
                    if (Bindings.isShootDown() && !Interface.isConsoleVisible()) {
                        Game.getPlayer().fireLaser(this.target);
                    }
                    if (Bindings.getFixedEye()) {
                        this.eye.set(Game.getPlayer().getPosition().getX(), Game.getPlayer().getPosition().getY(), 0);
                    } else {
                        this.eye.set(Game.getPlayer().getPosition().getX() + this.target.getX() >> 1, Game.getPlayer().getPosition().getY() + this.target.getY() >> 1, 0);
                    }
                } else if (Game.getPlayer().isDying()) {
                    Game.getPlayer().decelerate();
                    if (Bindings.getFixedEye()) {
                        this.eye.set(Game.getPlayer().getPosition().getX(), Game.getPlayer().getPosition().getY(), 0);
                    } else {
                        this.eye.set(Game.getPlayer().getPosition().getX() + this.target.getX() >> 1, Game.getPlayer().getPosition().getY() + this.target.getY() >> 1, 0);
                    }
                }
            } else if (this.state == 4 && this.gameOverEffect.getPosition().getY() > FPMath.fpValue((int)664)) {
                Game.endGame();
                return;
            }
            Ticker.tick();
            if (this.shakeDuration != 0) {
                this.shakeTick += Game.getOptions().getTicksPerFrame();
                if (this.shakeTick > this.shakeDuration) {
                    this.shakeDuration = 0;
                }
            }
        }

        public Sprite allocateSprite(Object owner) {
            return this.battleZone.allocateSprite(owner);
        }

        protected void renderBackground() {
            if (!$assertionsDisabled && this.state == 0) {
                throw new AssertionError();
            }
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            float div = 0.015625f;
            GL11.glFrustum((double)(-800.0f * div), (double)(800.0f * div), (double)(-600.0f * div), (double)(600.0f * div), (double)8.0, (double)65536.0);
            GL11.glMatrixMode((int)5888);
            try {
                GL11.glPushMatrix();
                float x = FPMath.floatValue((int)(-this.eye.getX()));
                float y = FPMath.floatValue((int)(-this.eye.getY()));
                if (this.shakeDuration > 0) {
                    if ((this.shakeTick & 1) == 0) {
                        float magnitude = CosineInterpolator.instance.interpolate((float)this.shakeMagnitude, 0.0f, (float)this.shakeTick / (float)this.shakeDuration);
                        this.shakeX = (float)((double)magnitude * (Math.random() - 0.5));
                        this.shakeY = (float)((double)magnitude * (Math.random() - 0.5));
                        x += this.shakeX;
                        y += this.shakeY;
                    } else {
                        x -= this.shakeX;
                        y -= this.shakeY;
                    }
                }
                GL11.glTranslatef((float)x, (float)y, (float)-256.0f);
                this.battleZone.render();
            }
            finally {
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5889);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
            }
            SpecialEffectFeature.renderForegroundEffects();
        }

        public void shake(int duration, int magnitude) {
            if (this.shakeDuration > 0) {
                this.shakeDuration += duration;
                if (magnitude > this.shakeMagnitude) {
                    this.shakeMagnitude = magnitude;
                }
            } else {
                this.shakeTick = 0;
                this.shakeDuration = duration;
                this.shakeMagnitude = magnitude;
            }
        }

        private void stopShake() {
            this.shakeDuration = 0;
            this.shakeMagnitude = 0;
            this.shakeTick = 0;
        }

        public void onEndGame() throws Exception {
            if (!$assertionsDisabled && this.state == 0) {
                throw new AssertionError();
            }
            if (this.gameOverEffect != null) {
                this.gameOverEffect.remove();
                this.gameOverEffect = null;
            }
            this.setVisible(false);
            this.stopShake();
            FluxMouse.setTrackingEnabled(true);
            this.state = 0;
        }

        public void onEndLevel() throws Exception {
            if (this.state == 1) {
                this.state = 2;
            }
        }

        public void onGameOver() throws Exception {
            if (!$assertionsDisabled && this.state == 0) {
                throw new AssertionError();
            }
            this.state = 4;
            try {
                this.gameOverEffect = ((SpecialEffectFeature)Resources.get((String)"gameover.effect")).spawn(FPMath.fpValue((int)800) >> 1, 0, 0, 0, FPMath.ONE, 0, true);
            }
            catch (Exception e) {
                Game.handleException(e);
            }
        }

        public void onNewGame() throws Exception {
            if (!$assertionsDisabled && this.state != 0) {
                throw new AssertionError();
            }
            this.setVisible(true);
            this.eyeDest.set(BattleZone.FPWIDTH >> 1, BattleZone.FPHEIGHT >> 1, 0);
            this.eye.set((ReadableVector3i)this.eyeDest);
            this.state = 1;
        }

        public void onNewLevel() throws Exception {
            if (!$assertionsDisabled && this.state != 3 && this.state != 1) {
                throw new AssertionError();
            }
            this.state = 1;
        }

        public void onPlayerDeath() throws Exception {
        }

        public void onPlayerSpawn() throws Exception {
            if (!$assertionsDisabled && this.state != 1) {
                throw new AssertionError();
            }
        }

        public void onIntermission() throws Exception {
            if (!$assertionsDisabled && this.state != 2) {
                throw new AssertionError();
            }
            this.state = 3;
        }

        public void onLastBlobDeath() throws Exception {
        }

        private class EventHandler
        extends MouseAdapter {
            EventHandler() {
            }

            public boolean leftButtonClicked(Component src, int x, int y, int clickCount) {
                if (GamePanelInstance.this.state == 4) {
                    Game.endGame();
                }
                return false;
            }
        }
    }
}

