/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.Blob;
import xap.Bullet;
import xap.Entity;
import xap.Feature;
import xap.Game;
import xap.Gidrah;
import xap.Laser;
import xap.Nuke;
import xap.Orb;
import xap.Player;
import xap.Powerup;
import xap.Radar;
import xap.Rocket;
import xap.SmartBomb;
import xap.features.GameModeFeature;

public abstract class EntityFeature
extends Feature {
    public static final long serialVersionUID = 1L;
    public static final int MAX_ENTITIES = 1024;
    public static final int MAX_ENTITY_SPRITES = 20000;
    private static final HashMap entityMap = new HashMap();
    private static final ArrayList entityList = new ArrayList();
    private static final ArrayList entities = new ArrayList(1024);
    private static final Vector3i tempVector = new Vector3i();
    private static final Color radarColor = new Color();
    private static final Vector3i radarPos = new Vector3i();
    private int radius;
    private int radiusSquared;
    private transient int counter = 0;

    static {
        if (Game.isRunning()) {
            GameModeFeature.addGameEventListener(new Feature(){

                public void onEndGame() throws Exception {
                    super.onEndGame();
                    EntityFeature.removeAllEntities();
                }

                public void onIntermission() throws Exception {
                    super.onIntermission();
                    EntityFeature.removeAllEntities();
                }
            });
        }
    }

    public EntityFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.radius = XMLUtil.getInt((Element)element, (String)"radius", (int)-1);
        if (this.radius == -1) {
            throw new Exception("Entity " + this.getName() + " has no radius specified.");
        }
        this.radius = FPMath.fpValue((int)this.radius);
    }

    public void register() {
        super.register();
        entityMap.put(this.name, this);
        entityList.add(this);
    }

    public void deregister() {
        super.deregister();
        entityMap.remove(this.name);
        entityList.remove(this);
    }

    public static Entity getEntity(String name) {
        return (Entity)entityMap.get(name);
    }

    public final Entity spawn() {
        EntityInstance ret = this.doSpawn();
        if (ret != null) {
            ret.index = EntityFeature.entities.size();
            entities.add(ret);
            ret.spawn();
        }
        return ret;
    }

    public static void tickAllEntities() {
        int i = 0;
        while (i < entities.size()) {
            EntityInstance entity = (EntityInstance)entities.get(i);
            entity.tick();
            if (entity.index == -1) continue;
            ++i;
        }
        i = 0;
        while (i < entities.size()) {
            EntityInstance src = (EntityInstance)entities.get(i);
            int j = 1;
            while (j < entities.size()) {
                EntityInstance dest = (EntityInstance)entities.get(j);
                if (src.canCollide() && dest.canCollide() && src.isTouching(dest)) {
                    src.inCollisionWith(dest);
                    dest.inCollisionWith(src);
                }
                if (dest.index == -1) continue;
                ++j;
            }
            if (src.index == -1) continue;
            ++i;
        }
    }

    public static void getAllEntities(ArrayList dest) {
        dest.clear();
        dest.addAll(entities);
    }

    public static void calculateProximity(int x, int y, int r, ArrayList dest) {
        dest.clear();
        int n = entities.size();
        int i = 0;
        while (i < n) {
            EntityInstance ent = (EntityInstance)entities.get(i);
            if (ent.canCollide()) {
                tempVector.set((ReadableVector3i)ent.position);
                tempVector.translate(-x, -y, 0);
                int dist = tempVector.length() - r - ent.getRadius();
                if (dist <= 0) {
                    dest.add(ent);
                }
            }
            ++i;
        }
    }

    public static void calculateProximityAll(int x, int y, int r, ArrayList dest) {
        dest.clear();
        int n = entities.size();
        int i = 0;
        while (i < n) {
            EntityInstance ent = (EntityInstance)entities.get(i);
            tempVector.set((ReadableVector3i)ent.position);
            tempVector.translate(-x, -y, 0);
            int dist = tempVector.length() - r - ent.getRadius();
            if (dist <= 0) {
                dest.add(ent);
            }
            ++i;
        }
    }

    public static void renderEntities() {
        int n = entities.size();
        int i = 0;
        while (i < n) {
            ((EntityInstance)entities.get(i)).render();
            ++i;
        }
    }

    private static void removeAllEntities() {
        int n;
        int i = n = entities.size();
        while (--i >= 0) {
            ((EntityInstance)entities.get(i)).remove();
        }
    }

    protected abstract EntityInstance doSpawn();

    public static void updateRadar(Radar radar) {
        int n = entities.size();
        int i = 0;
        while (i < n) {
            float size = ((EntityInstance)entities.get(i)).getRadarBlip(radarColor, radarPos);
            radar.addBlip(size, radarColor, radarPos);
            ++i;
        }
    }

    protected abstract class EntityInstance
    implements Entity {
        public final Vector3i position = new Vector3i();
        public final Vector3i velocity = new Vector3i();
        private final int id;
        private int index;

        protected EntityInstance() {
            EntityFeature entityFeature2 = EntityFeature.this;
            int n = entityFeature2.counter;
            entityFeature2.counter = n + 1;
            this.id = n;
        }

        public abstract void spawn();

        public final void remove() {
            if (this.index == -1) {
                return;
            }
            int n = entities.size() - 1;
            if (this.index != n) {
                EntityInstance replacement = (EntityInstance)entities.get(n);
                entities.set(this.index, replacement);
                replacement.index = this.index;
            }
            this.index = -1;
            entities.remove(n);
            this.doRemove();
        }

        protected abstract void doRemove();

        public boolean isTouching(Entity dest) {
            if (this.getRadius() == 0 || dest.getRadius() == 0) {
                return false;
            }
            Vector3i.sub((ReadableVector3i)dest.getPosition(), (ReadableVector3i)this.position, (WritableVector3i)tempVector);
            return tempVector.length() < this.getRadius() + dest.getRadius();
        }

        public int getRadius() {
            return EntityFeature.this.radius;
        }

        public int getRadiusSquared() {
            return EntityFeature.this.radiusSquared;
        }

        protected final void setRadius(int newRadius) {
            EntityFeature.this.radius = newRadius;
            EntityFeature.this.radiusSquared = FPMath.mul((int)EntityFeature.this.radius, (int)EntityFeature.this.radius);
        }

        protected abstract void tick();

        public void render() {
        }

        public final Vector3i getPosition(Vector3i dest) {
            if (dest == null) {
                dest = new Vector3i((ReadableVector3i)this.position);
            } else {
                dest.set((ReadableVector3i)this.position);
            }
            return dest;
        }

        public final Vector3i getPosition() {
            return this.position;
        }

        public final void setPosition(int x, int y, int z) {
            this.position.set(x, y, z);
        }

        public abstract boolean canCollide();

        public void inCollisionWithBlob(Blob blob) {
        }

        public void inCollisionWithBullet(Bullet bullet) {
        }

        public void inCollisionWithLaser(Laser laser) {
        }

        public void inCollisionWithGidrah(Gidrah gidrah) {
        }

        public void inCollisionWithPlayer(Player player) {
        }

        public void inCollisionWithSmartBomb(SmartBomb smartBomb) {
        }

        public void inCollisionWithPowerup(Powerup powerup) {
        }

        public void inCollisionWithRocket(Rocket rocket) {
        }

        public void inCollisionWithOrb(Orb orb) {
        }

        public void inCollisionWithNuke(Nuke nuke) {
        }

        public String toString() {
            return String.valueOf(EntityFeature.this.getName()) + " " + this.id;
        }

        public final Vector3i getVelocity(Vector3i dest) {
            if (dest == null) {
                dest = new Vector3i((ReadableVector3i)this.velocity);
            } else {
                dest.set((ReadableVector3i)this.velocity);
            }
            return dest;
        }

        public final Vector3i getVelocity() {
            return this.velocity;
        }

        public final void setVelocity(int x, int y, int z) {
            this.velocity.set(x, y, z);
        }

        public final void randomLocation(Vector3i dest) {
            dest.set(FPMath.fpValue((int)(Util.random((int)0, (int)768) + 128)), FPMath.fpValue((int)(Util.random((int)0, (int)768) + 128)), 0);
        }

        public final void randomLocation(Vector3i target, float radius, Vector3i dest) {
            double a = Math.random() * 2.0 * Math.PI;
            float dx = (float)(Math.cos(a) * (double)radius);
            float dy = (float)(Math.sin(a) * (double)radius);
            dest.set(target.getX() + FPMath.fpValue((float)dx), target.getY() + FPMath.fpValue((float)dy), 0);
        }
    }
}

