/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLDisplayList;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLTexture;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.StaticSpriteEngine;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import xap.ControlPanel;
import xap.Feature;
import xap.Game;
import xap.features.GameModeFeature;
import xap.features.PlayerFeature;
import xap.gui.Component;
import xap.gui.Label;
import xap.gui.Panel;
import xap.gui.Picture;

public class ControlPanelFeature
extends Feature {
    public static final long serialVersionUID = 1L;
    private static ControlPanelFeature feature;
    private static final NumberFormat nf;
    private transient ControlPanelInstance instance;
    private static final int MAX_UNITS = 8;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.ControlPanelFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        nf = new DecimalFormat();
        nf.setGroupingUsed(true);
    }

    public ControlPanelFeature() {
    }

    public ControlPanelFeature(String name) {
        super(name);
    }

    public void deregister() {
        super.deregister();
        feature = null;
        GameModeFeature.removeGameEventListener(this);
    }

    public void register() {
        super.register();
        if (!$assertionsDisabled && feature != null) {
            throw new AssertionError();
        }
        feature = this;
        GameModeFeature.addGameEventListener(this);
    }

    public static ControlPanel spawn() throws Exception {
        return feature.doSpawn();
    }

    private ControlPanelInstance doSpawn() throws Exception {
        this.instance = new ControlPanelInstance();
        return this.instance;
    }

    private class ControlPanelInstance
    extends Panel
    implements ControlPanel {
        private int newScore;
        private int newLives;
        private int newSmartBombs;
        private int newShields;
        private int newMaxShields;
        private int newLevel;
        private MirroredYPanel shieldsPanel;
        private LabelPanel shieldsLabelPanel;
        private ShieldsDisplay shieldsDisplay;
        private MirroredYPanel livesPanel;
        private LabelPanel livesLabelPanel;
        private Counter livesCounter;
        private MirroredXYPanel smartsPanel;
        private LabelPanel smartsLabelPanel;
        private Counter smartsCounter;
        private MirroredXYPanel scorePanel;
        private Label scoreDisplay;
        private MirroredXYPanel levelPanel;
        private LabelPanel levelLabelPanel;
        private Label levelDisplay;
        private int oldScore;
        private int oldLives;
        private int oldSmartBombs;
        private int oldLevel;
        private int oldShields;
        private int oldMaxShields;
        private GLTexture gui_bits1 = (GLTexture)Resources.get((String)"gui_bits1.texture");
        private GLTexture gui_bits2 = (GLTexture)Resources.get((String)"gui_bits2.texture");
        private GLTexture gui_bits3 = (GLTexture)Resources.get((String)"gui_bits3.texture");

        public ControlPanelInstance() throws Exception {
            this.scoreDisplay = new Label();
            this.levelDisplay = new Label();
            this.shieldsPanel = new MirroredYPanel(this.gui_bits1, 82, 0, 256, 27);
            this.shieldsLabelPanel = new LabelPanel(this.gui_bits1, 98, 40, 142, 60);
            this.shieldsLabelPanel.setLocation(22, 19);
            this.shieldsPanel.addChild(this.shieldsLabelPanel);
            this.shieldsDisplay = new ShieldsDisplay(this.gui_bits1, 147, 40, 219, 64);
            this.shieldsDisplay.setLocation(73, 15);
            this.shieldsPanel.addChild(this.shieldsDisplay);
            this.shieldsPanel.setLocation(532, 12);
            this.livesPanel = new MirroredYPanel(this.gui_bits1, 256, 0, 82, 27);
            this.livesLabelPanel = new LabelPanel(this.gui_bits1, 2, 40, 46, 60);
            this.livesLabelPanel.setLocation(31, 19);
            this.livesPanel.addChild(this.livesLabelPanel);
            this.livesCounter = new Counter((Animation)Resources.get((String)"gui_lives.animation"), 12, 12, 8);
            this.livesCounter.setBounds(75, 16, 128, 24);
            this.livesPanel.addChild(this.livesCounter);
            this.livesPanel.setLocation(208, 12);
            this.smartsPanel = new MirroredXYPanel(this.gui_bits1, 0, 0, 81, 27);
            this.smartsLabelPanel = new LabelPanel(this.gui_bits1, 50, 40, 94, 60);
            this.smartsLabelPanel.setLocation(20, 19);
            this.smartsPanel.addChild(this.smartsLabelPanel);
            this.smartsCounter = new Counter((Animation)Resources.get((String)"gui_smarts.animation"), 12, 12, 8);
            this.smartsCounter.setBounds(65, 13, 128, 28);
            this.smartsPanel.addChild(this.smartsCounter);
            this.smartsPanel.setLocation(376, 12);
            this.scorePanel = new MirroredXYPanel(this.gui_bits2, 0, 0, 110, 35);
            this.scorePanel.addChild(this.scoreDisplay);
            this.scoreDisplay.setAlignment(2).setBounds(36, 16, 148, 36);
            this.scorePanel.setLocation(0, 5);
            this.levelPanel = new MirroredXYPanel(this.gui_bits3, 0, 0, 40, 47);
            this.levelLabelPanel = new LabelPanel(this.gui_bits1, 218, 42, 251, 59);
            this.levelLabelPanel.setLocation(23, 50);
            this.levelPanel.addChild(this.levelLabelPanel);
            this.levelDisplay.setAlignment(1).setBounds(24, 21, 30, 28);
            this.levelPanel.setLocation(698, -7);
            this.levelPanel.addChild(this.levelDisplay);
            this.scoreDisplay.setFont((GLFont)Resources.get((String)"impact-plain-32.glfont")).setForegroundColor(new Color(255, 255, 255, 224));
            this.levelDisplay.setFont((GLFont)Resources.get((String)"impact-plain-24.glfont")).setForegroundColor(new Color(255, 255, 255, 224));
            this.scoreDisplay.setText("0");
            this.levelDisplay.setText("1");
            this.addChild(this.scorePanel);
            this.addChild(this.livesPanel);
            this.addChild(this.smartsPanel);
            this.addChild(this.shieldsPanel);
            this.addChild(this.levelPanel);
            this.setSize(800, 80).setX(8);
        }

        public Component getComponent() {
            return this;
        }

        protected boolean doTick() {
            PlayerFeature.displayStats(this);
            if (this.newLives != this.oldLives) {
                this.livesCounter.setNumUnits(this.newLives - 1);
                this.oldLives = this.newLives;
            }
            if (this.newSmartBombs != this.oldSmartBombs) {
                this.smartsCounter.setNumUnits(this.newSmartBombs);
                this.oldSmartBombs = this.newSmartBombs;
            }
            if (this.newShields != this.oldShields || this.newMaxShields != this.oldMaxShields) {
                this.shieldsDisplay.setShields(this.newShields, this.newMaxShields);
                this.oldShields = this.newShields;
                this.oldMaxShields = this.newMaxShields;
            }
            Game.getGameMode().displayStats(this);
            if (this.newScore != this.oldScore) {
                this.scoreDisplay.setText(nf.format(this.newScore));
                this.oldScore = this.newScore;
            }
            if (this.newLevel != this.oldLevel) {
                this.levelDisplay.setText(String.valueOf(this.newLevel + 1));
                this.oldLevel = this.newLevel;
            }
            return super.doTick();
        }

        public void setLives(int lives) {
            this.newLives = lives;
        }

        public void setShields(int shields, int maxShields) {
            this.newShields = shields;
            this.newMaxShields = maxShields;
        }

        public void setSmartBombs(int smartBombs) {
            this.newSmartBombs = smartBombs;
        }

        public void setLevelNumber(int level) {
            this.newLevel = level;
        }

        public void setScore(int score) {
            this.newScore = score;
        }

        private class MirroredYPanel
        extends Panel {
            private GLDisplayList displayList;

            public MirroredYPanel(GLTexture texture, int tx0, int ty0, int tx1, int ty1) throws Exception {
                this.setSize(Math.abs(tx1 - tx0), (ty1 - ty0) * 2);
                this.displayList = new GLDisplayList(this, texture, tx0, ty0, tx1, ty1){
                    final /* synthetic */ MirroredYPanel this$2;
                    private final /* synthetic */ GLTexture val$texture;
                    private final /* synthetic */ int val$tx0;
                    private final /* synthetic */ int val$ty0;
                    private final /* synthetic */ int val$tx1;
                    private final /* synthetic */ int val$ty1;
                    {
                        this.this$2 = mirroredYPanel;
                        this.val$texture = gLTexture;
                        this.val$tx0 = n;
                        this.val$ty0 = n2;
                        this.val$tx1 = n3;
                        this.val$ty1 = n4;
                    }

                    protected void drawGraphics() {
                        GL11.glEnable((int)3553);
                        this.val$texture.render();
                        GL11.glBegin((int)7);
                        float txf0 = (float)this.val$tx0 / (float)this.val$texture.getWidth();
                        float tyf0 = (float)this.val$ty0 / (float)this.val$texture.getHeight();
                        float txf1 = (float)this.val$tx1 / (float)this.val$texture.getWidth();
                        float tyf1 = (float)this.val$ty1 / (float)this.val$texture.getHeight();
                        GL11.glTexCoord2f((float)txf0, (float)tyf1);
                        GL11.glVertex2i((int)0, (int)0);
                        GL11.glTexCoord2f((float)txf1, (float)tyf1);
                        GL11.glVertex2i((int)this.this$2.getWidth(), (int)0);
                        GL11.glTexCoord2f((float)txf1, (float)tyf0);
                        GL11.glVertex2i((int)this.this$2.getWidth(), (int)(this.this$2.getHeight() / 2));
                        GL11.glTexCoord2f((float)txf0, (float)tyf0);
                        GL11.glVertex2i((int)0, (int)(this.this$2.getHeight() / 2));
                        GL11.glTexCoord2f((float)txf0, (float)tyf0);
                        GL11.glVertex2i((int)0, (int)(this.this$2.getHeight() / 2));
                        GL11.glTexCoord2f((float)txf1, (float)tyf0);
                        GL11.glVertex2i((int)this.this$2.getWidth(), (int)(this.this$2.getHeight() / 2));
                        GL11.glTexCoord2f((float)txf1, (float)tyf1);
                        GL11.glVertex2i((int)this.this$2.getWidth(), (int)this.this$2.getHeight());
                        GL11.glTexCoord2f((float)txf0, (float)tyf1);
                        GL11.glVertex2i((int)0, (int)this.this$2.getHeight());
                        GL11.glEnd();
                        GL11.glDisable((int)3553);
                    }
                };
                this.displayList.create();
            }

            protected void renderSelf() {
                this.setGLColor(255, 255, 255, this.getDialog().isActive() ? 255 : 192);
                this.displayList.render();
            }
        }

        private class MirroredXYPanel
        extends Panel {
            private GLDisplayList displayList;

            public MirroredXYPanel(GLTexture texture, int tx0, int ty0, int tx1, int ty1) throws Exception {
                this.setSize((tx1 - tx0) * 2, (ty1 - ty0) * 2);
                this.displayList = new GLDisplayList(this, texture, tx0, ty0, tx1, ty1){
                    final /* synthetic */ MirroredXYPanel this$2;
                    private final /* synthetic */ GLTexture val$texture;
                    private final /* synthetic */ int val$tx0;
                    private final /* synthetic */ int val$ty0;
                    private final /* synthetic */ int val$tx1;
                    private final /* synthetic */ int val$ty1;
                    {
                        this.this$2 = mirroredXYPanel;
                        this.val$texture = gLTexture;
                        this.val$tx0 = n;
                        this.val$ty0 = n2;
                        this.val$tx1 = n3;
                        this.val$ty1 = n4;
                    }

                    protected void drawGraphics() {
                        GL11.glEnable((int)3553);
                        this.val$texture.render();
                        GL11.glBegin((int)7);
                        float txf0 = (float)this.val$tx0 / (float)this.val$texture.getWidth();
                        float tyf0 = (float)this.val$ty0 / (float)this.val$texture.getHeight();
                        float txf1 = (float)this.val$tx1 / (float)this.val$texture.getWidth();
                        float tyf1 = (float)this.val$ty1 / (float)this.val$texture.getHeight();
                        GL11.glTexCoord2f((float)txf1, (float)tyf1);
                        GL11.glVertex2i((int)0, (int)0);
                        GL11.glTexCoord2f((float)txf0, (float)tyf1);
                        GL11.glVertex2i((int)(this.this$2.getWidth() / 2), (int)0);
                        GL11.glTexCoord2f((float)txf0, (float)tyf0);
                        GL11.glVertex2i((int)(this.this$2.getWidth() / 2), (int)(this.this$2.getHeight() / 2));
                        GL11.glTexCoord2f((float)txf1, (float)tyf0);
                        GL11.glVertex2i((int)0, (int)(this.this$2.getHeight() / 2));
                        GL11.glTexCoord2f((float)txf0, (float)tyf1);
                        GL11.glVertex2i((int)(this.this$2.getWidth() / 2), (int)0);
                        GL11.glTexCoord2f((float)txf1, (float)tyf1);
                        GL11.glVertex2i((int)this.this$2.getWidth(), (int)0);
                        GL11.glTexCoord2f((float)txf1, (float)tyf0);
                        GL11.glVertex2i((int)this.this$2.getWidth(), (int)(this.this$2.getHeight() / 2));
                        GL11.glTexCoord2f((float)txf0, (float)tyf0);
                        GL11.glVertex2i((int)(this.this$2.getWidth() / 2), (int)(this.this$2.getHeight() / 2));
                        GL11.glTexCoord2f((float)txf0, (float)tyf0);
                        GL11.glVertex2i((int)(this.this$2.getWidth() / 2), (int)(this.this$2.getHeight() / 2));
                        GL11.glTexCoord2f((float)txf1, (float)tyf0);
                        GL11.glVertex2i((int)this.this$2.getWidth(), (int)(this.this$2.getHeight() / 2));
                        GL11.glTexCoord2f((float)txf1, (float)tyf1);
                        GL11.glVertex2i((int)this.this$2.getWidth(), (int)this.this$2.getHeight());
                        GL11.glTexCoord2f((float)txf0, (float)tyf1);
                        GL11.glVertex2i((int)(this.this$2.getWidth() / 2), (int)this.this$2.getHeight());
                        GL11.glTexCoord2f((float)txf1, (float)tyf0);
                        GL11.glVertex2i((int)0, (int)(this.this$2.getHeight() / 2));
                        GL11.glTexCoord2f((float)txf0, (float)tyf0);
                        GL11.glVertex2i((int)(this.this$2.getWidth() / 2), (int)(this.this$2.getHeight() / 2));
                        GL11.glTexCoord2f((float)txf0, (float)tyf1);
                        GL11.glVertex2i((int)(this.this$2.getWidth() / 2), (int)this.this$2.getHeight());
                        GL11.glTexCoord2f((float)txf1, (float)tyf1);
                        GL11.glVertex2i((int)0, (int)this.this$2.getHeight());
                        GL11.glEnd();
                        GL11.glDisable((int)3553);
                    }
                };
                this.displayList.create();
            }

            protected void renderSelf() {
                this.setGLColor(255, 255, 255, this.getDialog().isActive() ? 255 : 192);
                this.displayList.render();
            }
        }

        private class Counter
        extends Panel {
            private StaticSpriteEngine spriteEngine;
            private Picture label;
            private final Sprite[] sprite = new Sprite[8];
            private int numUnits;
            private Animation animation;

            public Counter(Animation animation, int originX, int originY, int offsetX) throws Exception {
                this.spriteEngine = new StaticSpriteEngine(false, 8, Game.getOptions().getTicksPerFrame());
                this.spriteEngine.create();
                int i = 0;
                while (i < 8) {
                    this.sprite[i] = this.spriteEngine.allocate((Object)this);
                    this.sprite[i].setAnimation(animation);
                    this.sprite[i].setVisible(false);
                    this.sprite[i].setSequence(i % 8);
                    this.sprite[i].setLocation(originX, originY, 0);
                    originX += offsetX;
                    ++i;
                }
            }

            public void setNumUnits(int newNumUnits) {
                if (this.numUnits != (newNumUnits = Math.max(0, Math.min(8, newNumUnits)))) {
                    this.numUnits = newNumUnits;
                    int i = 0;
                    while (i < this.numUnits) {
                        this.sprite[i].setVisible(true);
                        ++i;
                    }
                    i = this.numUnits;
                    while (i < 8) {
                        this.sprite[i].setVisible(false);
                        ++i;
                    }
                }
            }

            protected boolean doTick() {
                this.spriteEngine.tick();
                return true;
            }

            protected void renderSelf() {
                this.spriteEngine.render();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            }
        }

        private class LabelPanel
        extends Panel {
            private GLDisplayList displayList;

            public LabelPanel(GLTexture texture, int tx0, int ty0, int tx1, int ty1) throws Exception {
                this.setSize(tx1 - tx0, ty1 - ty0);
                this.displayList = new GLDisplayList(this, texture, tx0, ty0, tx1, ty1){
                    final /* synthetic */ LabelPanel this$2;
                    private final /* synthetic */ GLTexture val$texture;
                    private final /* synthetic */ int val$tx0;
                    private final /* synthetic */ int val$ty0;
                    private final /* synthetic */ int val$tx1;
                    private final /* synthetic */ int val$ty1;
                    {
                        this.this$2 = labelPanel;
                        this.val$texture = gLTexture;
                        this.val$tx0 = n;
                        this.val$ty0 = n2;
                        this.val$tx1 = n3;
                        this.val$ty1 = n4;
                    }

                    protected void drawGraphics() {
                        GL11.glEnable((int)3553);
                        this.val$texture.render();
                        GL11.glBegin((int)7);
                        float txf0 = (float)this.val$tx0 / (float)this.val$texture.getWidth();
                        float tyf0 = (float)this.val$ty0 / (float)this.val$texture.getHeight();
                        float txf1 = (float)this.val$tx1 / (float)this.val$texture.getWidth();
                        float tyf1 = (float)this.val$ty1 / (float)this.val$texture.getHeight();
                        GL11.glTexCoord2f((float)txf0, (float)tyf1);
                        GL11.glVertex2i((int)0, (int)0);
                        GL11.glTexCoord2f((float)txf1, (float)tyf1);
                        GL11.glVertex2i((int)this.this$2.getWidth(), (int)0);
                        GL11.glTexCoord2f((float)txf1, (float)tyf0);
                        GL11.glVertex2i((int)this.this$2.getWidth(), (int)this.this$2.getHeight());
                        GL11.glTexCoord2f((float)txf0, (float)tyf0);
                        GL11.glVertex2i((int)0, (int)this.this$2.getHeight());
                        GL11.glEnd();
                        GL11.glDisable((int)3553);
                    }
                };
                this.displayList.create();
            }

            protected void renderSelf() {
                this.displayList.render();
            }
        }

        private class ShieldsDisplay
        extends Panel {
            int shields;
            int tx0;
            int tx1;
            int ty0;
            int ty1;
            GLTexture texture;
            int size;

            public ShieldsDisplay(GLTexture texture, int tx0, int ty0, int tx1, int ty1) throws Exception {
                this.tx0 = tx0;
                this.ty0 = ty0;
                this.tx1 = tx1;
                this.ty1 = ty1;
                this.texture = texture;
                this.size = tx1 - tx0;
                this.setSize(this.size, ty1 - ty0);
            }

            protected void renderSelf() {
                GL11.glEnable((int)3553);
                this.texture.render();
                byte shade = this.getDialog().isActive() ? (byte)-32 : 32;
                GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
                GL11.glBegin((int)7);
                float txf0 = (float)this.tx0 / (float)this.texture.getWidth();
                float tyf0 = (float)this.ty0 / (float)this.texture.getHeight();
                float txf1 = (float)this.tx1 / (float)this.texture.getWidth();
                float tyf1 = (float)this.ty1 / (float)this.texture.getHeight();
                GL11.glColor4ub((byte)-1, (byte)0, (byte)0, (byte)shade);
                GL11.glTexCoord2f((float)txf0, (float)tyf1);
                GL11.glVertex2i((int)0, (int)0);
                GL11.glColor4ub((byte)-1, (byte)-1, (byte)-128, (byte)shade);
                GL11.glTexCoord2f((float)txf1, (float)tyf1);
                GL11.glVertex2i((int)this.size, (int)0);
                GL11.glColor4ub((byte)-1, (byte)-1, (byte)-128, (byte)shade);
                GL11.glTexCoord2f((float)txf1, (float)tyf0);
                GL11.glVertex2i((int)this.size, (int)this.getHeight());
                GL11.glColor4ub((byte)-1, (byte)0, (byte)0, (byte)shade);
                GL11.glTexCoord2f((float)txf0, (float)tyf0);
                GL11.glVertex2i((int)0, (int)this.getHeight());
                GL11.glEnd();
                GL11.glDisable((int)3553);
                this.setGLColor(255, 255, 255, 255);
            }

            public void setShields(int newShields, int maxShields) {
                this.shields = newShields = Math.max(0, Math.min(newShields, maxShields));
                this.setWidth(this.shields * this.size / maxShields);
            }
        }
    }
}

