/*
 * Decompiled with CFR 0.152.
 */
package xap.eolgs.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.BattleZone;
import xap.Compass;
import xap.Game;
import xap.Gidrah;
import xap.Nuke;
import xap.Player;
import xap.SmartBomb;
import xap.features.EntityFeature;
import xap.features.GidrahFeature;

public class EnormousTringleFeature
extends GidrahFeature {
    public static final long serialVersionUID = 1L;
    private int speed;
    private int duration;
    private int spawnInterval;
    private String wobbleAnimation;
    private String wobbleShadowAnimation;
    private String spawnGidrah;
    private int maxSpawned;
    private transient Animation wobbleAnimationResource;
    private transient Animation wobbleShadowAnimationResource;
    private transient GidrahFeature spawnGidrahFeature;
    private static final int THINKING = 0;
    private static final int WOBBLING = 1;

    public EnormousTringleFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.spawnInterval = XMLUtil.getInt((Element)element, (String)"spawninterval");
        this.spawnGidrah = XMLUtil.getString((Element)element, (String)"spawngidrah");
        this.wobbleAnimation = XMLUtil.getString((Element)element, (String)"wobbleanimation");
        this.wobbleShadowAnimation = XMLUtil.getString((Element)element, (String)"wobbleshadowanimation");
        this.speed = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"speed"));
        this.duration = XMLUtil.getInt((Element)element, (String)"duration");
        this.maxSpawned = XMLUtil.getInt((Element)element, (String)"maxspawned");
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new EnormousTringleInstance();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.wobbleAnimationResource = (Animation)Resources.get((String)this.wobbleAnimation);
        this.wobbleShadowAnimationResource = (Animation)Resources.get((String)this.wobbleShadowAnimation);
        this.spawnGidrahFeature = (GidrahFeature)Resources.get((String)this.spawnGidrah);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.wobbleAnimationResource = null;
        this.wobbleShadowAnimationResource = null;
        this.spawnGidrahFeature = null;
    }

    private final class EnormousTringleInstance
    extends GidrahFeature.GidrahInstance {
        private Sprite sprite;
        private Sprite shadowSprite;
        private int dx;
        private int dy;
        private int moveDuration;
        private int phase;
        private int spawnTick;
        private int numSpawned;
        private int damageIndicationTick;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.eolgs.full.EnormousTringleFeature$EnormousTringleInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        EnormousTringleInstance() {
            super(EnormousTringleFeature.this);
        }

        protected void initSprite() {
            this.sprite = Game.allocateSprite(this);
            this.shadowSprite = Game.allocateSprite(this);
            this.shadowSprite.setLayer(-2);
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.sprite.setAnimation(EnormousTringleFeature.this.wobbleAnimationResource);
            this.shadowSprite.setAnimation(EnormousTringleFeature.this.wobbleShadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doGidrahSpawnTick() {
            this.spawnTick += Game.getOptions().getTicksPerFrame();
            int alpha = (int)LinearInterpolator.instance.interpolate(0.0f, 255.0f, (float)this.spawnTick / (float)EnormousTringleFeature.this.beamInEmitterFeature.getDuration());
            this.sprite.setAlpha(alpha);
            this.shadowSprite.setAlpha(alpha);
        }

        protected void removeSprites() {
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.sprite = null;
            }
            if (this.shadowSprite != null) {
                this.shadowSprite.deallocate();
                this.shadowSprite = null;
            }
        }

        protected void indicateDamage() {
            this.sprite.setFlash(true);
            this.damageIndicationTick = 4;
        }

        protected void doGidrahTick() {
            if (this.damageIndicationTick > 0) {
                this.damageIndicationTick -= Game.getOptions().getTicksPerFrame();
                if (this.damageIndicationTick <= 0) {
                    this.sprite.setFlash(false);
                }
            }
            switch (this.phase) {
                case 0: {
                    int dir = Util.random((int)0, (int)3);
                    int destx = 0;
                    int desty = 0;
                    do {
                        dir = dir + 1 & 3;
                        this.dx = Compass.dx[(dir << 1) + 1];
                        this.dy = Compass.dy[(dir << 1) + 1];
                        destx = this.position.getX() + (this.dx * EnormousTringleFeature.this.speed * EnormousTringleFeature.this.duration << Game.getOptions().getSpeedShift());
                        desty = this.position.getY() + (this.dy * EnormousTringleFeature.this.speed * EnormousTringleFeature.this.duration << Game.getOptions().getSpeedShift());
                    } while (destx < 0 || destx >= BattleZone.FPWIDTH || desty < 0 || desty >= BattleZone.FPWIDTH);
                    this.moveDuration = EnormousTringleFeature.this.duration >> Game.getOptions().getSpeedShift();
                    this.dx *= EnormousTringleFeature.this.speed << Game.getOptions().getSpeedShift();
                    this.dy *= EnormousTringleFeature.this.speed << Game.getOptions().getSpeedShift();
                    this.phase = 1;
                }
                case 1: {
                    this.spawnTick -= Game.getOptions().getTicksPerFrame();
                    if (this.spawnTick <= 0 && this.numSpawned < EnormousTringleFeature.this.maxSpawned) {
                        Gidrah newGidrah = (Gidrah)EnormousTringleFeature.this.spawnGidrahFeature.spawn();
                        newGidrah.setPosition(this.position.getX(), this.position.getY(), 0);
                        newGidrah.hatch();
                        this.spawnTick = EnormousTringleFeature.this.spawnInterval >> Game.getOptions().getSpeedShift();
                        ++this.numSpawned;
                    }
                    this.position.translate(this.dx, this.dy, 0);
                    --this.moveDuration;
                    if (this.moveDuration != 0) break;
                    this.phase = 0;
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            if (this.sprite != null) {
                this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
                this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            }
        }

        protected void doResIn() {
            this.position.set(FPMath.fpValue((int)512), FPMath.fpValue((int)512), 0);
            this.initSprite();
        }

        public void inCollisionWithPlayer(Player player) {
        }

        public void inCollisionWithSmartBomb(SmartBomb smartBomb) {
        }

        public void inCollisionWithNuke(Nuke nuke) {
        }
    }
}

