/*
 * Decompiled with CFR 0.152.
 */
package xap.emitters;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.Game;
import xap.ThrusterEmitter;
import xap.features.EmitterFeature;
import xap.features.ParticleFeature;

public class ThrusterEmitterFeature
extends EmitterFeature {
    public static final long serialVersionUID = 1L;
    private String soundEffect;
    private String particle;
    private int initialVelocity;
    private int numParticles;
    private boolean looped;
    private transient ALBuffer soundEffectResource;
    private transient ParticleFeature particleFeature;

    public ThrusterEmitterFeature() {
    }

    public ThrusterEmitterFeature(String name) {
        super(name);
    }

    protected EmitterFeature.EmitterInstance doSpawn() {
        return new ThrusterEmitterInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.initialVelocity = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"initialvelocity"));
        this.particle = XMLUtil.getString((Element)element, (String)"particle");
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect");
        this.numParticles = XMLUtil.getInt((Element)element, (String)"numparticles");
        this.looped = XMLUtil.getBoolean((Element)element, (String)"looped", (boolean)true);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.particleFeature = (ParticleFeature)Resources.get((String)this.particle);
        if (Game.hasSound()) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.particleFeature = null;
        this.soundEffectResource = null;
    }

    private class ThrusterEmitterInstance
    extends EmitterFeature.EmitterInstance
    implements ThrusterEmitter {
        private int angle;
        private SoundEffect soundEffect;
        private boolean thrustOn;

        ThrusterEmitterInstance() {
            super(ThrusterEmitterFeature.this);
        }

        protected void doRemove() {
            super.doRemove();
            if (this.soundEffect != null) {
                this.soundEffect.stop((Object)this);
            }
        }

        protected void doTick() {
            if (this.thrustOn) {
                int vx = FPMath.fpValue((double)(FPMath.doubleValue((long)ThrusterEmitterFeature.this.initialVelocity) * Math.cos(Math.PI * 2 * (double)this.angle / 65536.0))) << Game.getOptions().getSpeedShift();
                int vy = FPMath.fpValue((double)(FPMath.doubleValue((long)ThrusterEmitterFeature.this.initialVelocity) * Math.sin(Math.PI * 2 * (double)this.angle / 65536.0))) << Game.getOptions().getSpeedShift();
                int i = 0;
                while (i < ThrusterEmitterFeature.this.numParticles) {
                    ThrusterEmitterFeature.this.particleFeature.allocate(this.position.getX(), this.position.getY(), 0, vx, vy, 0);
                    ++i;
                }
            }
        }

        protected void doSpawn() {
        }

        public void setThrustOn(boolean on) {
            if (on && !this.thrustOn) {
                this.soundEffect = Game.allocateSound(ThrusterEmitterFeature.this.soundEffectResource, this.position, this.velocity, this);
                if (this.soundEffect != null && ThrusterEmitterFeature.this.looped) {
                    this.soundEffect.setLooped(true, (Object)this);
                    this.soundEffect.setGain(0.0f, (Object)this);
                    this.soundEffect.setFade(5, ThrusterEmitterFeature.this.soundEffectResource.getGain(), false, (Object)this);
                }
            } else if (!on && this.thrustOn && this.soundEffect != null) {
                this.soundEffect.setFade(5, 0.0f, true, (Object)this);
                this.soundEffect = null;
            }
            this.thrustOn = on;
        }

        public void setAngle(int angle) {
            this.angle = angle;
        }
    }
}

