/*
 * Decompiled with CFR 0.152.
 */
package xap.emitters;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import java.util.ArrayList;
import org.w3c.dom.Element;
import xap.Game;
import xap.Particle;
import xap.features.EmitterFeature;
import xap.features.ParticleFeature;

public class ExplosionEmitterFeature
extends EmitterFeature {
    public static final long serialVersionUID = 1L;
    private static final Vector3i scratchVector = new Vector3i();
    private int numParticles;
    private String particle;
    private String soundEffect;
    private transient ParticleFeature particleFeature;
    private transient ALBuffer soundEffectResource;

    public ExplosionEmitterFeature() {
    }

    public ExplosionEmitterFeature(String name) {
        super(name);
    }

    protected EmitterFeature.EmitterInstance doSpawn() {
        return new ExplosionEmitterInstance();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.particleFeature = (ParticleFeature)Resources.get((String)this.particle);
        if (Game.hasSound()) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.particleFeature = null;
        this.soundEffectResource = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.particle = XMLUtil.getString((Element)element, (String)"particle");
        this.numParticles = XMLUtil.getInt((Element)element, (String)"numparticles");
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect");
    }

    protected class ExplosionEmitterInstance
    extends EmitterFeature.EmitterInstance {
        private final ArrayList particles;

        protected ExplosionEmitterInstance() {
            super(ExplosionEmitterFeature.this);
            this.particles = new ArrayList(ExplosionEmitterFeature.this.numParticles);
        }

        protected void doSpawn() {
            Game.allocateSound(ExplosionEmitterFeature.this.soundEffectResource, this.position, this.velocity, this);
            int i = 0;
            while (i < ExplosionEmitterFeature.this.numParticles) {
                Particle p = ExplosionEmitterFeature.this.particleFeature.allocate(this.position.getX(), this.position.getY(), this.position.getZ(), 0, 0, 0);
                if (p != null) {
                    this.particles.add(p);
                }
                ++i;
            }
        }

        protected void doTick() {
            int n = this.particles.size();
            int i = 0;
            while (i < n) {
                Particle p = (Particle)this.particles.get(i);
                p.getPosition(scratchVector);
                Vector3i.add((ReadableVector3i)scratchVector, (ReadableVector3i)this.velocity, (WritableVector3i)scratchVector);
                p.getPosition().set((ReadableVector3i)scratchVector);
                ++i;
            }
        }
    }
}

