/*
 * Decompiled with CFR 0.152.
 */
package xap.background;

import com.shavenpuppy.jglib.renderer.Shader;
import com.shavenpuppy.jglib.renderer.Triangle;
import java.util.Arrays;
import xap.background.Light;

public abstract class LitShader
implements Shader {
    protected Light light;
    private final boolean[] processed;
    private int minVertexIndex;
    private int maxVertexIndex;

    public LitShader(int maxVertexIndex) {
        this.processed = new boolean[maxVertexIndex];
    }

    public final int getMinVertexIndex() {
        return this.minVertexIndex;
    }

    public final int getMaxVertexIndex() {
        return this.maxVertexIndex;
    }

    public final void setLight(Light light) {
        this.light = light;
    }

    public final void reset() {
        Arrays.fill(this.processed, false);
        this.minVertexIndex = Integer.MAX_VALUE;
        this.maxVertexIndex = Integer.MIN_VALUE;
    }

    public final void process(Triangle triangle) {
        this.process(triangle.a);
        this.process(triangle.b);
        this.process(triangle.c);
    }

    private void process(int v) {
        if (!this.processed[v]) {
            this.processed[v] = true;
            this.minVertexIndex = Math.min(v, this.minVertexIndex);
            this.maxVertexIndex = Math.max(v, this.maxVertexIndex);
            this.doProcess(v);
        }
    }

    protected abstract void doProcess(int var1);
}

