/*
 * Decompiled with CFR 0.152.
 */
package xap.background;

import com.shavenpuppy.jglib.renderer.ShadedTriangle;
import com.shavenpuppy.jglib.renderer.Shader;
import com.shavenpuppy.jglib.renderer.State;
import com.shavenpuppy.jglib.renderer.Triangle;
import org.lwjgl.util.Color;
import org.lwjgl.util.vector.Vector3f;
import xap.background.CheapassAmbientPassState;
import xap.background.CheapassDiffusePassState;
import xap.background.EmptyState;
import xap.background.LitShader;
import xap.background.PlainGeometry;
import xap.background.PlainGeometrySortState;
import xap.background.TextureSortState;

public final class CheapassShader
extends LitShader {
    private final PlainGeometry geometry;
    private final State[] ambientState;
    private final State[] diffuseState;
    private static final Vector3f vertex = new Vector3f();
    private static final Color color = new Color();

    public CheapassShader(PlainGeometrySortState geometrySortState, CheapassAmbientPassState ambientPassState, CheapassDiffusePassState diffusePassState, TextureSortState ambientTextureSortState, TextureSortState diffuseTextureSortState, int maxVertexIndex) {
        super(maxVertexIndex);
        this.geometry = geometrySortState.geometry;
        this.ambientState = new State[]{geometrySortState, ambientPassState, ambientTextureSortState, EmptyState.instance};
        this.diffuseState = new State[]{geometrySortState, diffusePassState, diffuseTextureSortState, EmptyState.instance};
    }

    public int shade(Triangle triangle, ShadedTriangle[] output, int pos) {
        output[pos++].update(triangle, (Shader)this, this.ambientState);
        output[pos++].update(triangle, (Shader)this, this.diffuseState);
        return 2;
    }

    protected void doProcess(int v) {
        this.geometry.getVertex(v, vertex);
        CheapassShader.vertex.x = this.light.x - CheapassShader.vertex.x;
        CheapassShader.vertex.y = this.light.y - CheapassShader.vertex.y;
        CheapassShader.vertex.z = this.light.z - CheapassShader.vertex.z;
        float dist = 255.0f - Math.min(224.0f, vertex.length() * 0.66f);
        color.set((byte)dist, (byte)dist, (byte)dist);
        this.geometry.setColor(v, color);
    }
}

