/*
 * Decompiled with CFR 0.152.
 */
package xap;

import com.shavenpuppy.jglib.util.FPMath;
import java.io.Serializable;
import org.lwjgl.opengl.Display;
import xap.FluxMouse;
import xap.Game;
import xap.Options;
import xap.features.ParticleFeature;
import xap.gui.CheckBox;
import xap.gui.MessageBox;
import xap.gui.MessageBoxListener;

public final class Options
implements Serializable {
    public static final long serialVersionUID = 6L;
    private static final float SIXTY_HERTZ_FRAME_TIME = 0.016666668f;
    private static final float THIRTY_HERTZ_FRAME_TIME = 0.033333335f;
    private static boolean ignorePerformanceWarning;
    private float volume;
    private float musicVolume;
    private boolean trueColour;
    private boolean useBumpMapping;
    private boolean lowRes;
    private boolean useInternet;
    private boolean askUseInternet;
    private boolean thirtyHertz;
    private boolean showPerformanceWarning;
    private int mouseSensitivity;
    private int acceleration;
    private int deceleration;
    private float gamma;
    private float brightness;
    private float contrast;
    private transient boolean renderingParametersChanged;

    public void fromEditor(Editor editor) {
        boolean newLowRes;
        boolean newTrueColour;
        this.volume = editor.getVolume();
        this.musicVolume = editor.getMusicVolume();
        this.gamma = editor.getGamma();
        this.brightness = editor.getBrightness();
        this.contrast = editor.getContrast();
        this.mouseSensitivity = editor.getMouseSensitivity();
        this.showPerformanceWarning = editor.getShowPerformanceWarning();
        boolean newUseBumpMapping = editor.getUseBumpMapping();
        if (newUseBumpMapping != this.useBumpMapping) {
            this.useBumpMapping = newUseBumpMapping;
            this.renderingParametersChanged = true;
        }
        if ((newTrueColour = editor.getTrueColour()) != this.trueColour) {
            this.trueColour = newTrueColour;
            this.renderingParametersChanged = true;
        }
        if ((newLowRes = editor.getLowRes()) != this.lowRes) {
            this.lowRes = newLowRes;
            this.renderingParametersChanged = true;
        }
        this.thirtyHertz = editor.getThirtyHertz();
        this.useInternet = editor.getUseInternet();
        this.askUseInternet = editor.getAskUseInternet();
    }

    public void toEditor(Editor editor) {
        editor.setVolume(this.volume);
        editor.setMusicVolume(this.musicVolume);
        editor.setGamma(this.gamma);
        editor.setBrightness(this.brightness);
        editor.setContrast(this.contrast);
        editor.setMouseSensitivity(this.mouseSensitivity);
        editor.setUseBumpMapping(this.useBumpMapping);
        editor.setTrueColour(this.trueColour);
        editor.setLowRes(this.lowRes);
        editor.setThirtyHertz(this.thirtyHertz);
        editor.setShowPerformanceWarning(this.showPerformanceWarning);
        editor.setUseInternet(this.useInternet);
        editor.setAskUseInternet(this.askUseInternet);
    }

    public void defaultValues() {
        this.volume = 0.8f;
        this.musicVolume = 1.0f;
        this.gamma = 1.0f;
        this.brightness = 0.0f;
        this.contrast = 1.0f;
        this.acceleration = FPMath.ONE;
        this.deceleration = FPMath.ONE;
        this.mouseSensitivity = 8;
        this.useBumpMapping = true;
        this.trueColour = true;
        this.thirtyHertz = false;
        this.lowRes = false;
        this.useInternet = true;
        this.askUseInternet = true;
        this.showPerformanceWarning = true;
    }

    public boolean isTrueColour() {
        return this.trueColour;
    }

    public boolean useBumpMapping() {
        return this.useBumpMapping;
    }

    public int getFrequency() {
        return this.thirtyHertz ? 30 : 60;
    }

    public int getSpeedShift() {
        return this.thirtyHertz ? 1 : 0;
    }

    public int getTicksPerFrame() {
        return this.thirtyHertz ? 2 : 1;
    }

    public float getFrameTime() {
        return this.thirtyHertz ? 0.033333335f : 0.016666668f;
    }

    public int getPreferredWidth() {
        return this.lowRes ? 640 : 800;
    }

    public int getPreferredHeight() {
        return this.lowRes ? 480 : 600;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getMusicVolume() {
        return this.musicVolume;
    }

    public int getAcceleration() {
        return this.acceleration;
    }

    public int getDeceleration() {
        return this.deceleration;
    }

    public boolean getUseInternet() {
        return this.useInternet;
    }

    public boolean getAskUseInternet() {
        return this.askUseInternet;
    }

    public void setAskUseInternet(boolean newValue) {
        this.askUseInternet = newValue;
    }

    public void setUseInternet(boolean newValue) {
        this.useInternet = newValue;
    }

    public boolean renderingParametersChanged() {
        return this.renderingParametersChanged;
    }

    public void recommendFasterConfiguration() {
        if (ignorePerformanceWarning || !this.showPerformanceWarning) {
            return;
        }
        try {
            CheckBox cbx = new CheckBox("Don't tell me again");
            cbx.layout().pack().setWidth(cbx.getWidth() + 16);
            class MBL
            implements MessageBoxListener {
                final /* synthetic */ Options this$0;
                private final /* synthetic */ CheckBox val$cbx;

                MBL(Options options, CheckBox checkBox) {
                    this.this$0 = options;
                    this.val$cbx = checkBox;
                }

                public void messageBoxChoiceMade(MessageBox mbox, int choice) {
                    Options.access$0(false);
                    if (this.val$cbx.isChecked() == Options.access$1(this.this$0)) {
                        Options.access$2(this.this$0, !this.val$cbx.isChecked());
                    }
                }
            }
            MBL mbl = new MBL(this, cbx);
            if (this.trueColour) {
                new MessageBox("Performance Problems", "Alien Flux is not running at its best. We recommend you try using 16 bit colour. You can change this in the Options screen.", cbx, 0, 0, mbl).open();
                ignorePerformanceWarning = true;
                return;
            }
            if (!this.thirtyHertz) {
                new MessageBox("Performance Problems", "Alien Flux is not running at its best. We recommend you try using 30Hz mode. You can change this in the Options screen.", cbx, 0, 0, mbl).open();
                ignorePerformanceWarning = true;
                return;
            }
            if (this.useBumpMapping) {
                new MessageBox("Performance Problems", "Alien Flux is not running at its best. We recommend you try turning off bump mapping. You can change this in the Options screen.", cbx, 0, 0, mbl).open();
                ignorePerformanceWarning = true;
                return;
            }
            if (!this.lowRes) {
                new MessageBox("Performance Problems", "Alien Flux is not running at its best. We recommend you try using low resolution graphics. You can change this in the Options screen.", cbx, 0, 0, mbl).open();
                ignorePerformanceWarning = true;
                return;
            }
            new MessageBox("Performance Problems", "Alien Flux is not running at its best. We recommend you upgrade your processor or better still, your graphics card. Please contact support@puppygames.net for advice.", 0, 0, mbl).open();
            ignorePerformanceWarning = true;
            ParticleFeature.reduceTotalParticleCount();
        }
        catch (Exception e) {
            Game.handleException(e);
        }
    }

    public void apply() {
        FluxMouse.setSensitivity(this.mouseSensitivity);
        try {
            Display.setDisplayConfiguration((float)this.gamma, (float)this.brightness, (float)this.contrast);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        Game.setMusicVolume(this.musicVolume);
        Game.setVolume(this.volume);
        this.renderingParametersChanged = false;
    }

    static /* synthetic */ void access$0(boolean bl) {
        ignorePerformanceWarning = bl;
    }

    static /* synthetic */ boolean access$1(Options options) {
        return options.showPerformanceWarning;
    }

    static /* synthetic */ void access$2(Options options, boolean bl) {
        options.showPerformanceWarning = bl;
    }

    public static interface Editor {
        public float getVolume();

        public float getMusicVolume();

        public float getGamma();

        public float getBrightness();

        public float getContrast();

        public int getMouseSensitivity();

        public boolean getTrueColour();

        public boolean getUseBumpMapping();

        public boolean getLowRes();

        public boolean getThirtyHertz();

        public boolean getUseInternet();

        public boolean getAskUseInternet();

        public boolean getShowPerformanceWarning();

        public void setVolume(float var1);

        public void setMusicVolume(float var1);

        public void setGamma(float var1);

        public void setBrightness(float var1);

        public void setContrast(float var1);

        public void setMouseSensitivity(int var1);

        public void setTrueColour(boolean var1);

        public void setUseBumpMapping(boolean var1);

        public void setThirtyHertz(boolean var1);

        public void setLowRes(boolean var1);

        public void setUseInternet(boolean var1);

        public void setAskUseInternet(boolean var1);

        public void setShowPerformanceWarning(boolean var1);
    }
}

