/*
 * Decompiled with CFR 0.152.
 */
package xap;

import com.shavenpuppy.jglib.util.Util;
import net.puppygames.gamecommerce.shared.ConfigurationDetails;

public class Configuration
implements ConfigurationDetails {
    private static final long serialVersionUID = 1L;
    private static final int[] MAX_GAMES;
    private static final int[] MAX_TIME;
    private int maxGames = -1;
    private int maxTime = -1;

    static {
        int[] nArray = new int[6];
        nArray[1] = 6;
        nArray[2] = 8;
        nArray[3] = 10;
        nArray[4] = 12;
        nArray[5] = 14;
        MAX_GAMES = nArray;
        int[] nArray2 = new int[6];
        nArray2[1] = 600;
        nArray2[2] = 1200;
        nArray2[3] = 1800;
        nArray2[4] = 2400;
        nArray2[5] = 3000;
        MAX_TIME = nArray2;
    }

    public String encode() {
        StringBuffer sb = new StringBuffer(8);
        if (this.maxGames == -1) {
            throw new IllegalStateException("maxGames not set");
        }
        if (this.maxTime == -1) {
            throw new IllegalStateException("maxTime not set");
        }
        if (this.maxGames < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(this.maxGames));
        if (this.maxTime < 1600) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(this.maxTime / 100));
        return sb.toString();
    }

    public ConfigurationDetails decode(String encoded) throws Exception {
        this.maxGames = Integer.parseInt(encoded.substring(0, 2), 16);
        this.maxTime = Integer.parseInt(encoded.substring(2, 4), 16) * 100;
        return this;
    }

    public void init() {
        Util.setSeed((long)Util.getMachineSeed());
        if (this.maxGames == -1) {
            this.maxGames = MAX_GAMES[Util.random((int)0, (int)(MAX_GAMES.length - 1))];
        }
        if (this.maxTime == -1) {
            this.maxTime = MAX_TIME[Util.random((int)0, (int)(MAX_TIME.length - 1))];
        }
    }

    public int getMaxGames() {
        return this.maxGames;
    }

    public int getMaxTime() {
        return this.maxTime;
    }
}

