/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.lwjgl.Sys;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.util.Display;

public final class Display {
    private static final boolean DEBUG = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lwjgl.util.Display");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static DisplayMode[] getAvailableDisplayModes(int minWidth, int minHeight, int maxWidth, int maxHeight, int minBPP, int maxBPP, int minFreq, int maxFreq) {
        DisplayMode[] modes = org.lwjgl.opengl.Display.getAvailableDisplayModes();
        if (Sys.DEBUG) {
            System.out.println("Available screen modes:");
            int i = 0;
            while (i < modes.length) {
                System.out.println(modes[i]);
                ++i;
            }
        }
        ArrayList<DisplayMode> matches = new ArrayList<DisplayMode>(modes.length);
        int i = 0;
        while (i < modes.length) {
            if (!$assertionsDisabled && modes[i] == null) {
                throw new AssertionError((Object)(i + " " + modes.length));
            }
            if (!(minWidth != -1 && modes[i].getWidth() < minWidth || maxWidth != -1 && modes[i].getWidth() > maxWidth || minHeight != -1 && modes[i].getHeight() < minHeight || maxHeight != -1 && modes[i].getHeight() > maxHeight || minBPP != -1 && modes[i].getBitsPerPixel() < minBPP || maxBPP != -1 && modes[i].getBitsPerPixel() > maxBPP || modes[i].getFrequency() != 0 && (minFreq != -1 && modes[i].getFrequency() < minFreq || maxFreq != -1 && modes[i].getFrequency() > maxFreq))) {
                matches.add(modes[i]);
            }
            ++i;
        }
        DisplayMode[] ret = new DisplayMode[matches.size()];
        matches.toArray(ret);
        return ret;
    }

    public static DisplayMode setDisplayMode(DisplayMode[] dm, String[] param) throws Exception {
        int i;
        class Sorter
        implements Comparator {
            final Field[] field;
            final int[] order;
            final boolean[] usePreferred;
            final int[] preferred;

            Sorter(String[] stringArray) throws NoSuchFieldException {
                this.field = new Field[stringArray.length];
                this.order = new int[stringArray.length];
                this.preferred = new int[stringArray.length];
                this.usePreferred = new boolean[stringArray.length];
                int i = 0;
                while (i < this.field.length) {
                    int idx = stringArray[i].indexOf(61);
                    if (idx > 0) {
                        this.preferred[i] = Integer.parseInt(stringArray[i].substring(idx + 1, stringArray[i].length()));
                        this.usePreferred[i] = true;
                        stringArray[i] = stringArray[i].substring(0, idx);
                        Class<?> clazz = Display.class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.lwjgl.opengl.DisplayMode");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.field[i] = clazz.getDeclaredField(stringArray[i]);
                    } else if (stringArray[i].charAt(0) == '-') {
                        Class<?> clazz = Display.class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.lwjgl.opengl.DisplayMode");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.field[i] = clazz.getDeclaredField(stringArray[i].substring(1));
                        this.order[i] = -1;
                    } else {
                        Class<?> clazz = Display.class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.lwjgl.opengl.DisplayMode");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.field[i] = clazz.getDeclaredField(stringArray[i]);
                        this.order[i] = 1;
                    }
                    this.field[i].setAccessible(true);
                    ++i;
                }
            }

            public int compare(Object o1, Object o2) {
                DisplayMode dm1 = (DisplayMode)o1;
                DisplayMode dm2 = (DisplayMode)o2;
                int i = 0;
                while (i < this.field.length) {
                    try {
                        int f1 = this.field[i].getInt(dm1);
                        int f2 = this.field[i].getInt(dm2);
                        if (this.usePreferred[i] && f1 != f2) {
                            int absf2;
                            if (f1 == this.preferred[i]) {
                                return -1;
                            }
                            if (f2 == this.preferred[i]) {
                                return 1;
                            }
                            int absf1 = Math.abs(f1 - this.preferred[i]);
                            if (absf1 < (absf2 = Math.abs(f2 - this.preferred[i]))) {
                                return -1;
                            }
                            if (absf1 > absf2) {
                                return 1;
                            }
                        } else {
                            if (f1 < f2) {
                                return this.order[i];
                            }
                            if (f1 != f2) {
                                return -this.order[i];
                            }
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    ++i;
                }
                return 0;
            }
        }
        Arrays.sort(dm, new Sorter(param));
        if (Sys.DEBUG) {
            System.out.println("Sorted display modes:");
            i = 0;
            while (i < dm.length) {
                System.out.println(dm[i]);
                ++i;
            }
        }
        i = 0;
        while (i < dm.length) {
            try {
                if (Sys.DEBUG) {
                    System.out.println("Attempting to set displaymode: " + dm[i]);
                }
                org.lwjgl.opengl.Display.setDisplayMode(dm[i]);
                return dm[i];
            }
            catch (Exception e) {
                if (Sys.DEBUG) {
                    System.out.println("Failed to set display mode to " + dm[i]);
                    e.printStackTrace();
                }
                ++i;
            }
        }
        throw new Exception("Failed to set display mode.");
    }
}

