/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl.glu;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.Util;

public class Project
extends Util {
    private static final float[] IDENTITY_MATRIX = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private static final FloatBuffer matrix = BufferUtils.createFloatBuffer(16);
    private static final float[][] finalMatrix = new float[4][4];
    private static final float[][] tempMatrix = new float[4][4];
    private static final float[] in = new float[4];
    private static final float[] out = new float[4];
    private static final float[] forward = new float[3];
    private static final float[] side = new float[3];
    private static final float[] up = new float[3];

    private static void __gluMakeIdentityf(FloatBuffer m) {
        int oldPos = m.position();
        m.put(IDENTITY_MATRIX);
        m.position(oldPos);
    }

    private static void __gluMakeIdentityf(float[][] m) {
        int i = 0;
        while (i < 16) {
            m[i >> 2][i % 4] = IDENTITY_MATRIX[i];
            ++i;
        }
    }

    private static void __gluMultMatrixVecf(float[][] finalMatrix, float[] in, float[] out) {
        int i = 0;
        while (i < 4) {
            out[i] = in[0] * finalMatrix[0][i] + in[1] * finalMatrix[1][i] + in[2] * finalMatrix[2][i] + in[3] * finalMatrix[3][i];
            ++i;
        }
    }

    private static boolean __gluInvertMatrixf(float[][] src, float[][] inverse) {
        int j;
        float[][] temp = tempMatrix;
        int i = 0;
        while (i < 4) {
            j = 0;
            while (j < 4) {
                temp[i][j] = src[i][j];
                ++j;
            }
            ++i;
        }
        Project.__gluMakeIdentityf(inverse);
        i = 0;
        while (i < 4) {
            float t;
            int k;
            int swap = i;
            j = i + 1;
            while (j < 4) {
                if (Math.abs(temp[j][i]) > Math.abs(temp[i][i])) {
                    swap = j;
                }
                ++j;
            }
            if (swap != i) {
                k = 0;
                while (k < 4) {
                    t = temp[i][k];
                    temp[i][k] = temp[swap][k];
                    temp[swap][k] = t;
                    t = inverse[i][k];
                    inverse[i][k] = inverse[swap][k];
                    inverse[swap][k] = t;
                    ++k;
                }
            }
            if (temp[i][i] == 0.0f) {
                return false;
            }
            t = temp[i][i];
            k = 0;
            while (k < 4) {
                float[] fArray = temp[i];
                int n = k;
                fArray[n] = fArray[n] / t;
                inverse[i][k] = inverse[i][k] / t;
                ++k;
            }
            j = 0;
            while (j < 4) {
                if (j != i) {
                    t = temp[j][i];
                    k = 0;
                    while (k < 4) {
                        float[] fArray = temp[j];
                        int n = k;
                        fArray[n] = fArray[n] - temp[i][k] * t;
                        inverse[j][k] = inverse[j][k] - inverse[i][k] * t;
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private static void __gluMultMatricesf(float[][] a, float[][] b, float[][] r) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                r[i][j] = a[i][0] * b[0][j] + a[i][1] * b[1][j] + a[i][2] * b[2][j] + a[i][3] * b[3][j];
                ++j;
            }
            ++i;
        }
    }

    public static void gluPerspective(float fovy, float aspect, float zNear, float zFar) {
        float radians = fovy / 2.0f * (float)Math.PI / 180.0f;
        float deltaZ = zFar - zNear;
        float sine = (float)Math.sin(radians);
        if (deltaZ == 0.0f || sine == 0.0f || aspect == 0.0f) {
            return;
        }
        float cotangent = (float)Math.cos(radians) / sine;
        Project.__gluMakeIdentityf(matrix);
        matrix.put(0, cotangent / aspect);
        matrix.put(5, cotangent);
        matrix.put(10, -(zFar + zNear) / deltaZ);
        matrix.put(11, -1.0f);
        matrix.put(14, -2.0f * zNear * zFar / deltaZ);
        matrix.put(15, 0.0f);
        GL11.glMultMatrix(matrix);
    }

    public static void gluLookAt(float eyex, float eyey, float eyez, float centerx, float centery, float centerz, float upx, float upy, float upz) {
        float[] forward = Project.forward;
        float[] side = Project.side;
        float[] up = Project.up;
        forward[0] = centerx - eyex;
        forward[1] = centery - eyey;
        forward[2] = centerz - eyez;
        up[0] = upx;
        up[1] = upy;
        up[2] = upz;
        Util.normalize(forward);
        Util.cross(forward, up, side);
        Util.normalize(side);
        Util.cross(side, forward, up);
        Project.__gluMakeIdentityf(matrix);
        matrix.put(0, side[0]);
        matrix.put(4, side[1]);
        matrix.put(8, side[2]);
        matrix.put(1, up[0]);
        matrix.put(5, up[1]);
        matrix.put(9, up[2]);
        matrix.put(2, -forward[0]);
        matrix.put(6, -forward[1]);
        matrix.put(10, -forward[2]);
        GL11.glMultMatrix(matrix);
        GL11.glTranslatef(-eyex, -eyey, -eyez);
    }

    public static boolean gluProject(float objx, float objy, float objz, float[][] modelMatrix, float[][] projMatrix, int[] viewport, float[] win_pos) {
        float[] in = Project.in;
        float[] out = Project.out;
        in[0] = objx;
        in[1] = objy;
        in[2] = objz;
        in[3] = 1.0f;
        Project.__gluMultMatrixVecf(modelMatrix, in, out);
        Project.__gluMultMatrixVecf(projMatrix, out, in);
        if ((double)in[3] == 0.0) {
            return false;
        }
        in[3] = 1.0f / in[3] * 0.5f;
        in[0] = in[0] * in[3] + 0.5f;
        in[1] = in[1] * in[3] + 0.5f;
        in[2] = in[2] * in[3] + 0.5f;
        win_pos[0] = in[0] * (float)viewport[2] + (float)viewport[0];
        win_pos[1] = in[1] * (float)viewport[3] + (float)viewport[1];
        win_pos[2] = in[2];
        return true;
    }

    public static boolean gluUnProject(float winx, float winy, float winz, float[][] modelMatrix, float[][] projMatrix, int[] viewport, float[] obj_pos) {
        float[] in = Project.in;
        float[] out = Project.out;
        Project.__gluMultMatricesf(modelMatrix, projMatrix, finalMatrix);
        if (!Project.__gluInvertMatrixf(finalMatrix, finalMatrix)) {
            return false;
        }
        in[0] = winx;
        in[1] = winy;
        in[2] = winz;
        in[3] = 1.0f;
        in[0] = (in[0] - (float)viewport[0]) / (float)viewport[2];
        in[1] = (in[1] - (float)viewport[1]) / (float)viewport[3];
        in[0] = in[0] * 2.0f - 1.0f;
        in[1] = in[1] * 2.0f - 1.0f;
        in[2] = in[2] * 2.0f - 1.0f;
        Project.__gluMultMatrixVecf(finalMatrix, in, out);
        if ((double)out[3] == 0.0) {
            return false;
        }
        out[3] = 1.0f / out[3];
        obj_pos[0] = out[0] * out[3];
        obj_pos[1] = out[1] * out[3];
        obj_pos[2] = out[2] * out[3];
        return true;
    }

    public static void gluPickMatrix(float x, float y, float deltaX, float deltaY, int[] viewport) {
        if (deltaX <= 0.0f || deltaY <= 0.0f) {
            return;
        }
        GL11.glTranslatef(((float)viewport[2] - 2.0f * (x - (float)viewport[0])) / deltaX, ((float)viewport[3] - 2.0f * (y - (float)viewport[1])) / deltaY, 0.0f);
        GL11.glScalef((float)viewport[2] / deltaX, (float)viewport[3] / deltaY, 1.0f);
    }
}

