/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.RenderTexture;

public final class Pbuffer {
    public static final int PBUFFER_SUPPORTED = 1;
    public static final int RENDER_TEXTURE_SUPPORTED = 2;
    public static final int RENDER_TEXTURE_RECTANGLE_SUPPORTED = 4;
    public static final int RENDER_DEPTH_TEXTURE_SUPPORTED = 8;
    public static final int MIPMAP_LEVEL = 8315;
    public static final int CUBE_MAP_FACE = 8316;
    public static final int TEXTURE_CUBE_MAP_POSITIVE_X = 8317;
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_X = 8318;
    public static final int TEXTURE_CUBE_MAP_POSITIVE_Y = 8319;
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_Y = 8320;
    public static final int TEXTURE_CUBE_MAP_POSITIVE_Z = 8321;
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_Z = 8322;
    public static final int FRONT_LEFT_BUFFER = 8323;
    public static final int FRONT_RIGHT_BUFFER = 8324;
    public static final int BACK_LEFT_BUFFER = 8325;
    public static final int BACK_RIGHT_BUFFER = 8326;
    public static final int DEPTH_BUFFER = 8359;
    private final ByteBuffer handle;
    private final int width;
    private final int height;

    static {
        Sys.initialize();
    }

    public Pbuffer(int width, int height, PixelFormat pixel_format, RenderTexture renderTexture, Pbuffer shared_context) throws LWJGLException {
        this.width = width;
        this.height = height;
        this.handle = Pbuffer.createPbuffer(width, height, pixel_format, renderTexture, shared_context != null ? shared_context.handle : null);
    }

    private static ByteBuffer createPbuffer(int width, int height, PixelFormat pixel_format, RenderTexture renderTexture, ByteBuffer shared_context_handle) throws LWJGLException {
        GLContext.loadOpenGLLibrary();
        try {
            if (renderTexture == null) {
                return Display.getImplementation().createPbuffer(width, height, pixel_format, null, null, shared_context_handle);
            }
            return Display.getImplementation().createPbuffer(width, height, pixel_format, renderTexture.pixelFormatCaps, renderTexture.pBufferAttribs, shared_context_handle);
        }
        catch (LWJGLException e) {
            GLContext.unloadOpenGLLibrary();
            throw e;
        }
    }

    public boolean isBufferLost() {
        return Display.getImplementation().isBufferLost(this.handle);
    }

    public void makeCurrent() throws LWJGLException {
        Display.getImplementation().makePbufferCurrent(this.handle);
        GLContext.useContext(this);
    }

    public static int getCapabilities() {
        return Display.getImplementation().getPbufferCapabilities();
    }

    public void destroy() {
        try {
            this.makeCurrent();
            int error = GL11.glGetError();
            Display.getImplementation().destroyPbuffer(this.handle);
            GLContext.useContext(null);
            GLContext.unloadOpenGLLibrary();
            if (error != 0) {
                throw new OpenGLException(error);
            }
        }
        catch (LWJGLException lWJGLException) {
            // empty catch block
        }
    }

    public void setAttrib(int attrib, int value) {
        Display.getImplementation().setPbufferAttrib(this.handle, attrib, value);
    }

    public void bindTexImage(int buffer) {
        Display.getImplementation().bindTexImageToPbuffer(this.handle, buffer);
    }

    public void releaseTexImage(int buffer) {
        Display.getImplementation().releaseTexImageFromPbuffer(this.handle, buffer);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

