/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.KeyboardEventQueue;
import org.lwjgl.opengl.MacOSXFrame;
import org.lwjgl.opengl.MacOSXGLCanvas;
import org.lwjgl.opengl.MouseEventQueue;
import org.lwjgl.opengl.PixelFormat;

final class MacOSXDisplay
implements DisplayImplementation {
    private static final int PBUFFER_HANDLE_SIZE = 24;
    private static final int GAMMA_LENGTH = 256;
    private MacOSXFrame frame;
    private MouseEventQueue mouse_queue;
    private KeyboardEventQueue keyboard_queue;
    private java.awt.DisplayMode requested_mode;
    private boolean close_requested;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lwjgl.opengl.MacOSXDisplay");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    MacOSXDisplay() {
        new MacOSXApplicationListener();
    }

    public void createWindow(DisplayMode mode, boolean fullscreen, int x, int y) throws LWJGLException {
        this.hideUI(fullscreen);
        this.close_requested = false;
        try {
            this.frame = new MacOSXFrame(mode, this.requested_mode, fullscreen, x, y);
        }
        catch (LWJGLException e) {
            this.destroyWindow();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQuit() {
        MacOSXDisplay macOSXDisplay = this;
        synchronized (macOSXDisplay) {
            this.close_requested = true;
        }
    }

    public void destroyWindow() {
        if (this.frame != null) {
            if (MacOSXFrame.getDevice().getFullScreenWindow() == this.frame) {
                MacOSXFrame.getDevice().setFullScreenWindow(null);
            }
            this.setView(null);
            if (this.frame.isDisplayable()) {
                this.frame.dispose();
            }
            this.frame = null;
        }
        this.hideUI(false);
    }

    public int getGammaRampLength() {
        return 256;
    }

    public native void setGammaRamp(FloatBuffer var1) throws LWJGLException;

    public String getAdapter() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    private boolean equals(java.awt.DisplayMode awt_mode, DisplayMode mode) {
        return awt_mode.getWidth() == mode.getWidth() && awt_mode.getHeight() == mode.getHeight() && awt_mode.getBitDepth() == mode.getBitsPerPixel() && awt_mode.getRefreshRate() == mode.getFrequency();
    }

    public void switchDisplayMode(DisplayMode mode) throws LWJGLException {
        java.awt.DisplayMode[] awt_modes = MacOSXFrame.getDevice().getDisplayModes();
        int i = 0;
        while (i < awt_modes.length) {
            if (this.equals(awt_modes[i], mode)) {
                this.requested_mode = awt_modes[i];
                return;
            }
            ++i;
        }
        throw new LWJGLException(mode + " is not supported");
    }

    public void resetDisplayMode() {
        if (MacOSXFrame.getDevice().getFullScreenWindow() != null) {
            MacOSXFrame.getDevice().setFullScreenWindow(null);
        }
        this.requested_mode = null;
        this.restoreGamma();
    }

    private native void restoreGamma();

    private DisplayMode createLWJGLDisplayMode(java.awt.DisplayMode awt_mode) {
        int awt_bit_depth = awt_mode.getBitDepth();
        int awt_refresh_rate = awt_mode.getRefreshRate();
        int bit_depth = awt_bit_depth != -1 ? awt_bit_depth : 32;
        int refresh_rate = awt_refresh_rate != 0 ? awt_refresh_rate : 0;
        return new DisplayMode(awt_mode.getWidth(), awt_mode.getHeight(), bit_depth, refresh_rate);
    }

    public DisplayMode init() {
        return this.createLWJGLDisplayMode(MacOSXFrame.getDevice().getDisplayMode());
    }

    public DisplayMode[] getAvailableDisplayModes() {
        java.awt.DisplayMode[] awt_modes = MacOSXFrame.getDevice().getDisplayModes();
        ArrayList<DisplayMode> modes = new ArrayList<DisplayMode>();
        int i = 0;
        while (i < awt_modes.length) {
            if (awt_modes[i].getBitDepth() >= 16) {
                modes.add(this.createLWJGLDisplayMode(awt_modes[i]));
            }
            ++i;
        }
        DisplayMode[] mode_list = new DisplayMode[modes.size()];
        modes.toArray(mode_list);
        return mode_list;
    }

    public void setTitle(String title) {
        this.frame.setTitle(title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCloseRequested() {
        boolean result;
        MacOSXDisplay macOSXDisplay = this;
        synchronized (macOSXDisplay) {
            result = this.close_requested || this.frame != null && this.frame.syncIsCloseRequested();
            this.close_requested = false;
        }
        return result;
    }

    public boolean isVisible() {
        return this.frame.syncIsVisible();
    }

    public boolean isActive() {
        return this.frame.syncIsActive();
    }

    public boolean isDirty() {
        return this.frame.getCanvas().syncIsDirty();
    }

    public native void setView(MacOSXGLCanvas var1);

    public native void swapBuffers();

    public native void makeCurrent() throws LWJGLException;

    public native void createContext(PixelFormat var1) throws LWJGLException;

    public native void destroyContext();

    public void update() {
        if (this.frame.syncShouldUpdateContext()) {
            this.updateContext();
            GL11.glViewport(0, 0, this.frame.getCanvas().syncGetWidth(), this.frame.getCanvas().syncGetHeight());
            this.warpCursor();
        }
    }

    private void warpCursor() {
        if (this.mouse_queue != null && this.mouse_queue.isGrabbed()) {
            Rectangle bounds = this.frame.syncGetBounds();
            int x = bounds.x + bounds.width / 2;
            int y = bounds.y + bounds.height / 2;
            this.nWarpCursor(x, y);
        }
    }

    private native void hideUI(boolean var1);

    native void getMouseDeltas(IntBuffer var1);

    private native void updateContext();

    public native void setVSyncEnabled(boolean var1);

    public void reshape(int x, int y, int width, int height) {
        this.frame.resize(x, y, width, height);
    }

    public boolean hasWheel() {
        return true;
    }

    public int getButtonCount() {
        return 3;
    }

    public void createMouse() {
        MacOSXGLCanvas canvas = this.frame.getCanvas();
        this.mouse_queue = new MouseEventQueue(canvas.getWidth(), canvas.getHeight());
        canvas.addMouseListener(this.mouse_queue);
        canvas.addMouseMotionListener(this.mouse_queue);
        canvas.addMouseWheelListener(this.mouse_queue);
    }

    public void destroyMouse() {
        MacOSXGLCanvas canvas = this.frame.getCanvas();
        canvas.removeMouseListener(this.mouse_queue);
        canvas.removeMouseWheelListener(this.mouse_queue);
        canvas.removeMouseMotionListener(this.mouse_queue);
        this.mouse_queue = null;
    }

    public void pollMouse(IntBuffer coord_buffer, ByteBuffer buttons_buffer) {
        this.mouse_queue.poll(coord_buffer, buttons_buffer);
    }

    public int readMouse(IntBuffer buffer, int buffer_position) {
        if (!$assertionsDisabled && buffer_position != buffer.position()) {
            throw new AssertionError();
        }
        return this.mouse_queue.copyEvents(buffer);
    }

    public void grabMouse(boolean grab) {
        this.mouse_queue.setGrabbed(grab);
        this.warpCursor();
        this.nGrabMouse(grab);
    }

    private native void nWarpCursor(int var1, int var2);

    private native void nGrabMouse(boolean var1);

    public int getNativeCursorCapabilities() {
        return 0;
    }

    public void setNativeCursor(Object handle) throws LWJGLException {
        Cursor awt_cursor = (Cursor)handle;
        this.frame.setCursor(awt_cursor);
    }

    public int getMinCursorSize() {
        Dimension min_size = Toolkit.getDefaultToolkit().getBestCursorSize(0, 0);
        return Math.max(min_size.width, min_size.height);
    }

    public int getMaxCursorSize() {
        Dimension max_size = Toolkit.getDefaultToolkit().getBestCursorSize(10000, 10000);
        return Math.min(max_size.width, max_size.height);
    }

    public void createKeyboard() throws LWJGLException {
        MacOSXGLCanvas canvas = this.frame.getCanvas();
        this.keyboard_queue = new KeyboardEventQueue();
        canvas.addKeyListener(this.keyboard_queue);
    }

    public void destroyKeyboard() {
        this.keyboard_queue = null;
    }

    public void pollKeyboard(ByteBuffer keyDownBuffer) {
        this.keyboard_queue.poll(keyDownBuffer);
    }

    public int readKeyboard(IntBuffer buffer, int buffer_position) {
        if (!$assertionsDisabled && buffer_position != buffer.position()) {
            throw new AssertionError();
        }
        return this.keyboard_queue.copyEvents(buffer);
    }

    public int isStateKeySet(int key) {
        return 2;
    }

    public Object createCursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) throws LWJGLException {
        BufferedImage cursor_image = new BufferedImage(width, height, 2);
        int[] pixels = new int[images.remaining()];
        int old_position = images.position();
        images.get(pixels);
        images.position(old_position);
        cursor_image.setRGB(0, 0, width, height, pixels, 0, width);
        return Toolkit.getDefaultToolkit().createCustomCursor(cursor_image, new Point(xHotspot, yHotspot), "LWJGL Custom cursor");
    }

    public void destroyCursor(Object cursor_handle) {
    }

    public int getPbufferCapabilities() {
        return GL11.glGetString(7939).indexOf("GL_APPLE_pixel_buffer") != -1 ? 1 : 0;
    }

    public boolean isBufferLost(ByteBuffer handle) {
        return false;
    }

    public native void makePbufferCurrent(ByteBuffer var1) throws LWJGLException;

    public ByteBuffer createPbuffer(int width, int height, PixelFormat pixel_format, IntBuffer pixelFormatCaps, IntBuffer pBufferAttribs, ByteBuffer shared_pbuffer_handle) throws LWJGLException {
        ByteBuffer handle = BufferUtils.createByteBuffer(24);
        this.nCreatePbuffer(handle, width, height, pixel_format, pixelFormatCaps, pBufferAttribs, shared_pbuffer_handle);
        return handle;
    }

    private native void nCreatePbuffer(ByteBuffer var1, int var2, int var3, PixelFormat var4, IntBuffer var5, IntBuffer var6, ByteBuffer var7) throws LWJGLException;

    public native void destroyPbuffer(ByteBuffer var1);

    public void setPbufferAttrib(ByteBuffer handle, int attrib, int value) {
        throw new UnsupportedOperationException();
    }

    public void bindTexImageToPbuffer(ByteBuffer handle, int buffer) {
        throw new UnsupportedOperationException();
    }

    public void releaseTexImageFromPbuffer(ByteBuffer handle, int buffer) {
        throw new UnsupportedOperationException();
    }

    private class MacOSXApplicationListener
    implements InvocationHandler {
        private final Method handleQuit;

        public MacOSXApplicationListener() {
            try {
                Class<?> com_apple_eawt_Application = Class.forName("com.apple.eawt.Application");
                Object application = com_apple_eawt_Application.getMethod("getApplication", null).invoke(null, null);
                Class<?> com_apple_eawt_ApplicationListener = Class.forName("com.apple.eawt.ApplicationListener");
                Object listener_proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{com_apple_eawt_ApplicationListener}, (InvocationHandler)this);
                Method addApplicationListener = com_apple_eawt_Application.getMethod("addApplicationListener", com_apple_eawt_ApplicationListener);
                addApplicationListener.invoke(application, listener_proxy);
                Class<?> com_apple_eawt_ApplicationEvent = Class.forName("com.apple.eawt.ApplicationEvent");
                this.handleQuit = com_apple_eawt_ApplicationListener.getMethod("handleQuit", com_apple_eawt_ApplicationEvent);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Object invoke(Object proxy, Method method, Object[] args) {
            if (method.equals(this.handleQuit)) {
                MacOSXDisplay.this.handleQuit();
            }
            return null;
        }
    }
}

