/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.PixelFormat;

final class LinuxDisplay
implements DisplayImplementation {
    private static final int CURSOR_HANDLE_SIZE = 8;
    private static final int PBUFFER_HANDLE_SIZE = 24;
    private static final int NUM_BUTTONS = 3;

    LinuxDisplay() {
    }

    private native void lockAWT();

    private native void unlockAWT();

    public void createWindow(DisplayMode mode, boolean fullscreen, int x, int y) throws LWJGLException {
        this.lockAWT();
        this.nCreateWindow(mode, fullscreen, x, y);
        this.unlockAWT();
    }

    public native void nCreateWindow(DisplayMode var1, boolean var2, int var3, int var4) throws LWJGLException;

    public void destroyWindow() {
        this.lockAWT();
        this.nDestroyWindow();
        this.unlockAWT();
    }

    public native void nDestroyWindow();

    public void switchDisplayMode(DisplayMode mode) throws LWJGLException {
        this.lockAWT();
        this.nSwitchDisplayMode(mode);
        this.unlockAWT();
    }

    public native void nSwitchDisplayMode(DisplayMode var1) throws LWJGLException;

    public void resetDisplayMode() {
        this.lockAWT();
        this.nResetDisplayMode();
        this.unlockAWT();
    }

    public native void nResetDisplayMode();

    public int getGammaRampLength() {
        this.lockAWT();
        int length = this.nGetGammaRampLength();
        this.unlockAWT();
        return length;
    }

    public native int nGetGammaRampLength();

    public void setGammaRamp(FloatBuffer gammaRamp) throws LWJGLException {
        this.lockAWT();
        this.nSetGammaRamp(gammaRamp);
        this.unlockAWT();
    }

    public native void nSetGammaRamp(FloatBuffer var1) throws LWJGLException;

    public String getAdapter() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public DisplayMode init() {
        this.lockAWT();
        DisplayMode mode = this.nInit();
        this.unlockAWT();
        return mode;
    }

    public native DisplayMode nInit();

    public void setTitle(String title) {
        this.lockAWT();
        this.nSetTitle(title);
        this.unlockAWT();
    }

    public native void nSetTitle(String var1);

    public boolean isCloseRequested() {
        this.lockAWT();
        boolean result = this.nIsCloseRequested();
        this.unlockAWT();
        return result;
    }

    public native boolean nIsCloseRequested();

    public boolean isVisible() {
        this.lockAWT();
        boolean result = this.nIsVisible();
        this.unlockAWT();
        return result;
    }

    public native boolean nIsVisible();

    public boolean isActive() {
        this.lockAWT();
        boolean result = this.nIsActive();
        this.unlockAWT();
        return result;
    }

    public native boolean nIsActive();

    public boolean isDirty() {
        this.lockAWT();
        boolean result = this.nIsDirty();
        this.unlockAWT();
        return result;
    }

    public native boolean nIsDirty();

    public void swapBuffers() {
        this.lockAWT();
        this.nSwapBuffers();
        this.unlockAWT();
    }

    public native void nSwapBuffers();

    public void makeCurrent() throws LWJGLException {
        this.lockAWT();
        this.nMakeCurrent();
        this.unlockAWT();
    }

    public native void nMakeCurrent() throws LWJGLException;

    public void createContext(PixelFormat pixel_format) throws LWJGLException {
        this.lockAWT();
        this.nCreateContext(pixel_format);
        this.unlockAWT();
    }

    public native void nCreateContext(PixelFormat var1) throws LWJGLException;

    public void destroyContext() {
        this.lockAWT();
        this.nDestroyContext();
        this.unlockAWT();
    }

    public native void nDestroyContext();

    public void update() {
        this.lockAWT();
        this.nUpdate();
        this.unlockAWT();
    }

    public native void nUpdate();

    public void setVSyncEnabled(boolean sync) {
        this.lockAWT();
        this.nSetVSyncEnabled(sync);
        this.unlockAWT();
    }

    public native void nSetVSyncEnabled(boolean var1);

    public void reshape(int x, int y, int width, int height) {
        this.lockAWT();
        this.nReshape(x, y, width, height);
        this.unlockAWT();
    }

    public native void nReshape(int var1, int var2, int var3, int var4);

    public DisplayMode[] getAvailableDisplayModes() {
        this.lockAWT();
        DisplayMode[] modes = this.nGetAvailableDisplayModes();
        this.unlockAWT();
        return modes;
    }

    public native DisplayMode[] nGetAvailableDisplayModes();

    public boolean hasWheel() {
        return true;
    }

    public int getButtonCount() {
        return 3;
    }

    public void createMouse() {
        this.lockAWT();
        this.nCreateMouse();
        this.unlockAWT();
    }

    public native void nCreateMouse();

    public void destroyMouse() {
        this.lockAWT();
        this.nDestroyMouse();
        this.unlockAWT();
    }

    public native void nDestroyMouse();

    public void pollMouse(IntBuffer coord_buffer, ByteBuffer buttons) {
        this.lockAWT();
        this.nPollMouse(coord_buffer, buttons);
        this.unlockAWT();
    }

    public native void nPollMouse(IntBuffer var1, ByteBuffer var2);

    public int readMouse(IntBuffer buffer, int buffer_position) {
        this.lockAWT();
        int count = this.nReadMouse(buffer, buffer_position);
        this.unlockAWT();
        return count;
    }

    public native int nReadMouse(IntBuffer var1, int var2);

    public void grabMouse(boolean grab) {
        this.lockAWT();
        this.nGrabMouse(grab);
        this.unlockAWT();
    }

    public native void nGrabMouse(boolean var1);

    public int getNativeCursorCapabilities() {
        this.lockAWT();
        int caps = this.nGetNativeCursorCapabilities();
        this.unlockAWT();
        return caps;
    }

    public native int nGetNativeCursorCapabilities();

    public void setNativeCursor(Object handle) throws LWJGLException {
        this.lockAWT();
        this.nSetNativeCursor(handle);
        this.unlockAWT();
    }

    public native void nSetNativeCursor(Object var1) throws LWJGLException;

    public int getMinCursorSize() {
        this.lockAWT();
        int min_size = this.nGetMinCursorSize();
        this.unlockAWT();
        return min_size;
    }

    public native int nGetMinCursorSize();

    public int getMaxCursorSize() {
        this.lockAWT();
        int max_size = this.nGetMaxCursorSize();
        this.unlockAWT();
        return max_size;
    }

    public native int nGetMaxCursorSize();

    public void createKeyboard() throws LWJGLException {
        this.lockAWT();
        this.nCreateKeyboard();
        this.unlockAWT();
    }

    public native void nCreateKeyboard() throws LWJGLException;

    public void destroyKeyboard() {
        this.lockAWT();
        this.nDestroyKeyboard();
        this.unlockAWT();
    }

    public native void nDestroyKeyboard();

    public void pollKeyboard(ByteBuffer keyDownBuffer) {
        this.lockAWT();
        this.nPollKeyboard(keyDownBuffer);
        this.unlockAWT();
    }

    public native void nPollKeyboard(ByteBuffer var1);

    public int readKeyboard(IntBuffer buffer, int buffer_position) {
        this.lockAWT();
        int count = this.nReadKeyboard(buffer, buffer_position);
        this.unlockAWT();
        return count;
    }

    public native int nReadKeyboard(IntBuffer var1, int var2);

    public int isStateKeySet(int key) {
        return 2;
    }

    public native void nCreateCursor(ByteBuffer var1, int var2, int var3, int var4, int var5, int var6, IntBuffer var7, int var8, IntBuffer var9, int var10) throws LWJGLException;

    public Object createCursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) throws LWJGLException {
        this.lockAWT();
        ByteBuffer handle = BufferUtils.createByteBuffer(8);
        this.nCreateCursor(handle, width, height, xHotspot, yHotspot, numImages, images, images.position(), delays, delays != null ? delays.position() : -1);
        this.unlockAWT();
        return handle;
    }

    public void destroyCursor(Object cursorHandle) {
        this.lockAWT();
        this.nDestroyCursor(cursorHandle);
        this.unlockAWT();
    }

    public native void nDestroyCursor(Object var1);

    public int getPbufferCapabilities() {
        this.lockAWT();
        int caps = this.nGetPbufferCapabilities();
        this.unlockAWT();
        return caps;
    }

    public native int nGetPbufferCapabilities();

    public boolean isBufferLost(ByteBuffer handle) {
        return false;
    }

    public void makePbufferCurrent(ByteBuffer handle) throws LWJGLException {
        this.lockAWT();
        this.nMakePbufferCurrent(handle);
        this.unlockAWT();
    }

    public native void nMakePbufferCurrent(ByteBuffer var1) throws LWJGLException;

    public ByteBuffer createPbuffer(int width, int height, PixelFormat pixel_format, IntBuffer pixelFormatCaps, IntBuffer pBufferAttribs, ByteBuffer shared_pbuffer_handle) throws LWJGLException {
        this.lockAWT();
        ByteBuffer handle = BufferUtils.createByteBuffer(24);
        this.nCreatePbuffer(handle, width, height, pixel_format, pixelFormatCaps, pBufferAttribs, shared_pbuffer_handle);
        this.unlockAWT();
        return handle;
    }

    private native void nCreatePbuffer(ByteBuffer var1, int var2, int var3, PixelFormat var4, IntBuffer var5, IntBuffer var6, ByteBuffer var7) throws LWJGLException;

    public void destroyPbuffer(ByteBuffer handle) {
        this.lockAWT();
        this.nDestroyPbuffer(handle);
        this.unlockAWT();
    }

    public native void nDestroyPbuffer(ByteBuffer var1);

    public void setPbufferAttrib(ByteBuffer handle, int attrib, int value) {
        throw new UnsupportedOperationException();
    }

    public void bindTexImageToPbuffer(ByteBuffer handle, int buffer) {
        throw new UnsupportedOperationException();
    }

    public void releaseTexImageFromPbuffer(ByteBuffer handle, int buffer) {
        throw new UnsupportedOperationException();
    }
}

