/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GLBufferChecks;

public final class GL20 {
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_SHADER_OBJECT = 35656;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_1D = 35677;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_3D = 35679;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_SAMPLER_1D_SHADOW = 35681;
    public static final int GL_SAMPLER_2D_SHADOW = 35682;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_UNIFORM_COMPONENTS = 35658;
    public static final int GL_MAX_VARYING_FLOATS = 35659;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_MAX_TEXTURE_COORDS = 34929;
    public static final int GL_VERTEX_PROGRAM_POINT_SIZE = 34370;
    public static final int GL_VERTEX_PROGRAM_TWO_SIDE = 34371;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 35657;
    public static final int GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 35723;
    public static final int GL_MAX_DRAW_BUFFERS = 34852;
    public static final int GL_DRAW_BUFFER0 = 34853;
    public static final int GL_DRAW_BUFFER1 = 34854;
    public static final int GL_DRAW_BUFFER2 = 34855;
    public static final int GL_DRAW_BUFFER3 = 34856;
    public static final int GL_DRAW_BUFFER4 = 34857;
    public static final int GL_DRAW_BUFFER5 = 34858;
    public static final int GL_DRAW_BUFFER6 = 34859;
    public static final int GL_DRAW_BUFFER7 = 34860;
    public static final int GL_DRAW_BUFFER8 = 34861;
    public static final int GL_DRAW_BUFFER9 = 34862;
    public static final int GL_DRAW_BUFFER10 = 34863;
    public static final int GL_DRAW_BUFFER11 = 34864;
    public static final int GL_DRAW_BUFFER12 = 34865;
    public static final int GL_DRAW_BUFFER13 = 34866;
    public static final int GL_DRAW_BUFFER14 = 34867;
    public static final int GL_DRAW_BUFFER15 = 34868;
    public static final int GL_POINT_SPRITE = 34913;
    public static final int GL_COORD_REPLACE = 34914;
    public static final int GL_POINT_SPRITE_COORD_ORIGIN = 36000;
    public static final int GL_LOWER_LEFT = 36001;
    public static final int GL_UPPER_LEFT = 36002;
    public static final int GL_STENCIL_BACK_FUNC = 34816;
    public static final int GL_STENCIL_BACK_FAIL = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;

    private GL20() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glShaderSource(int shader, ByteBuffer string) {
        BufferChecks.checkDirect(string);
        GL20.initShaderSource(1);
        GL20.setShaderString(0, string, string.position(), string.remaining());
        GL20.nglShaderSource(shader);
    }

    public static void glShaderSource(int shader, ByteBuffer[] strings) {
        if (strings == null || strings.length == 0) {
            throw new IllegalArgumentException("Invalid shader string array.");
        }
        GL20.initShaderSource(strings.length);
        int i = 0;
        while (i < strings.length) {
            BufferChecks.checkDirect(strings[i]);
            GL20.setShaderString(i, strings[i], strings[i].position(), strings[i].remaining());
            ++i;
        }
        GL20.nglShaderSource(shader);
    }

    private static native void initShaderSource(int var0);

    private static native void setShaderString(int var0, ByteBuffer var1, int var2, int var3);

    private static native void nglShaderSource(int var0);

    public static native int glCreateShader(int var0);

    public static native boolean glIsShader(int var0);

    public static native void glCompileShader(int var0);

    public static native void glDeleteShader(int var0);

    public static native int glCreateProgram();

    public static native boolean glIsProgram(int var0);

    public static native void glAttachShader(int var0, int var1);

    public static native void glDetachShader(int var0, int var1);

    public static native void glLinkProgram(int var0);

    public static native void glUseProgram(int var0);

    public static native void glValidateProgram(int var0);

    public static native void glDeleteProgram(int var0);

    public static native void glUniform1f(int var0, float var1);

    public static native void glUniform2f(int var0, float var1, float var2);

    public static native void glUniform3f(int var0, float var1, float var2, float var3);

    public static native void glUniform4f(int var0, float var1, float var2, float var3, float var4);

    public static native void glUniform1i(int var0, int var1);

    public static native void glUniform2i(int var0, int var1, int var2);

    public static native void glUniform3i(int var0, int var1, int var2, int var3);

    public static native void glUniform4i(int var0, int var1, int var2, int var3, int var4);

    public static void glUniform1(int location, FloatBuffer values) {
        BufferChecks.checkDirect(values);
        GL20.nglUniform1fv(location, values.remaining(), values, values.position());
    }

    private static native void nglUniform1fv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glUniform2(int location, FloatBuffer values) {
        BufferChecks.checkDirect(values);
        GL20.nglUniform2fv(location, values.remaining() >> 1, values, values.position());
    }

    private static native void nglUniform2fv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glUniform3(int location, FloatBuffer values) {
        BufferChecks.checkDirect(values);
        GL20.nglUniform3fv(location, values.remaining() / 3, values, values.position());
    }

    private static native void nglUniform3fv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glUniform4(int location, FloatBuffer values) {
        BufferChecks.checkDirect(values);
        GL20.nglUniform4fv(location, values.remaining() >> 2, values, values.position());
    }

    private static native void nglUniform4fv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glUniform1(int location, IntBuffer values) {
        BufferChecks.checkDirect(values);
        GL20.nglUniform1iv(location, values.remaining(), values, values.position());
    }

    private static native void nglUniform1iv(int var0, int var1, IntBuffer var2, int var3);

    public static void glUniform2(int location, IntBuffer values) {
        BufferChecks.checkDirect(values);
        GL20.nglUniform2iv(location, values.remaining() >> 1, values, values.position());
    }

    private static native void nglUniform2iv(int var0, int var1, IntBuffer var2, int var3);

    public static void glUniform3(int location, IntBuffer values) {
        BufferChecks.checkDirect(values);
        GL20.nglUniform3iv(location, values.remaining() / 3, values, values.position());
    }

    private static native void nglUniform3iv(int var0, int var1, IntBuffer var2, int var3);

    public static void glUniform4(int location, IntBuffer values) {
        BufferChecks.checkDirect(values);
        GL20.nglUniform4iv(location, values.remaining() >> 2, values, values.position());
    }

    private static native void nglUniform4iv(int var0, int var1, IntBuffer var2, int var3);

    public static void glUniformMatrix2(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        GL20.nglUniformMatrix2fv(location, matrices.remaining() >> 2, transpose, matrices, matrices.position());
    }

    private static native void nglUniformMatrix2fv(int var0, int var1, boolean var2, FloatBuffer var3, int var4);

    public static void glUniformMatrix3(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        GL20.nglUniformMatrix3fv(location, matrices.remaining() / 9, transpose, matrices, matrices.position());
    }

    private static native void nglUniformMatrix3fv(int var0, int var1, boolean var2, FloatBuffer var3, int var4);

    public static void glUniformMatrix4(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        GL20.nglUniformMatrix4fv(location, matrices.remaining() >> 4, transpose, matrices, matrices.position());
    }

    private static native void nglUniformMatrix4fv(int var0, int var1, boolean var2, FloatBuffer var3, int var4);

    public static void glGetShader(int shader, int pname, FloatBuffer params) {
        BufferChecks.checkDirect(params);
        GL20.nglGetShaderfv(shader, pname, params, params.position());
    }

    private static native void nglGetShaderfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetShader(int shader, int pname, IntBuffer params) {
        BufferChecks.checkDirect(params);
        GL20.nglGetShaderiv(shader, pname, params, params.position());
    }

    private static native void nglGetShaderiv(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetProgram(int program, int pname, FloatBuffer params) {
        BufferChecks.checkDirect(params);
        GL20.nglGetProgramfv(program, pname, params, params.position());
    }

    private static native void nglGetProgramfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetProgram(int program, int pname, IntBuffer params) {
        BufferChecks.checkDirect(params);
        GL20.nglGetProgramiv(program, pname, params, params.position());
    }

    private static native void nglGetProgramiv(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetShaderInfoLog(int shader, IntBuffer length, ByteBuffer infoLog) {
        BufferChecks.checkDirect(infoLog);
        if (length == null) {
            GL20.nglGetShaderInfoLog(shader, infoLog.remaining(), null, -1, infoLog, infoLog.position());
        } else {
            BufferChecks.checkBuffer(length, 1);
            GL20.nglGetShaderInfoLog(shader, infoLog.remaining(), length, length.position(), infoLog, infoLog.position());
        }
    }

    private static native void nglGetShaderInfoLog(int var0, int var1, IntBuffer var2, int var3, ByteBuffer var4, int var5);

    public static void glGetProgramInfoLog(int program, IntBuffer length, ByteBuffer infoLog) {
        BufferChecks.checkDirect(infoLog);
        if (length == null) {
            GL20.nglGetProgramInfoLog(program, infoLog.remaining(), null, -1, infoLog, infoLog.position());
        } else {
            BufferChecks.checkBuffer(length, 1);
            GL20.nglGetProgramInfoLog(program, infoLog.remaining(), length, length.position(), infoLog, infoLog.position());
        }
    }

    private static native void nglGetProgramInfoLog(int var0, int var1, IntBuffer var2, int var3, ByteBuffer var4, int var5);

    public static void glGetAttachedShaders(int program, IntBuffer count, IntBuffer shaders) {
        if (count == null) {
            GL20.nglGetAttachedShaders(program, shaders.remaining(), null, -1, shaders, shaders.position());
        } else {
            if (count.remaining() == 0) {
                throw new BufferOverflowException();
            }
            GL20.nglGetAttachedShaders(program, shaders.remaining(), count, count.position(), shaders, shaders.position());
        }
    }

    private static native void nglGetAttachedShaders(int var0, int var1, IntBuffer var2, int var3, IntBuffer var4, int var5);

    public static int glGetUniformLocation(int program, ByteBuffer name) {
        return GL20.nglGetUniformLocation(program, name, name.position());
    }

    private static native int nglGetUniformLocation(int var0, ByteBuffer var1, int var2);

    public static void glGetActiveUniform(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (size.remaining() == 0) {
            throw new BufferOverflowException();
        }
        if (type.remaining() == 0) {
            throw new BufferOverflowException();
        }
        if (length == null) {
            GL20.nglGetActiveUniform(program, index, name.remaining(), null, -1, size, size.position(), type, type.position(), name, name.position());
        } else {
            if (length.remaining() == 0) {
                throw new BufferOverflowException();
            }
            GL20.nglGetActiveUniform(program, index, name.remaining(), length, length.position(), size, size.position(), type, type.position(), name, name.position());
        }
    }

    private static native void nglGetActiveUniform(int var0, int var1, int var2, IntBuffer var3, int var4, IntBuffer var5, int var6, IntBuffer var7, int var8, ByteBuffer var9, int var10);

    public static void glGetUniform(int program, int location, FloatBuffer params) {
        GL20.nglGetUniformfv(program, location, params, params.position());
    }

    private static native void nglGetUniformfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetUniform(int program, int location, IntBuffer params) {
        GL20.nglGetUniformiv(program, location, params, params.position());
    }

    private static native void nglGetUniformiv(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetShaderSource(int shader, IntBuffer length, ByteBuffer source) {
        if (length == null) {
            GL20.nglGetShaderSource(shader, source.remaining(), null, -1, source, source.position());
        } else {
            GL20.nglGetShaderSource(shader, source.remaining(), length, length.position(), source, source.position());
        }
    }

    private static native void nglGetShaderSource(int var0, int var1, IntBuffer var2, int var3, ByteBuffer var4, int var5);

    public static native void glVertexAttrib1s(int var0, short var1);

    public static native void glVertexAttrib1f(int var0, float var1);

    public static native void glVertexAttrib2s(int var0, short var1, short var2);

    public static native void glVertexAttrib2f(int var0, float var1, float var2);

    public static native void glVertexAttrib3s(int var0, short var1, short var2, short var3);

    public static native void glVertexAttrib3f(int var0, float var1, float var2, float var3);

    public static native void glVertexAttrib4s(int var0, short var1, short var2, short var3, short var4);

    public static native void glVertexAttrib4f(int var0, float var1, float var2, float var3, float var4);

    public static native void glVertexAttrib4Nub(int var0, byte var1, byte var2, byte var3, byte var4);

    public static void glVertexAttribPointer(int index, int size, boolean unsigned, boolean normalized, int stride, ByteBuffer buffer) {
        GLBufferChecks.ensureArrayVBOdisabled();
        GL20.nglVertexAttribPointer(index, size, unsigned ? 5121 : 5120, normalized, stride, buffer, buffer.position());
    }

    public static void glVertexAttribPointer(int index, int size, boolean unsigned, boolean normalized, int stride, ShortBuffer buffer) {
        GLBufferChecks.ensureArrayVBOdisabled();
        GL20.nglVertexAttribPointer(index, size, unsigned ? 5123 : 5122, normalized, stride, buffer, buffer.position() << 1);
    }

    public static void glVertexAttribPointer(int index, int size, boolean normalized, int stride, FloatBuffer buffer) {
        GLBufferChecks.ensureArrayVBOdisabled();
        GL20.nglVertexAttribPointer(index, size, 5126, normalized, stride, buffer, buffer.position() << 2);
    }

    public static void glVertexAttribPointer(int index, int size, boolean unsigned, boolean normalized, int stride, IntBuffer buffer) {
        GLBufferChecks.ensureArrayVBOdisabled();
        GL20.nglVertexAttribPointer(index, size, unsigned ? 5125 : 5124, normalized, stride, buffer, buffer.position() << 2);
    }

    private static native void nglVertexAttribPointer(int var0, int var1, int var2, boolean var3, int var4, Buffer var5, int var6);

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, int bufferOffset) {
        GLBufferChecks.ensureArrayVBOenabled();
        GL20.nglVertexAttribPointerVBO(index, size, type, normalized, stride, bufferOffset);
    }

    private static native void nglVertexAttribPointerVBO(int var0, int var1, int var2, boolean var3, int var4, int var5);

    public static native void glEnableVertexAttribArray(int var0);

    public static native void glDisableVertexAttribArray(int var0);

    public static void glGetVertexAttrib(int index, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        GL20.nglGetVertexAttribfv(index, pname, params, params.position());
    }

    private static native void nglGetVertexAttribfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetVertexAttrib(int index, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL20.nglGetVertexAttribiv(index, pname, params, params.position());
    }

    private static native void nglGetVertexAttribiv(int var0, int var1, IntBuffer var2, int var3);

    public static native ByteBuffer glGetVertexAttribPointer(int var0, int var1, int var2);

    public static void glBindAttribLocation(int program, int index, ByteBuffer name) {
        BufferChecks.checkDirect(name);
        if (name.get(name.limit() - 1) != 0) {
            throw new IllegalArgumentException("<name> must be a null-terminated string.");
        }
        GL20.nglBindAttribLocation(program, index, name, name.position());
    }

    private static native void nglBindAttribLocation(int var0, int var1, ByteBuffer var2, int var3);

    public static void glGetActiveAttrib(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        BufferChecks.checkDirect(name);
        BufferChecks.checkDirect(size);
        BufferChecks.checkDirect(type);
        if (length == null) {
            GL20.nglGetActiveAttrib(program, index, name.remaining(), null, -1, size, size.position(), type, type.position(), name, name.position());
        } else {
            BufferChecks.checkDirect(length);
            GL20.nglGetActiveAttrib(program, index, name.remaining(), length, length.position(), size, size.position(), type, type.position(), name, name.position());
        }
    }

    private static native void nglGetActiveAttrib(int var0, int var1, int var2, IntBuffer var3, int var4, IntBuffer var5, int var6, IntBuffer var7, int var8, ByteBuffer var9, int var10);

    public static int glGetAttribLocation(int program, ByteBuffer name) {
        BufferChecks.checkDirect(name);
        if (name.get(name.limit() - 1) != 0) {
            throw new IllegalArgumentException("<name> must be a null-terminated string.");
        }
        return GL20.nglGetAttribLocation(program, name, name.position());
    }

    private static native int nglGetAttribLocation(int var0, ByteBuffer var1, int var2);

    public static void glDrawBuffers(IntBuffer buffers) {
        BufferChecks.checkBuffer(buffers, 1);
        GL20.nglDrawBuffers(buffers.remaining(), buffers, buffers.position());
    }

    private static native void nglDrawBuffers(int var0, IntBuffer var1, int var2);

    public static native void glStencilOpSeparate(int var0, int var1, int var2, int var3);

    public static native void glStencilFuncSeparate(int var0, int var1, int var2, int var3);

    public static native void glStencilMaskSeparate(int var0, int var1);

    public static native void glBlendEquationSeparate(int var0, int var1);
}

