/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.HashSet;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Util;

public final class Display {
    private static final DisplayImplementation display_impl;
    private static final DisplayMode initial_mode;
    private static DisplayMode current_mode;
    private static long timeNow;
    private static long timeThen;
    private static int x;
    private static int y;
    private static String title;
    private static boolean fullscreen;
    private static boolean vsync;
    private static Display context;
    private static long timeLate;

    static {
        x = -1;
        y = -1;
        title = "Game";
        Sys.initialize();
        display_impl = Display.createDisplayImplementation();
        current_mode = initial_mode = display_impl.init();
        Sys.log("Initial mode: " + initial_mode);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Display.reset();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static DisplayImplementation createDisplayImplementation() {
        String class_name;
        String os_name = System.getProperty("os.name");
        if (os_name.startsWith("Linux")) {
            class_name = "org.lwjgl.opengl.LinuxDisplay";
        } else if (os_name.startsWith("Windows")) {
            class_name = "org.lwjgl.opengl.Win32Display";
        } else if (os_name.startsWith("Mac")) {
            class_name = "org.lwjgl.opengl.MacOSXDisplay";
        } else {
            throw new IllegalStateException("The platform " + os_name + " is not supported");
        }
        try {
            void var0_1;
            Class<?> display_class = Class.forName((String)var0_1);
            return (DisplayImplementation)display_class.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Display() {
    }

    public static DisplayMode[] getAvailableDisplayModes() {
        DisplayMode[] unfilteredModes = display_impl.getAvailableDisplayModes();
        if (unfilteredModes == null) {
            return new DisplayMode[0];
        }
        HashSet<DisplayMode> modes = new HashSet<DisplayMode>(unfilteredModes.length);
        modes.addAll(Arrays.asList(unfilteredModes));
        DisplayMode[] filteredModes = new DisplayMode[modes.size()];
        modes.toArray(filteredModes);
        Sys.log("Removed " + (unfilteredModes.length - filteredModes.length) + " duplicate displaymodes");
        return filteredModes;
    }

    public static DisplayMode getDisplayMode() {
        return current_mode;
    }

    public static void setDisplayMode(DisplayMode mode) throws LWJGLException {
        if (mode == null) {
            throw new NullPointerException("mode must be non-null");
        }
        current_mode = mode;
        if (Display.isCreated()) {
            Display.destroyWindow();
            Display.setFullscreen(mode.isFullscreen());
            try {
                if (fullscreen) {
                    Display.switchDisplayMode();
                }
                Display.createWindow();
            }
            catch (LWJGLException e) {
                display_impl.destroyContext();
                display_impl.resetDisplayMode();
                throw e;
            }
        }
    }

    private static void createWindow() throws LWJGLException {
        int window_y;
        int window_x;
        if (!fullscreen) {
            if (x == -1 && y == -1) {
                window_x = Math.max(0, (initial_mode.getWidth() - current_mode.getWidth()) / 2);
                window_y = Math.max(0, (initial_mode.getHeight() - current_mode.getHeight()) / 2);
            } else {
                window_x = x;
                window_y = y;
            }
        } else {
            window_x = 0;
            window_y = 0;
        }
        display_impl.createWindow(current_mode, fullscreen, window_x, window_y);
        Display.makeCurrent();
        Display.setTitle(title);
        Display.initControls();
        Display.setVSyncEnabled(vsync);
    }

    private static void destroyWindow() {
        if (Mouse.isCreated()) {
            Mouse.destroy();
        }
        if (Keyboard.isCreated()) {
            Keyboard.destroy();
        }
        display_impl.destroyWindow();
    }

    private static void switchDisplayMode() throws LWJGLException {
        if (!current_mode.isFullscreen()) {
            throw new LWJGLException("The current DisplayMode instance cannot be used for fullscreen mode");
        }
        display_impl.switchDisplayMode(current_mode);
    }

    public static void setDisplayConfiguration(float gamma, float brightness, float contrast) throws LWJGLException {
        if (!Display.isCreated()) {
            throw new LWJGLException("Display not yet created.");
        }
        if (brightness < -1.0f || brightness > 1.0f) {
            throw new IllegalArgumentException("Invalid brightness value");
        }
        if (contrast < 0.0f) {
            throw new IllegalArgumentException("Invalid contrast value");
        }
        int rampSize = display_impl.getGammaRampLength();
        if (rampSize == 0) {
            throw new LWJGLException("Display configuration not supported");
        }
        FloatBuffer gammaRamp = BufferUtils.createFloatBuffer(rampSize);
        int i = 0;
        while (i < rampSize) {
            float intensity = (float)i / (float)(rampSize - 1);
            float rampEntry = (float)Math.pow(intensity, gamma);
            rampEntry += brightness;
            if ((rampEntry = (rampEntry - 0.5f) * contrast + 0.5f) > 1.0f) {
                rampEntry = 1.0f;
            } else if (rampEntry < 0.0f) {
                rampEntry = 0.0f;
            }
            gammaRamp.put(i, rampEntry);
            ++i;
        }
        display_impl.setGammaRamp(gammaRamp);
        Sys.log("Gamma set, gamma = " + gamma + ", brightness = " + brightness + ", contrast = " + contrast);
    }

    public static void sync(int fps) {
        float frameTime = 1.0f / (float)(fps > 1 ? fps - 1 : 1);
        timeNow = Sys.getTime();
        while (timeNow > timeThen && (float)(timeNow - timeThen) / (float)Sys.getTimerResolution() < frameTime) {
            Thread.yield();
            timeNow = Sys.getTime();
        }
        timeThen = timeNow;
    }

    public static void sync2(int fps) {
        long gapTo = Sys.getTimerResolution() / (long)fps + timeThen;
        timeNow = Sys.getTime();
        while (gapTo > timeNow + timeLate) {
            Thread.yield();
            timeNow = Sys.getTime();
        }
        timeLate = gapTo < timeNow ? timeNow - gapTo : 0L;
        timeThen = timeNow;
    }

    public static String getTitle() {
        return title;
    }

    public static void setFullscreen(boolean fullscreen) throws LWJGLException {
        if (Display.fullscreen != fullscreen) {
            Display.fullscreen = fullscreen;
            if (!Display.isCreated()) {
                return;
            }
            Display.destroyWindow();
            try {
                if (fullscreen) {
                    Display.switchDisplayMode();
                } else {
                    display_impl.resetDisplayMode();
                }
                Display.createWindow();
            }
            catch (LWJGLException e) {
                display_impl.destroyContext();
                display_impl.resetDisplayMode();
                throw e;
            }
        }
    }

    public static boolean isFullscreen() {
        return fullscreen;
    }

    public static void setTitle(String newTitle) {
        if (newTitle == null) {
            newTitle = "";
        }
        title = newTitle;
        if (Display.isCreated()) {
            display_impl.setTitle(title);
        }
    }

    public static boolean isCloseRequested() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot determine close requested state of uncreated window");
        }
        display_impl.update();
        return display_impl.isCloseRequested();
    }

    public static boolean isVisible() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot determine minimized state of uncreated window");
        }
        display_impl.update();
        return display_impl.isVisible();
    }

    public static boolean isActive() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot determine focused state of uncreated window");
        }
        display_impl.update();
        return display_impl.isActive();
    }

    public static boolean isDirty() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot determine dirty state of uncreated window");
        }
        display_impl.update();
        return display_impl.isDirty();
    }

    public static void processMessages() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot update uncreated window");
        }
        display_impl.update();
    }

    public static void update() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot update uncreated window");
        }
        if (Display.isVisible() || Display.isDirty()) {
            Util.checkGLError();
            display_impl.swapBuffers();
        }
        Display.processMessages();
        if (Mouse.isCreated()) {
            Mouse.poll();
            Mouse.updateCursor();
        }
        if (Keyboard.isCreated()) {
            Keyboard.poll();
        }
    }

    public static void makeCurrent() throws LWJGLException {
        if (!Display.isCreated()) {
            throw new IllegalStateException("No window created to make current");
        }
        display_impl.makeCurrent();
        GLContext.useContext(context);
    }

    public static void create() throws LWJGLException {
        Display.create(new PixelFormat());
    }

    public static void create(PixelFormat pixel_format) throws LWJGLException {
        if (Display.isCreated()) {
            throw new IllegalStateException("Only one LWJGL context may be instantiated at any one time.");
        }
        if (fullscreen) {
            Display.switchDisplayMode();
        }
        try {
            GLContext.loadOpenGLLibrary();
            try {
                display_impl.createContext(pixel_format);
                try {
                    context = new Display();
                    Display.createWindow();
                    Display.initContext();
                }
                catch (LWJGLException e) {
                    display_impl.destroyContext();
                    context = null;
                    throw e;
                }
            }
            catch (LWJGLException e) {
                GLContext.unloadOpenGLLibrary();
                throw e;
            }
        }
        catch (LWJGLException e) {
            display_impl.resetDisplayMode();
            throw e;
        }
    }

    private static void initContext() {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, current_mode.getWidth(), 0.0, current_mode.getHeight(), -1.0, 1.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glViewport(0, 0, current_mode.getWidth(), current_mode.getHeight());
    }

    public static DisplayImplementation getImplementation() {
        return display_impl;
    }

    private static void initControls() {
        if (!Boolean.getBoolean("org.lwjgl.opengl.Display.noinput")) {
            if (!Mouse.isCreated() && !Boolean.getBoolean("org.lwjgl.opengl.Display.nomouse")) {
                try {
                    Mouse.create();
                }
                catch (LWJGLException e) {
                    if (Sys.DEBUG) {
                        e.printStackTrace(System.err);
                    }
                    Sys.log("Failed to create Mouse: " + e);
                }
            }
            if (!Keyboard.isCreated() && !Boolean.getBoolean("org.lwjgl.opengl.Display.nokeyboard")) {
                try {
                    Keyboard.create();
                }
                catch (LWJGLException e) {
                    if (Sys.DEBUG) {
                        e.printStackTrace(System.err);
                    }
                    Sys.log("Failed to create Keyboard: " + e);
                }
            }
        }
    }

    public static void destroy() {
        if (!Display.isCreated()) {
            return;
        }
        Display.destroyWindow();
        display_impl.destroyContext();
        GLContext.unloadOpenGLLibrary();
        context = null;
        y = -1;
        x = -1;
        try {
            GLContext.useContext(null);
        }
        catch (LWJGLException e) {
            Sys.log("Failed to reset GLContext due to: " + e);
        }
        Display.reset();
    }

    private static void reset() {
        display_impl.resetDisplayMode();
        current_mode = initial_mode;
    }

    public static Object getContext() {
        return context;
    }

    public static boolean isCreated() {
        return context != null;
    }

    public static void setVSyncEnabled(boolean sync) {
        vsync = sync;
        if (Display.isCreated()) {
            display_impl.setVSyncEnabled(vsync);
        }
    }

    public static void setLocation(int x, int y) {
        if (fullscreen) {
            return;
        }
        if (Display.isCreated()) {
            display_impl.reshape(x, y, current_mode.getWidth(), current_mode.getHeight());
        }
        Display.x = x;
        Display.y = y;
    }

    public static String getAdapter() {
        return display_impl.getAdapter();
    }

    public static String getVersion() {
        return display_impl.getVersion();
    }
}

