/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.io.File;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCcontext;
import org.lwjgl.openal.ALCdevice;

public final class AL {
    protected static ALC alc;
    protected static ALCdevice device;
    protected static ALCcontext context;
    protected static String deviceArguments;
    protected static int contextFrequency;
    protected static int contextRefresh;
    protected static int contextSynchronized;
    protected static boolean created;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        contextFrequency = -1;
        contextRefresh = -1;
        contextSynchronized = 0;
        Sys.initialize();
    }

    private AL() {
    }

    protected static native void nCreate(String[] var0) throws LWJGLException;

    protected static native void nDestroy();

    public static boolean isCreated() {
        return created;
    }

    public static void create(String deviceArguments, int contextFrequency, int contextRefresh, boolean contextSynchronized) throws LWJGLException {
        if (created) {
            return;
        }
        AL.deviceArguments = deviceArguments;
        AL.contextFrequency = contextFrequency;
        AL.contextRefresh = contextRefresh;
        AL.contextSynchronized = contextSynchronized ? 1 : 0;
        AL.create();
    }

    private static String[] getOALPaths() throws LWJGLException {
        String lwjgl_jws_path;
        String jwsLibname;
        String libpath = System.getProperty("java.library.path");
        String seperator = System.getProperty("path.separator");
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Win")) {
            jwsLibname = "lwjglaudio";
        } else if (osName.startsWith("Lin")) {
            jwsLibname = "openal";
        } else if (osName.startsWith("Mac")) {
            jwsLibname = "openal";
        } else {
            throw new LWJGLException("Unknown platform: " + osName);
        }
        String jwsPath = AL.getPathFromJWS(jwsLibname);
        if (jwsPath != null) {
            Sys.log("getPathFromJWS: Path found: " + jwsPath);
            libpath = String.valueOf(libpath) + seperator + jwsPath.substring(0, jwsPath.lastIndexOf(File.separator));
        }
        if ((lwjgl_jws_path = AL.getPathFromJWS("lwjgl")) != null) {
            Sys.log("getPathFromJWS: Path found: " + lwjgl_jws_path);
            libpath = String.valueOf(libpath) + seperator + lwjgl_jws_path.substring(0, lwjgl_jws_path.lastIndexOf(File.separator));
        }
        StringTokenizer st = new StringTokenizer(libpath, seperator);
        String[] oalPaths = new String[st.countTokens() + 1];
        int i = 0;
        while (i < oalPaths.length - 1) {
            oalPaths[i] = String.valueOf(st.nextToken()) + File.separator;
            ++i;
        }
        i = 0;
        while (i < oalPaths.length) {
            Sys.log("Will search " + oalPaths[i] + " for " + jwsLibname);
            ++i;
        }
        oalPaths[oalPaths.length - 1] = "";
        return oalPaths;
    }

    public static void create() throws LWJGLException {
        if (created) {
            return;
        }
        String[] oalPaths = AL.getOALPaths();
        AL.nCreate(oalPaths);
        created = true;
        try {
            AL10.initNativeStubs();
            ALC.initNativeStubs();
            device = ALC.alcOpenDevice(deviceArguments);
            if (device == null) {
                throw new LWJGLException("Could not open ALC device");
            }
            context = contextFrequency == -1 ? ALC.alcCreateContext(AL.device.device, null) : ALC.alcCreateContext(AL.device.device, ALCcontext.createAttributeList(contextFrequency, contextRefresh, contextSynchronized));
            ALC.alcMakeContextCurrent(AL.context.context);
            created = true;
        }
        catch (LWJGLException e) {
            AL.destroy();
            throw e;
        }
    }

    public static void destroy() {
        Class<?> clazz;
        if (context != null) {
            ALC.alcDestroyContext(AL.context.context);
            context = null;
        }
        if (device != null) {
            ALC.alcCloseDevice(AL.device.device);
            device = null;
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.lwjgl.openal.AL10");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AL.resetNativeStubs(clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.lwjgl.openal.ALC");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AL.resetNativeStubs(clazz2);
        deviceArguments = null;
        contextFrequency = -1;
        contextRefresh = -1;
        contextSynchronized = 0;
        if (created) {
            AL.nDestroy();
        }
        created = false;
    }

    private static String getPathFromJWS(String libname) {
        try {
            Sys.log("getPathFromJWS: searching for: " + libname);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.lwjgl.openal.AL");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ClassLoader o = clazz.getClassLoader();
            Class<?> c = o.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method findLibrary = c.getMethod("findLibrary", classArray);
            Object[] arguments = new Object[]{libname};
            return (String)findLibrary.invoke((Object)o, arguments);
        }
        catch (Exception e) {
            Sys.log("Failure locating OpenAL using classloader:" + e);
            return null;
        }
    }

    private static native void resetNativeStubs(Class var0);

    public static Object getContext() {
        return context;
    }
}

