/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.texgen;

import com.shavenpuppy.jglib.Image;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.resources.ImageWrapper;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.Element;

public class ShadowResource
extends Resource
implements ImageWrapper {
    public static final long serialVersionUID = 1L;
    private String url;
    private transient Image shadow;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.texgen.ShadowResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ShadowResource(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.url = XMLUtil.getString(element, "url");
    }

    protected void doCreate() throws Exception {
        Image image = null;
        ImageWrapper imageResource = null;
        if (this.url != null) {
            if (this.url.startsWith("classpath:")) {
                try {
                    System.out.println("Load " + this.url.substring(10));
                    image = Image.read(new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(this.url.substring(10))));
                }
                catch (IOException e) {
                    System.out.println("Failed to load system resource: " + this.url.substring(10));
                    throw e;
                }
            } else if (this.url.startsWith("resource:")) {
                imageResource = (ImageWrapper)((Object)Resources.get(this.url.substring(9)));
            } else {
                image = Image.read(new BufferedInputStream(new URL(this.url).openStream()));
            }
        }
        if (imageResource != null) {
            image = imageResource.getImage();
        }
        if (image == null) {
            throw new Exception("No image specified for shadow " + this);
        }
        this.shadow = new Image(image.getWidth() >> 1, image.getHeight() >> 1, 3);
        switch (image.getType()) {
            case 2: {
                this.createFromLuminance(image);
                break;
            }
            case 3: {
                this.createFromAlpha(image, 1);
                break;
            }
            case 0: 
            case 6: {
                this.createFromRGB(image);
                break;
            }
            case 4: 
            case 5: {
                this.createFromAlpha(image, 0);
                break;
            }
            case 1: 
            case 7: {
                this.createFromAlpha(image, 3);
                break;
            }
            default: {
                throw new Exception("Unsupported source image format.");
            }
        }
        image.dispose();
        this.shadow.getData().flip();
    }

    private void createFromLuminance(Image image) {
        int y = 0;
        while (y < this.shadow.getHeight()) {
            image.getData().position(y * image.getWidth() * 2);
            int x = 0;
            while (x < this.shadow.getWidth()) {
                this.shadow.getData().put((byte)-1);
                this.shadow.getData().put(image.getData().get());
                image.getData().get();
                ++x;
            }
            ++y;
        }
    }

    private void createFromAlpha(Image image, int offset) {
        int shift;
        switch (image.getType()) {
            case 3: {
                shift = 2;
                break;
            }
            default: {
                shift = 3;
            }
        }
        int y = 0;
        while (y < this.shadow.getHeight()) {
            int pos = (y << shift) * image.getWidth() + offset;
            int x = 0;
            while (x < this.shadow.getWidth()) {
                this.shadow.getData().put((byte)-1);
                this.shadow.getData().put(image.getData().get(pos + (x << shift)));
                ++x;
            }
            ++y;
        }
    }

    private void createFromRGB(Image image) {
        int y = 0;
        while (y < this.shadow.getHeight()) {
            int pos = y * image.getWidth() * 2;
            int x = 0;
            while (x < this.shadow.getWidth()) {
                image.getData().position(pos + x * 6);
                int r = image.getData().get() & 0xFF;
                int g = image.getData().get() & 0xFF;
                int b = image.getData().get() & 0xFF;
                this.shadow.getData().put((byte)-1);
                this.shadow.getData().put((byte)((float)(r + g + b) * 0.333333f));
                ++x;
            }
            ++y;
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.shadow = null;
    }

    public Image getImage() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError();
        }
        return this.shadow;
    }
}

