/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Memory;
import com.shavenpuppy.jglib.MultiBuffer;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.algorithms.RadixSort;
import com.shavenpuppy.jglib.opengl.GLTexture;
import com.shavenpuppy.jglib.opengl.nvidia.AGPMemory;
import com.shavenpuppy.jglib.opengl.nvidia.GLFence;
import com.shavenpuppy.jglib.sprites.FlashStyle;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.sprites.Style;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.Color;
import org.lwjgl.util.WritableColor;

class SpriteRenderer
extends Resource {
    private static final Vector3i offset = new Vector3i();
    private Memory memory;
    private MultiBuffer buffer;
    private FloatBuffer texCoordBuffer;
    private ByteBuffer colorBuffer;
    private final RadixSort sort = new RadixSort();
    private static final int NO_SCALE = FPMath.ONE;
    private static final boolean DEBUG = false;
    private float alpha;
    private final int[] sort_z;
    private final int[] sort_y;
    private final int[] sort_layer;
    private final int[] sort_style;
    private final int[] sort_texture;
    private GLFence fence;
    private static final Color color = new Color();
    private final boolean sortY;
    private TextureRun[] textureRun;
    private int numTextureRuns;
    private final Sprite[] sprite;
    private final Style[] style;
    private int numSprites;
    private final int maxSprites;
    private static final int VERTEX_SIZE = 32;
    private static final int TEXTURE_COORD_OFFSET = 12;
    private static final int COLOR_OFFSET = 20;
    private static final int SPRITE_SIZE = 128;

    SpriteRenderer(boolean sortY, int maxSprites) {
        this.sortY = sortY;
        this.maxSprites = maxSprites;
        this.textureRun = new TextureRun[maxSprites];
        int i = 0;
        while (i < maxSprites) {
            this.textureRun[i] = new TextureRun();
            ++i;
        }
        this.sprite = new Sprite[maxSprites];
        this.style = new Style[maxSprites];
        this.sort_layer = new int[maxSprites];
        this.sort_texture = new int[maxSprites];
        this.sort_style = new int[maxSprites];
        this.sort_z = new int[maxSprites];
        this.sort_y = new int[maxSprites];
        this.sort.resetIndices();
    }

    protected void doCreate() throws Exception {
        if (GLContext.GL_NV_vertex_array_range || GLContext.GL_NV_vertex_array_range2) {
            this.fence = new GLFence();
            this.fence.create();
        }
        this.memory = AGPMemory.allocate(this.maxSprites * 128);
        this.buffer = new MultiBuffer(this.memory.getBuffer());
        this.texCoordBuffer = Memory.chop(this.buffer.bytes, 12).asFloatBuffer();
        this.colorBuffer = Memory.chop(this.buffer.bytes, 20);
        if (FlashStyle.instance == null) {
            FlashStyle.instance = new FlashStyle("flash.style");
            FlashStyle.instance.create();
        }
    }

    protected void doDestroy() {
        this.buffer = null;
        this.texCoordBuffer = null;
        this.colorBuffer = null;
        if (this.fence != null) {
            this.fence.destroy();
            this.fence = null;
        }
        this.memory.destroy();
        this.memory = null;
    }

    public void render(Sprite s) {
        if (s.getImage() == null) {
            return;
        }
        if (s.isFlashing()) {
            if (GLContext.GL_EXT_secondary_color) {
                this.style[this.numSprites] = FlashStyle.instance;
                this.sprite[this.numSprites++] = s;
            } else {
                this.style[this.numSprites] = s.getImage().getStyle();
                this.sprite[this.numSprites++] = s;
                this.style[this.numSprites] = FlashStyle.instance;
                this.sprite[this.numSprites++] = s;
            }
        } else {
            this.style[this.numSprites] = s.getImage().getStyle();
            this.sprite[this.numSprites++] = s;
        }
    }

    private void writeSpriteToBuffer(int i, Sprite s) {
        int scaledy01;
        int scaledy11;
        int scaledy10;
        int scaledy00;
        int scaledx01;
        int scaledx11;
        int scaledx10;
        int scaledx00;
        SpriteImage image = s.getImage();
        int w = image.getWidth();
        int h = image.getHeight();
        float tx0 = image.getTx0();
        float tx1 = image.getTx1();
        float ty0 = image.getTy0();
        float ty1 = image.getTy1();
        int scale = s.getScale();
        s.getOffset(offset);
        int x = s.getX();
        int y = s.getY();
        int z = s.getZ();
        int alpha = (int)(this.alpha * (float)s.getAlpha());
        int angle = s.getAngle();
        int scaledx0 = offset.getX() - image.getHotspotX();
        int scaledy0 = offset.getY() - image.getHotspotY();
        int scaledx1 = scaledx0 + w;
        int scaledy1 = scaledy0 + h;
        if (scale != NO_SCALE) {
            scaledx0 = FPMath.mul(scaledx0, scale);
            scaledx1 = FPMath.mul(scaledx1, scale);
            scaledy0 = FPMath.mul(scaledy0, scale);
            scaledy1 = FPMath.mul(scaledy1, scale);
        }
        if (angle != 0) {
            int cos = FPMath.cos(angle);
            int sin = FPMath.sin(angle);
            scaledx00 = FPMath.mul(cos, scaledx0) - FPMath.mul(sin, scaledy0);
            scaledx10 = FPMath.mul(cos, scaledx1) - FPMath.mul(sin, scaledy0);
            scaledx11 = FPMath.mul(cos, scaledx1) - FPMath.mul(sin, scaledy1);
            scaledx01 = FPMath.mul(cos, scaledx0) - FPMath.mul(sin, scaledy1);
            scaledy00 = FPMath.mul(sin, scaledx0) + FPMath.mul(cos, scaledy0);
            scaledy10 = FPMath.mul(sin, scaledx1) + FPMath.mul(cos, scaledy0);
            scaledy11 = FPMath.mul(sin, scaledx1) + FPMath.mul(cos, scaledy1);
            scaledy01 = FPMath.mul(sin, scaledx0) + FPMath.mul(cos, scaledy1);
        } else {
            scaledx00 = scaledx0;
            scaledx10 = scaledx1;
            scaledx11 = scaledx1;
            scaledx01 = scaledx0;
            scaledy00 = scaledy0;
            scaledy10 = scaledy0;
            scaledy11 = scaledy1;
            scaledy01 = scaledy1;
        }
        int x00 = scaledx00 + x;
        int x01 = scaledx01 + x;
        int x11 = scaledx11 + x;
        int x10 = scaledx10 + x;
        int y00 = scaledy00 + y;
        int y01 = scaledy01 + y;
        int y11 = scaledy11 + y;
        int y10 = scaledy10 + y;
        this.buffer.floats.position((i *= 128) >> 2);
        this.buffer.floats.put(x00);
        this.buffer.floats.put(y00);
        this.buffer.floats.put(z);
        this.buffer.floats.put(tx0);
        this.buffer.floats.put(ty1);
        this.buffer.bytes.position(i + 20);
        s.getColor(0, (WritableColor)color);
        this.buffer.bytes.put(color.getRedByte());
        this.buffer.bytes.put(color.getGreenByte());
        this.buffer.bytes.put(color.getBlueByte());
        this.buffer.bytes.put((byte)(color.getAlpha() * alpha >> 8));
        this.buffer.floats.position((i += 32) >> 2);
        this.buffer.floats.put(x10);
        this.buffer.floats.put(y10);
        this.buffer.floats.put(z);
        this.buffer.floats.put(tx1);
        this.buffer.floats.put(ty1);
        this.buffer.bytes.position(i + 20);
        s.getColor(1, (WritableColor)color);
        this.buffer.bytes.put(color.getRedByte());
        this.buffer.bytes.put(color.getGreenByte());
        this.buffer.bytes.put(color.getBlueByte());
        this.buffer.bytes.put((byte)(color.getAlpha() * alpha >> 8));
        this.buffer.floats.position((i += 32) >> 2);
        this.buffer.floats.put(x11);
        this.buffer.floats.put(y11);
        this.buffer.floats.put(z);
        this.buffer.floats.put(tx1);
        this.buffer.floats.put(ty0);
        this.buffer.bytes.position(i + 20);
        s.getColor(2, (WritableColor)color);
        this.buffer.bytes.put(color.getRedByte());
        this.buffer.bytes.put(color.getGreenByte());
        this.buffer.bytes.put(color.getBlueByte());
        this.buffer.bytes.put((byte)(color.getAlpha() * alpha >> 8));
        this.buffer.floats.position((i += 32) >> 2);
        this.buffer.floats.put(x01);
        this.buffer.floats.put(y01);
        this.buffer.floats.put(z);
        this.buffer.floats.put(tx0);
        this.buffer.floats.put(ty0);
        this.buffer.bytes.position(i + 20);
        s.getColor(3, (WritableColor)color);
        this.buffer.bytes.put(color.getRedByte());
        this.buffer.bytes.put(color.getGreenByte());
        this.buffer.bytes.put(color.getBlueByte());
        this.buffer.bytes.put((byte)(color.getAlpha() * alpha >> 8));
    }

    public void postRender() {
        if (this.numSprites == 0) {
            return;
        }
        this.sort();
        this.build();
        GL11.glEnableClientState((int)32884);
        GL11.glVertexPointer((int)3, (int)32, (FloatBuffer)this.buffer.floats);
        GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)this.texCoordBuffer);
        GL11.glColorPointer((int)4, (boolean)true, (int)32, (ByteBuffer)this.colorBuffer);
        if (GLContext.GL_NV_vertex_array_range2) {
            GL11.glEnableClientState((int)34099);
        } else if (GLContext.GL_NV_vertex_array_range) {
            GL11.glEnableClientState((int)34077);
        }
        int i = 0;
        while (i < this.numTextureRuns) {
            this.textureRun[i].render();
            ++i;
        }
        if (this.numTextureRuns > 0) {
            this.textureRun[this.numTextureRuns - 1].done();
        }
        if (GLContext.GL_NV_vertex_array_range || GLContext.GL_NV_vertex_array_range2) {
            this.fence.set(34034);
            if (GLContext.GL_NV_vertex_array_range2) {
                GL11.glDisableClientState((int)34099);
            } else if (GLContext.GL_NV_vertex_array_range) {
                GL11.glDisableClientState((int)34077);
            }
        }
    }

    private void build() {
        GLTexture currentTexture = null;
        Style currentStyle = null;
        TextureRun currentTextureRun = null;
        int[] index = this.sort.getIndices();
        int i = 0;
        while (i < this.numSprites) {
            Sprite s = this.sprite[index[i]];
            SpriteImage image = s.getImage();
            GLTexture newTexture = image.getTexture();
            Style newStyle = this.style[index[i]];
            if (newTexture != currentTexture || newStyle != currentStyle) {
                currentTexture = newTexture;
                currentStyle = newStyle;
                currentTextureRun = this.textureRun[this.numTextureRuns++];
                currentTextureRun.init(newTexture, newStyle, i);
            }
            currentTextureRun.add();
            this.writeSpriteToBuffer(i, s);
            ++i;
        }
        this.buffer.floats.flip();
    }

    public void preRender() {
        this.numSprites = 0;
        this.numTextureRuns = 0;
        this.buffer.floats.clear();
        this.buffer.bytes.clear();
        this.buffer.ints.clear();
        if (GLContext.GL_NV_vertex_array_range || GLContext.GL_NV_vertex_array_range2) {
            this.fence.finish();
        }
    }

    private void sort() {
        int n = this.numSprites;
        int i = 0;
        while (i < n) {
            Sprite s = this.sprite[i];
            this.sort_y[i] = -s.getY();
            this.sort_z[i] = s.getZ();
            this.sort_layer[i] = s.getLayer();
            SpriteImage si = s.getImage();
            this.sort_texture[i] = si.getTexture().getID();
            this.sort_style[i] = this.style[i].getStyleID();
            ++i;
        }
        this.sort.resetIndices().sort(this.sort_texture, n).sort(this.sort_style, n).sort(this.sort_y, n).sort(this.sort_z, n).sort(this.sort_layer, n);
    }

    void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    private static final class TextureRun {
        private static GLTexture lastRenderedTexture;
        private static Style lastRenderedStyle;
        GLTexture texture;
        Style style;
        int offset;
        int spritesToRender;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.shavenpuppy.jglib.sprites.SpriteRenderer$TextureRun");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        TextureRun() {
        }

        void init(GLTexture texture, Style style, int offset) {
            this.texture = texture;
            if (!$assertionsDisabled && texture == null) {
                throw new AssertionError();
            }
            this.style = style;
            if (!$assertionsDisabled && style == null) {
                throw new AssertionError();
            }
            this.offset = offset;
            this.spritesToRender = 0;
        }

        void add() {
            ++this.spritesToRender;
        }

        void render() {
            if (this.texture != lastRenderedTexture) {
                this.texture.render();
                lastRenderedTexture = this.texture;
            }
            if (this.style != lastRenderedStyle) {
                if (lastRenderedStyle != null) {
                    lastRenderedStyle.resetState();
                }
                this.style.setupState();
                lastRenderedStyle = this.style;
            }
            GL11.glDrawArrays((int)7, (int)(this.offset << 2), (int)(this.spritesToRender << 2));
        }

        void done() {
            if (lastRenderedStyle != null) {
                lastRenderedStyle.resetState();
            }
            lastRenderedStyle = null;
            lastRenderedTexture = null;
        }
    }
}

