/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteEngine;
import com.shavenpuppy.jglib.sprites.SpriteRenderer;
import java.util.ArrayList;
import org.lwjgl.Sys;

public class ResizingSpriteEngine
extends Resource
implements SpriteEngine {
    private ArrayList sprites;
    private int numAllocated;
    private int numVisible;
    private SpriteRenderer renderer;
    private int tickRate;
    private boolean sortY;
    private float alpha = 1.0f;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.sprites.ResizingSpriteEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ResizingSpriteEngine(boolean sortY, int initialSprites, int tickRate) throws Exception {
        if (!$assertionsDisabled && tickRate <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && initialSprites <= 0) {
            throw new AssertionError();
        }
        this.sprites = new ArrayList(initialSprites);
        this.tickRate = tickRate;
        this.sortY = sortY;
        int i = 0;
        while (i < initialSprites) {
            Sprite spr = new Sprite(this);
            spr.index = i++;
            this.sprites.add(spr);
        }
        this.renderer = new SpriteRenderer(sortY, initialSprites);
    }

    protected void doCreate() throws Exception {
        this.renderer.create();
    }

    protected void doDestroy() {
        this.renderer.destroy();
    }

    public void setTickRate(int newTickRate) {
        this.tickRate = newTickRate;
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public Sprite allocate(Object owner) {
        if (this.numAllocated == this.sprites.size()) {
            Sys.log((String)"Resizing sprite engine");
            int newSize = Math.min((this.sprites.size() + 1) * 2, this.sprites.size() + 128);
            this.sprites.ensureCapacity(newSize);
            Sys.log((String)("\tNew size:" + newSize));
            int i = this.numAllocated;
            while (i < newSize) {
                Sprite spr = new Sprite(this);
                spr.index = i++;
                this.sprites.add(spr);
            }
            this.renderer.destroy();
            this.renderer = null;
            this.renderer = new SpriteRenderer(this.sortY, this.sprites.size());
            try {
                this.renderer.create();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to resize the sprite engine to " + newSize + " sprites", e);
            }
        }
        if (!$assertionsDisabled && owner == null) {
            throw new AssertionError();
        }
        Sprite s = (Sprite)this.sprites.get(this.numAllocated++);
        s.init(owner);
        return s;
    }

    public void deallocate(Sprite deallocSpr) {
        this.sprites.set(deallocSpr.index, this.sprites.get(--this.numAllocated));
        ((Sprite)this.sprites.get((int)deallocSpr.index)).index = deallocSpr.index;
        this.sprites.set(this.numAllocated, deallocSpr);
        deallocSpr.index = this.numAllocated;
    }

    public void clear() {
        int i = 0;
        while (i < this.sprites.size()) {
            ((Sprite)this.sprites.get(i)).deallocate();
            ++i;
        }
        this.numAllocated = 0;
    }

    public void tick() {
        int n = this.numAllocated;
        int i = 0;
        while (i < n) {
            Sprite s = (Sprite)this.sprites.get(i);
            if (s.isActive()) {
                s.tick();
            }
            ++i;
        }
    }

    public void render() {
        this.numVisible = 0;
        int n = this.numAllocated;
        this.renderer.setAlpha(1.0f);
        this.renderer.preRender();
        int i = 0;
        while (i < n) {
            Sprite s = (Sprite)this.sprites.get(i);
            if (s.isVisible() && s.isActive()) {
                this.renderer.render(s);
                ++this.numVisible;
            }
            ++i;
        }
        this.renderer.postRender();
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }
}

