/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sound;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Wave;
import com.shavenpuppy.jglib.resources.WaveWrapper;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.Sys;
import org.w3c.dom.Element;

public class OggVorbis
extends Resource
implements WaveWrapper {
    public static final long serialVersionUID = 1L;
    private static int convsize;
    private static byte[] convbuffer;
    private static String cacheDirectory;
    private String url;
    private transient Wave wave;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.sound.OggVorbis");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        convsize = 8192;
        convbuffer = new byte[convsize];
    }

    public OggVorbis() {
    }

    public OggVorbis(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.url = XMLUtil.getString(element, "url");
    }

    /*
     * Unable to fully structure code
     */
    protected void doCreate() throws Exception {
        cached = null;
        if (OggVorbis.cacheDirectory != null) {
            try {
                cacheName = this.url.startsWith("classpath:") != false ? String.valueOf(this.url.substring(10)) + ".wave" : String.valueOf(new URL(this.url).getFile()) + ".wave";
                cached = new File(String.valueOf(OggVorbis.cacheDirectory) + File.separator + cacheName);
                if (cached.exists()) {
                    this.wave = Wave.read(new BufferedInputStream(new FileInputStream(cached)));
                    Sys.log((String)("Loaded " + this.url + " from cache."));
                }
            }
            catch (Exception e) {
                Sys.log((String)("Failed to load " + this.url + " from cache."));
            }
            if (this.wave != null) {
                return;
            }
        }
        input = this.url.startsWith("classpath:") != false ? new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(this.url.substring(10))) : new BufferedInputStream(new URL(this.url).openStream());
        if (Sys.DEBUG) {
            System.out.println("Loading: " + this.url);
        }
        oy = new SyncState();
        os = new StreamState();
        og = new Page();
        op = new Packet();
        vi = new Info();
        vc = new Comment();
        vd = new DspState();
        vb = new Block(vd);
        bytes = 0;
        output = new ByteArrayOutputStream(0x400000);
        oy.init();
        frequency = 0;
        type = 0;
        inited = false;
        while (true) {
            block47: {
                block46: {
                    eos = false;
                    index = oy.buffer(4096);
                    buffer = oy.data;
                    bytes = input.read(buffer, index, 4096);
                    oy.wrote(bytes);
                    if (oy.pageout(og) != 1) {
                        if (bytes < 4096) break;
                        throw new Exception("Input does not appear to be an Ogg bitstream.");
                    }
                    os.init(og.serialno());
                    vi.init();
                    vc.init();
                    if (os.pagein(og) < 0) {
                        throw new Exception("Error reading first page of Ogg bitstream data.");
                    }
                    if (os.packetout(op) != 1) {
                        throw new Exception("Error reading initial header packet.");
                    }
                    if (vi.synthesis_headerin(vc, op) < 0) {
                        throw new Exception("This Ogg bitstream does not contain Vorbis audio data.");
                    }
                    i = 0;
                    break block46;
                    while ((result = oy.pageout(og)) != 0) {
                        if (result == 1) {
                            os.pagein(og);
                            while (i < 2) {
                                result = os.packetout(op);
                                if (result == 0) break;
                                if (result == -1) {
                                    throw new Exception("Corrupt secondary header. Exiting.");
                                }
                                vi.synthesis_headerin(vc, op);
                                ++i;
                            }
                        }
lbl65:
                        // 5 sources

                        ** while (i >= 2)
lbl66:
                        // 1 sources

                    }
lbl67:
                    // 2 sources

                    if ((bytes = input.read(buffer = oy.data, index = oy.buffer(4096), 4096)) == 0 && i < 2) {
                        throw new Exception("End of file before finding all Vorbis headers!");
                    }
                    oy.wrote(bytes);
                }
                if (i < 2) ** GOTO lbl65
                switch (vi.channels) {
                    case 1: {
                        newType = 1;
                        break;
                    }
                    case 2: {
                        newType = 3;
                        break;
                    }
                    default: {
                        throw new Exception("Wave format only supports mono or stereo: this OGG has " + vi.channels + " channels.");
                    }
                }
                newFreq = vi.rate;
                if (inited) {
                    if (newType != type || newFreq != frequency) {
                        throw new Exception("Frequency and/or type has changed mid stream in chained OGG.");
                    }
                } else {
                    inited = true;
                    type = newType;
                    frequency = newFreq;
                }
                OggVorbis.convsize = 4096 / vi.channels;
                vd.synthesis_init(vi);
                vb.init(vd);
                _pcm = new float[1][][];
                _index = new int[vi.channels];
                break block47;
                while ((result = oy.pageout(og)) != 0) {
                    if (result == -1) {
                        System.err.println("Corrupt or missing data in bitstream; continuing...");
                    } else {
                        os.pagein(og);
                        while ((result = os.packetout(op)) != 0) {
                            if (result == -1) continue;
                            if (vb.synthesis(op) == 0) {
                                vd.synthesis_blockin(vb);
                            }
                            bigEndian = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
                            while ((samples = vd.synthesis_pcmout(_pcm, _index)) > 0) {
                                pcm = _pcm[0];
                                bout = samples < OggVorbis.convsize ? samples : OggVorbis.convsize;
                                i = 0;
                                while (i < vi.channels) {
                                    ptr = i << 1;
                                    mono = _index[i];
                                    j = 0;
                                    while (j < bout) {
                                        val = (int)((double)pcm[i][mono + j] * 32767.0);
                                        if (val > 32767) {
                                            val = 32767;
                                        } else if (val < -32768) {
                                            val = -32768;
                                        }
                                        if (val < 0) {
                                            val |= 32768;
                                        }
                                        if (bigEndian) {
                                            OggVorbis.convbuffer[ptr] = (byte)(val >>> 8);
                                            OggVorbis.convbuffer[ptr + 1] = (byte)val;
                                        } else {
                                            OggVorbis.convbuffer[ptr] = (byte)val;
                                            OggVorbis.convbuffer[ptr + 1] = (byte)(val >>> 8);
                                        }
                                        ptr += vi.channels << 1;
                                        ++j;
                                    }
                                    ++i;
                                }
                                output.write(OggVorbis.convbuffer, 0, 2 * vi.channels * bout);
                                vd.synthesis_read(bout);
                            }
                        }
                        if (og.eos() != 0) {
                            eos = true;
                        }
                    }
lbl144:
                    // 5 sources

                    ** while (eos)
lbl145:
                    // 1 sources

                }
lbl146:
                // 2 sources

                if (!eos) {
                    index = oy.buffer(4096);
                    buffer = oy.data;
                    bytes = input.read(buffer, index, 4096);
                    oy.wrote(bytes);
                    if (bytes == 0) {
                        eos = true;
                    }
                }
            }
            if (!eos) ** GOTO lbl144
            os.clear();
            vb.clear();
            vd.clear();
            vi.clear();
        }
        oy.clear();
        buf = ByteBuffer.allocateDirect(output.size()).order(ByteOrder.nativeOrder());
        buf.put(output.toByteArray());
        buf.rewind();
        if (!inited) {
            throw new Exception("Never found out the wave type!");
        }
        samples = type == 1 ? output.size() / 2 : output.size() / 4;
        this.wave = new Wave(samples, type, frequency, 0, 0, 0, buf);
        if (cached != null) {
            try {
                fos = new FileOutputStream(cached);
                Wave.write(this.wave, new BufferedOutputStream(fos));
                fos.flush();
                fos.close();
                Sys.log((String)("Cached " + this.url));
            }
            catch (Exception e) {
                Sys.log((String)("Failed to cache " + this.url));
            }
        }
    }

    public Wave getWave() throws Exception {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError();
        }
        if (this.wave.getData() == null) {
            this.doCreate();
        }
        return this.wave;
    }

    protected void doDestroy() {
        this.wave = null;
    }

    public static void setCacheDirectory(String cache) {
        cacheDirectory = cache;
    }
}

